;*** Evening Flight 256 byte Intro ***
;*** 29.11.2020 gorgh/Agenda ***


angle = $80 		;angle of the y component of the camera
columns = $81		;columns counter (0-39)
subx = $72		;sub-character position of the camera (0-7)
suby = $73
starting = $74		;pointer to the screen memory
field = $76		;pointer to the terrain map
step = $78		;length from the camera

varx = $7f		;variables used for addition
vary = $7e
angle2 = $7d		;angle of the x component of the camera
counter = $7c		;temporary variables
counter2 = $7b
rows = $7a		;number of vertical characters to calculate


 org $80
 .byte 51
 .byte 39

start
    lda #0
    jsr $ef9c		;setting graphics mode
 lda #%10000100
 sta $d201		;sound init
loop
 ldy #0
sub1
 lda #4
 and #7
 sta subx		;subx is sub-character coordinate, that is being changed to create the movement
sub2
 lda #4
 and #7
 sta suby
 lda #$40
 sta starting
 sta $d018
 lda #$bc
 sta starting+1		;restoring the beginning of screen ram
fieldLo
 lda #$10
 sta field		;changing the terrain map location byte each 8 cycles of the program
fieldHi
 lda #$da
 sta field+1
 lda #0			;resetting neccessary values
 sta step
 sta varx
 sta vary
 lda angle		;changing the angle on the next ray slightly
 adc #5
 sta angle
 eor #$ff
 sta angle2					;calculating the angles of the camera
calculating_distance
 lda varx		;angles are fraction values varying from 40 to 255
 adc angle
 sta varx
 bcc mm			
 inc subx		;changing position of the ray in subcharacter range
 lda subx
 and #7
 bne mm
 inc field		;changing position of the ray in full character range
 bne mm
 inc field+1
mm
 lda vary
 adc angle2
 sta vary
 bcc mmm
 inc suby		;changing position of the ray in subcharacter range
 lda suby
 and #7
 bne mmm
 lda field
 clc
 adc #40
 sta field		;changing position of the ray in full character range (40 bytes jump, as C flag is set here)
 bcc mmm
 inc field+1
mmm
 inc step		;increasing the ray length value
 beq out_of_range	;if ray length=256 then skip further calculations
 lda (field),y		;terrain map
 cmp #$38		;only bytes lower than 40 will be taken into accound when drawing blocks
 bcc found
 bcs calculating_distance	; repeat
found			;obstacle found
 lda step
 sta $d200		;generate sound based on a length of the current ray
 lsr
 cmp #12		;clipping to values between 0 and 11
 bcc mmmm
out_of_range
 lda #12
mmmm
 tax			;setting variables for needed height of the wall (obstacle)
 asl
 sta counter

 lda #40
 sta rows

 lda characters,x	;setting neccessary character for given distance to the wall
 sta filled+1

 lda #26
 sbc counter
 sta counter2		;screen symetrical in the horizontal axis
next_char
 ldy columns
 cpx #0
 beq filled		;chosing whether to draw empty char or wall (obstacle)
empty
 lda #0
 sta (starting),y
 dex
shared
 lda starting
 adc #39
 sta starting		;drawing takes place from the top to the bottom, column by column, distance to the next vertical character is 40
 bcc mmmmmm
 inc starting+1
mmmmmm
 dec rows
 bne next_char		;loop that draws one column, there are 24 columns visible, but the value is set to 40 for slower effect
starting_values		;after the whole column is drawn the values are restored and updated
 dec columns
 bmi done		;all columns drawn
 jmp loop		;draw next column
filled			;drawing filled characters
 lda #$ff
 sta (starting),y
 dec counter2
 bne shared		;checking if all filled characters of the column have been drawn
 ldx #30		;bottom of the screen fill with empty char
 bne shared
done
 inc sub1+1		;modifying the position of the camera when whole screen has been drawn
 inc sub2+1
 lda sub1+1
 and #7
 bne m_
 lda fieldLo+1
 clc
 adc #41
 sta fieldLo+1
 bcc m_
 inc fieldHi+1
m_ 
 lda #51		;$30-5, as in the next step angle is incremented by 5
 sta angle
 lda #40		;39+1 as in the next step variable is decremented
 sta columns
 bne starting_values	;restarting the values and the beginning of new frame
characters
   .byte 128,128,13+128,$85,3,16,6,32,5,15,2,7,14	;standard ROM characters

 run start		;sexy people use RUN :)		
