varying vec2 texCoord;
//varying vec4 vColor;
uniform sampler2D colorMap;
uniform sampler2D titleMap;
uniform sampler2D titleMask;

uniform float boostlow;
uniform float boosthigh;

uniform int abc;

uniform int swapbg;
uniform float factorr;
uniform float factorg;
uniform float factorb;
uniform float mix_;
uniform float titlefade;
uniform float yscroll;

uniform float saturation;
uniform float luminance;

uniform int dosharpen;

/*
void main (void)
{
	gl_FragColor = texture2D(colorMap, texCoord);
}
*/
//	rgb<-->hsv functions by Sam Hocevar
//	http://lolengine.net/blog/2013/07/27/rgb-to-hsv-in-glsl
vec3 rgb2hsv(vec3 c)
{
	vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
	vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
	vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

	float d = q.x - min(q.w, q.y);
	float e = 1.0e-10;
	return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c)
{
	vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
	vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
	return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

vec4 sharpen(){

float kernel[9];
float kernelinc[9];
vec2 offset[9];

float step_w = 1.0/1920.0;
float step_h = 1.0/1080.0;


        offset[0] = vec2(-step_w, -step_h);
        offset[1] = vec2(0.0, -step_h);
        offset[2] = vec2(step_w, -step_h);
        offset[3] = vec2(-step_w, 0.0);
        offset[4] = vec2(0.0, 0.0);
        offset[5] = vec2(step_w, 0.0);
        offset[6] = vec2(-step_w, step_h);
        offset[7] = vec2(0.0, step_h);
        offset[8] = vec2(step_w, step_h);


        /* SHARPEN KERNEL
         0 -1  0
        -1  5 -1
         0 -1  0
        */

        kernel[0] = 0.;
        kernel[1] = -1.;
        kernel[2] = 0.;
        kernel[3] = -1.;
        kernel[4] = 4.;
        kernel[5] = -1.;
        kernel[6] = 0.;
        kernel[7] = -1.;
        kernel[8] = 0.;

        kernelinc[0] = 0.;
        kernelinc[1] = 0.;
        kernelinc[2] = 0.;
        kernelinc[3] = 0.;
        kernelinc[4] = 1.;
        kernelinc[5] = 0.;
        kernelinc[6] = 0.;
        kernelinc[7] = 0.;
        kernelinc[8] = 0.;


        vec4 sum = vec4(0.0);
        int i;

        for (i = 0; i < 9; i++) {
                vec4 color = texture2D(colorMap, texCoord + offset[i]);
                sum += color * ((kernel[i] * dosharpen)+kernelinc[i]);
        }

        ///gl_FragColor = sum;
        return sum;

}

void main (void)
{
//vec2 nutexcoord;
//	nutexcoord=texCoord;
//	nutexcoord.x=1.0-nutexcoord.x;
vec4 currentpixel;
    if (dosharpen>0) currentpixel=sharpen(); else
    currentpixel=texture2D(colorMap, texCoord);
	vec4 color = currentpixel;///texture2D(colorMap, texCoord);

	vec4 color2= texture2D(titleMap, texCoord);
	vec4 colormask=texture2D(titleMask, vec2(titlefade,texCoord.y*10.0f+yscroll));
	float mask=colormask.r;
	color2.a=color2.a*mask;
	color=color*(1.0-color2.a)+color2*(color2.a);

	vec4 color_original = color;
	if (swapbg==1) color=color.rbga;
	float r=color.r; r*=factorr; r=clamp(r,0.0f,1.0f); color.r=r;
	float g=color.g; g*=factorg; g=clamp(g,0.0f,1.0f); color.g=g;
	float b=color.b; b*=factorb; b=clamp(b,0.0f,1.0f); color.b=b;
	if (swapbg==2) {
        color=vec4(1.0f,1.0f,1.0f,1.0f);
	}


	/// contrast boost:
    ///#define const_1 ( 16.0f / 255.0f)
    ///#define const_2 (255.0f / 219.0f)
    #define const_1 (boostlow / 255.0f)
    #define const_2 (255.0f / boosthigh)
    color= ((color - const_1) * const_2);
    color_original= ((color_original - const_1) * const_2);

	gl_FragColor = color*mix_+color_original*(1.0f-mix_);

	if (saturation!=0.0){
        vec3 hsv=rgb2hsv(gl_FragColor.rgb);
        hsv.y+=saturation;hsv.y=clamp(hsv.y,0,1);
        hsv.z+=luminance;hsv.z=clamp(hsv.z,0,1);
        vec3 rgb=hsv2rgb(hsv);
        gl_FragColor=vec4(rgb.x,rgb.y,rgb.z,1.0f);
	}
    if(luminance!=0.0){
        gl_FragColor+=vec4(vec3(luminance),1.0f);
    }
	//gl_FragColor = texture2D(colorMap, texCoord)*vColor;
	//gl_FragColor = texture2D(colorMap, nutexcoord);
}
