#version 430

// #extension GL_EXT_gpu_shader4 : require


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texWave;

//layout(binding=0, offset=0) uniform atomic_uint ac;
layout(binding=0, rgba32f) uniform image2D triangleInfo;
layout(binding=1, rgba32f) uniform image2D triangleIds;
layout(binding=2, r32i) uniform iimage2D edgeGridHeadPointers;
layout(binding=3, rgba32f) uniform image2D edgeDataCenter;
layout(binding=4, rgba32f) uniform image2D edgeDataIds;
layout(binding=5, rgba32f) uniform image2D texSpace;
//layout(binding=6, r32f) uniform image2D texSpaceWave;
// layout(binding=7, rgba32f) uniform image2D texSpace;


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];
in float bright[3];

out vec4 posG;
out vec4 posOrigG;
out vec3 normalG;
out vec3 normalWSG;
out vec2 uvG;
out vec2 uvnG;
out vec3 tangentG;
out vec3 colorG;
out vec4 posW;
out float brightG;
out float triangleIdG;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;


uniform float g_quadsPerRow = 128;
uniform float g_texW;
uniform float g_texH;
uniform float g_triangleTexDim;

uniform float g_waveDispHeight = -0.125; // the vertex displacement height

vec2 getTexCoord(vec2 c) {
    vec2 ct = vec2(c.x*g_texW, c.y*g_texH);
    return ct;
}

int getOtherTriangleId(uint thisTriangleId, uint thisTriangleEdge) {
    uint tid = thisTriangleId*3;
    uint tidy = tid/(3*int(g_triangleTexDim));
    ivec2 tidUV = ivec2(tid-uint(tidy*3*int(g_triangleTexDim))+thisTriangleEdge, tidy);
    vec4 tidi = imageLoad(triangleIds, tidUV);
    return int(round(tidi.x));
}

vec3 getTriangleVertex(uint tid, uint edge) {
    uint tid3 = tid*3;
    uint tidy = tid3/(3*int(g_triangleTexDim));
    ivec2 tidUV = ivec2(tid3-uint(tidy*3*int(g_triangleTexDim))+edge, tidy);
    vec4 tidi = imageLoad(triangleInfo, tidUV);
    return tidi.xyz;
}

ivec2 getTriangleVertexUV(uint tid, uint edge) {
    uint quadIndex = tid;
    uint quadHalf = 1;

    float quadSize = g_texW/g_quadsPerRow;
    float pid = float(quadIndex);
    float pidf = pid/g_quadsPerRow;
    float fquadX = fract(pidf);
    float fquadY = floor(pidf);

    // to target texture coordinates 0.0 - 1.0x
    float fquadSW = quadSize/g_texW;
    float fquadSH = quadSize/g_texH;
    fquadY *= fquadSH;

    int quadX = int(floor(fquadX*g_texW));
    int quadY = int(floor(fquadY*g_texH));
    int quadSW = int(floor(fquadSW*g_texW))-1;
    int quadSH = int(floor(fquadSH*g_texH))-1;

    ivec2 result = ivec2(0);

    if (quadHalf==0) {
        if (edge==0) {
            result = ivec2(quadX, quadY);
        } else if (edge==1) {
            result = ivec2(quadX+quadSW, quadY);
        } else if (edge==2) {
            result = ivec2(quadX, quadY+quadSH);
        }
      //    uvG = vec2(0.0);
    } else {
        if (edge==0) {
            result = ivec2(quadX+quadSW, quadY+quadSH);
        } else if (edge==1) {
            result = ivec2(quadX, quadY+quadSH);
        } else if (edge==2) {
            result = ivec2(quadX+quadSW, quadY);
        }
    }

    return result;
}

int getClosestVertex(int tid, vec3 pos) {
    float d, d2;
    vec3 dd;
    int closest = 0;

    vec3 v0 = getTriangleVertex(tid, 0);
    vec3 v1 = getTriangleVertex(tid, 1);
    vec3 v2 = getTriangleVertex(tid, 2);

    dd = v0-pos;
    d = dot(dd, dd);
    dd = v1-pos;
    d2 = dot(dd,dd);
    if (d2<d) {
        d = d2;
        closest = 1;
    }
    dd = v2-pos;
    d2 = dot(dd,dd);
    if (d2<d) {
        d = d2;
        closest = 2;
    }
    return closest;
}

// process for rotating around all triangles of a vertex:
// tid: (this) triangle id, otid: other triangle id
// int cv = getClosestVertex(tid);
// int otid = -1;
// int loops = 0;
// while (otid != tid && loops<32) {
//   otid = getOtherTriangleId(tid, cv);
//   cv = getClosestVertex(otid);
//   loops++;
// }


vec3 getTriangleVertexColor(int tid, vec3 pos) {
    int cv = getClosestVertex(tid, pos);
    int otid = -1;
    int loops = 0;
    vec3 result = vec3(0.0);
    while (otid != tid && loops<32) {
        if (otid == -1) otid = tid;
        ivec2 vuv = getTriangleVertexUV(otid, cv);
        result += texelFetch(texWave, vuv, 0).rgb;
        otid = getOtherTriangleId(otid, cv);
        if (otid == -1) break;
        cv = getClosestVertex(otid, pos);
        loops++;
    }
    return result/float(loops);
}

void main(void) {

//    uint quadIndex = gl_PrimitiveIDIn/2;
//    uint quadHalf = gl_PrimitiveIDIn&1;
    uint quadIndex = gl_PrimitiveIDIn;
    uint quadHalf = 1; //gl_PrimitiveIDIn&1;

  //  uint counter = atomicCounterIncrement(ac);

    //gl_PrimitiveID = gl_PrimitiveIDIn;

    float quadSize = g_texW/g_quadsPerRow;
    float pid = float(quadIndex);
    float pidf = pid/g_quadsPerRow;
    float quadX = fract(pidf);
    float quadY = floor(pidf);


    // to target texture coordinates 0.0 - 1.0x
    float quadSW = quadSize/g_texW;
    float quadSH = quadSize/g_texH;
    //quadX *= ;
    quadY *= quadSH;

    vec3 faceNormal = vec3(0.0);
    vec4 facePos = vec4(0.0);

    triangleIdG = quadIndex+1;
    int tid = int(quadIndex);
    vec4 wat;

//wat = imageLoad(texSpace, ivec2(quadX*g_texW+g_time*10.0, quadY*g_texH+g_time*10.0));
//wat = imageLoad(texSpace, ivec2(floor(quadX*g_texW), floor(quadY*g_texH))+ivec2(8,8));

    vec4 myPos;

    tangentG = normalize((gl_in[1].gl_Position-gl_in[0].gl_Position).xyz);
    tangentG = (modelMatrix * vec4(tangentG, 0.0)).xyz;

    for (int i = 0; i < 3; ++i) { // gl_in.length(); ++i) {
            gl_Position = gl_in[i].gl_Position;
            facePos += origPos[i];
            posW = modelMatrix*gl_Position;


            posOrigG = gl_Position;



            normalG = normal[i];
            colorG = vec3(1.0, 1.0, 1.0)/6.0*float(1.0+gl_PrimitiveIDIn%6);

            vec4 jk = (modelMatrix * vec4(normalG, 0.0));
            normalWSG = jk.xyz;
            normalG = (modelMatrix * vec4(normalG, 0.0)).xyz;

            brightG = bright[i];

            faceNormal += normal[i];

            myPos = gl_Position;

            if (quadHalf==0) {
                if (i==0) {
                    uvG = vec2(quadX, quadY);
                } else if (i==1) {
                    uvG = vec2(quadX+quadSW, quadY);
                } else if (i==2) {
                    uvG = vec2(quadX, quadY+quadSH);
                }
              //    uvG = vec2(0.0);
            } else {

                float mg=0.0;
                if (i==0) {
                    uvG = vec2(quadX+quadSW, quadY+quadSH);
                    uvnG = uvG+mg*vec2(-0.0/g_texW, -0.0/g_texH);

                //    wat = imageLoad(texSpace, ivec2(floor(uvG.x*g_texW), floor(uvG.y*g_texH))+ivec2(-1,-1));
                    wat = imageLoad(texSpace, getTriangleVertexUV(tid, 0));
                 //   wat.rgb = getTriangleVertexColor(tid, posOrigG.xyz);
                } else if (i==1) {
                    uvG = vec2(quadX, quadY+quadSH);
                    uvnG = uvG+mg*vec2(0.50/g_texW, -0.0/g_texH);
                   // wat = imageLoad(texSpace, ivec2(floor(uvG.x*g_texW), floor(uvG.y*g_texH))+ivec2(0,-1));
                   wat = imageLoad(texSpace, getTriangleVertexUV(tid, 1));
                 //  wat.rgb = getTriangleVertexColor(tid, posOrigG.xyz);
                } else if (i==2) {
                    uvG = vec2(quadX+quadSW, quadY);
                    uvnG = uvG+mg*vec2(-0.0/g_texW, 0.0/g_texH);
                   // wat = imageLoad(texSpace, ivec2(floor(uvG.x*g_texW), floor(uvG.y*g_texH))+ivec2(-1,0));
                   wat = imageLoad(texSpace, getTriangleVertexUV(tid, 2));
                 //  wat.rgb = getTriangleVertexColor(tid, posOrigG.xyz);
                }

                wat.rgb = getTriangleVertexColor(tid, posOrigG.xyz);

                wat.r += 0.0;
                float po = 0.50;
                float wei = g_waveDispHeight;
                //wei = 0.0;
                if (wat.r > 0.0) {
                    myPos.xyz += normalize(normal[i])*(pow(abs(wat.r), po))*wei;
                } else {
                   myPos.xyz -= normalize(normal[i])*(pow(abs(wat.r), po))*wei;
                }
                colorG.rgb = wat.rgb;
             //   colorG.rg = uvG.xy;
            //     uvG = vec2(0.0);
            }
            posG = projectionMatrix * modelViewMatrix * myPos;
            gl_Position = posG;

            // uvG = uv[i];


     //       tangentG = tangent[i];

//if (dot(dirTest.xy, koe) > 0) {
////    tangentG = vec3(0.0);
//}
//koe = vec2(0.0, 1.0);
//if (dot(dirTest.xy, koe) > 0) {
// //   tangentG = vec3(0.0);
//}

            EmitVertex();
    }
    facePos /= 3.0;

    EndPrimitive();

}
