#version 430

uniform mat4 projectionMatrix;
uniform mat4 modelMatrix;
uniform mat4 modelViewMatrix;

layout (location=0) in vec3 vertexPosition;
layout (location=1) in vec3 vertexNormal;
layout (location=2) in vec2 vertexUV;
// layout (location=3) in vec3 vertexTangent;

out vec4 posModel;
out vec4 posWorld;
out vec4 posView;
out vec3 normal;
out vec2 uv;

uniform mat4 prevModelMatrix;
uniform mat4 prevViewMatrix;
out vec4 prevPos;


uniform float g_time;

#define PI 3.141592

void main() {
    vec4 vp = vec4(vertexPosition, 1.0);

    normal = vertexNormal;
    uv = vertexUV;
    posModel = vp;
    posWorld = modelMatrix*vp;
    posView = modelViewMatrix*vp;


    prevPos = prevModelMatrix*vp;


    normal = (modelViewMatrix*vec4(normal, 0.0)).xyz;
    normal = -normalize(normal);


    // posWorld /= posWorld.w;
    gl_Position = projectionMatrix*posView;

}
