#version 430

// layout (location=0) in vec3 vertexPosition;

out int qiG;
out int idG;
/*
out vec2 uv;
out float br;

out vec2 puv;

//out float foc;

out vec3 pw;
out vec3 pv;

out vec3 pView;
*/
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 viewMatrix;
uniform mat4 projectionInvMatrix;
uniform float g_windowWidth;
uniform float g_windowHeight;

uniform float g_time;

uniform float size = 32.0;
uniform float rot;

vec2 rot2(vec2 p, float a) {
  vec2 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

float zn = 0.0;
float zf = 1.0;


vec4 CalcEyeFromWindow(in vec3 windowSpace) {
    vec3 ndcPos;
    vec4 viewport = vec4(0.0, 0.0, g_windowWidth, g_windowHeight);
    ndcPos.xy = ((2.0 * windowSpace.xy) - (2.0 * viewport.xy)) / (viewport.zw) - 1;
    ndcPos.z = (2.0 * windowSpace.z - zn - zf) / (zf - zn);
    vec4 clipPos;
    clipPos.w = projectionMatrix[3][2]/(ndcPos.z-(projectionMatrix[2][2]/projectionMatrix[2][3]));
    clipPos.xyz = ndcPos * clipPos.w;
    return projectionInvMatrix * clipPos;
}

layout(binding=0, rgba32f) uniform image2D pardexPos;
layout(binding=1, r32i) uniform iimage2D pardexOfs;

layout(binding=3, rgba32f) uniform image2D pardexAge;

uniform float drawSize = 1.0;

ivec2 getTrip(int idt) {
    ivec2 triBufSize = imageSize(pardexPos)/2;
    ivec2 trip;
    trip.y = idt/triBufSize.x;
    trip.x = idt-trip.y*triBufSize.x;
   // trip.y = 0;
    return trip;
}

uniform float simMode = 0.0;


void main() {
  vec4 vp = vec4(0.0);

  float id = float(gl_VertexID);

  int qi = int(id);
  idG = qi;
  qiG = imageLoad(pardexOfs, getTrip(qi)).x;

}
