#version 430


in vec2 uv;

layout(location = 0) out vec4 frag;
// layout(location = 1) out vec4 frag2;

uniform float g_time;
/*
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec3 tonemapUC2(vec3 x) {
    float A = 0.15;
    float B = 0.50;
    float C = 0.10;
    float D = 0.20;
    float E = 0.02;
    float F = 0.30;
    return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}
*/
uniform float flip=1.0;

uniform float overlayAlpha=1.0;


layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texPrev;

uniform vec4 g_prevAmount = vec4(0.5, 0.5, 0.5, 1.0); // RGB and A for all
uniform vec4 g_prevPow = vec4(1.0, 1.0, 1.0, 1.0); // RGB powers and A is for all

void main() {

    vec2 uvS = uv;
    uvS.y = 1.0-uvS.y;

    //vec4 screen = texture2D(tex, uvS+vec2(0.0, 0.0));

    vec4 screen = texelFetch(tex, ivec2(gl_FragCoord.xy), 0);

    vec4 prev = texture2D(texPrev, uvS);

    prev.rgb = pow(prev.rgb, g_prevPow.rgb*g_prevPow.a);
    screen.rgb = clamp(screen.rgb*(vec3(1.0)-g_prevAmount.rgb*g_prevAmount.a)+prev.rgb*g_prevAmount.rgb*g_prevAmount.a, 0.0, 100.0);
    // screen.a = 1.0;
    frag = screen;
}

