#version 430

layout(binding=0) uniform sampler2D tex;

in vec2 uv;

layout(location = 0) out vec4 frag;
// layout(location = 1) out vec4 frag2;

uniform float g_time;
/*
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec3 tonemapUC2(vec3 x) {
    float A = 0.15;
    float B = 0.50;
    float C = 0.10;
    float D = 0.20;
    float E = 0.02;
    float F = 0.30;
    return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}
*/
uniform float flip=1.0;

uniform float overlayAlpha=1.0;


layout(binding=0, r32i) uniform iimage2D texImageInt32;
// layout(binding=0, rgba32f) uniform image2D texImageInt32;

// uniform vec2 g_texSize = vec2(512.0, 512.0); // TBD set this!
// uniform vec2 g_texSize = vec2(1000.0, 1000.0); // TBD set this!
//uniform vec2 g_texSize = vec2(1000.0, 1000.0); // TBD set this!


vec3 spreadSpec3(vec3 c, float sp) {
    sp = fract(sp);
    c.r *= smoothstep(1.0, 0.0, (1.0-sp)*1.0);
    c.g *= smoothstep(1.0, 0.0, abs((sp-0.5)*2.0));
    c.b *= smoothstep(1.0, 0.0, sp*1.0);
    return c;
}

uniform float g_vignetteRealSpecSpacing = 2.0;

vec3 spreadSpecReal3(vec3 c, float sp) {
    vec3 res = c;
    sp = fract(sp);

    float widthM = g_vignetteRealSpecSpacing;
    float width = 1.0/(widthM/2.0);
    sp = -widthM/2.0+sp*(1.0+widthM/2.0);
                c.b *= 1.0;
                c.g *= 1.0;
                c.r *= 1.0;
    res.b = smoothstep(1.0, 0.0, abs((sp-0.0)*width))*c.b+smoothstep(1.0, 0.0, abs((sp-1.5)*width))*c.b;
    res.g = smoothstep(1.0, 0.0, abs((sp-0.5)*width))*c.g;
    res.r = smoothstep(1.0, 0.0, abs((sp-1.0)*width))*c.r+smoothstep(1.0, 0.0, abs((sp-(-0.5))*width))*c.r;

//    res.a = c.a;
    return res;
}

void main() {

    vec2 uvS = uv;
 //   uvS.y = 1.0-uvS.y;

    ivec2 size = imageSize(texImageInt32);

    ivec4 texInt = imageLoad(texImageInt32, ivec2(uvS*size));
    // vec4 texInt = imageLoad(texImageInt32, ivec2(uvS*size));
    //vec4 texInt = imageLoad(texImageInt32, ivec2(128, 100));
 //   vec4 screen = texture2D(tex, uvS+vec2(0.0, 0.0));
    // screen.a = 1.0;
 //   texInt = screen;
    frag = fract((vec4(texInt.r)/256.0)+vec4(0.0));
    // frag = fract(texInt*1.0);
    //if (texInt.r == 0) frag.r = 0.0; else frag.r = 1.0;
    //frag.rg = uv;

  //  frag.rgb = spreadSpecReal3(vec3(1.0), uvS.x*1.0);

    frag.a = 1.0;
}

