import QtQuick 2.3
import AdaptDemoSystem 1.0

// make world pos xyz locations of selected depthRT rendered with secondary camera
GroupBase {
  id: worldPos
  name: "worldPos"
  effectName: "WorldPos"
  property string targetTextureRT: "worldPosSecond"
  property string depthRT: "mainDepth"
  property string secondView: ""

  property int effectWidth: demo.windowWidth
  property int effectHeight: demo.windowHeight

  Texture { textureUnit: 0; textureRT: worldPos.depthRT }
  RenderTarget {
    RenderTargetLayer {
      textureRT: targetTextureRT; format: "RGBA32F";
      width: effectWidth; height: effectHeight
    }
    Shader { file: "worldPosSecond" }
    DrawVB {
      type: "quad"
      depthTest: false; depthWrite: false
      blendMode: "off"
      drawBuffers: 1
      secondView: worldPos.secondView

      ShaderParam { paramName: "windowWidth"; paramValue: effectWidth }
      ShaderParam { paramName: "windowHeight"; paramValue: effectHeight }

    }
  }
}
