import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "vignette"
  effectName: "Vignette"
  property bool enabledIn: true
  enabled: syncRootOn(effect.name, effectName) & enabledIn;

  property VignetteImpl impl
  Component {
    id: ec
    VignetteImpl {}
  }

  property bool effectExists: false
  onEnabledChanged: {
    if (!enabled && effectExists) {
      effectExists = false;
      impl.destroy(0);
      //log("vignette removed:"+effect.name)
      impl = undefined;
    }
  }
  Connections {
    target: demo
    onFrameRendered: {
      if (effect.enabled && !effectExists) {
        effectExists = true;
        var effectSettings = {
          name: effect.name
        };
        // log("created vignette:"+effect.name)
        impl = ec.createObject(effect, effectSettings);
      }
    }
  }
}
