import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "mesher"
  effectName: "Mesher"
  property bool enabledIn: true
  enabled: syncRootOn(effect.name, effectName) && enabledIn;

  property bool drawOnly: false

  property var syncIn: undefined
  property var syncFFTIn: undefined
  property var depthTestIn: undefined
  property var depthWriteIn: undefined
  property bool setShader: true
  property var fixedTimeStepIn: undefined


  property MesherImpl impl: undefined
  Component {
    id: ec
    MesherImpl {}
  }

  property bool effectExists: false
  onEnabledChanged: {
    if (!enabled && effectExists) {
      effectExists = false;
      impl.destroy(0);
      //log("mesher removed:"+effect.name)
      impl = undefined;
    }
  }

  Connections {
    target: demo
    onFrameRendered: {
      if (effect.enabled && !effectExists) {
        effectExists = true;
        var effectSettings = {
          name: effect.name,
          effectName: effect.effectName,
          setShader: effect.setShader,
          drawOnly: effect.drawOnly,
        };

        if (syncIn !== undefined) {
          effectSettings.syncIn = effect.syncIn;
        }
        if (syncFFTIn !== undefined) {
          effectSettings.syncFFTIn = effect.syncFFTIn;
        }
        if (depthTestIn !== undefined) {
          effectSettings.depthTestIn = effect.depthTestIn;
        }
        if (depthWriteIn !== undefined) {
          effectSettings.depthWriteIn = effect.depthWriteIn;
        }
        if (fixedTimeStepIn !== undefined) {
          effectSettings.fixedTimeStepIn = effect.fixedTimeStepIn
        }

        impl = ec.createObject(effect, effectSettings);
      }
    }
  }


}
