import QtQuick 2.4
import AdaptDemoSystem 1.0

Group {
    id: box
    name: "mesh"
    enabled: syncRoot(box.name+".ON")


    property bool bLeftPressed: false
    property bool bRightPressed: false
    property bool bUpPressed: false
    property bool bDownPressed: false

    property bool bGDown: false


    property string particlesName: "part"
    property bool clearParticleEmits: true


    Connections {
        target: root
        onKeyPressed: {
             console.log("MeshControl:"+keyCode);
            if (keyCode === Qt.Key_Left) {
                bLeftPressed = true;
            } else if (keyCode === Qt.Key_Right) {
                bRightPressed = true;
            } else if (keyCode === Qt.Key_Up) {
                bUpPressed = true;
            } else if (keyCode === Qt.Key_Down) {
                bDownPressed = true;
            } else if (keyCode === 71) { // G
                bGDown = true;
            }
        }
        onKeyReleased: {
            if (keyCode === Qt.Key_Left) {
                bLeftPressed = false;
            } else if (keyCode === Qt.Key_Right) {
                bRightPressed = false;
            } else if (keyCode === Qt.Key_Up) {
                bUpPressed = false;
            } else if (keyCode === Qt.Key_Down) {
                bDownPressed = false;
            } else if (keyCode === 71) { // G
                bGDown = false;
            }
        }

        onSetFlyCamMode: {
            box.flyCamMode = flyCamMode;
        }
    }

    // MeshControl stuff
    property real steeringAngle: 0.0
    property real steeringRot: 0.0

    property real entPosX: 0.0
    property real entPosY: 0.0
    property real entPosZ: 0.0

    property real dirX: 0.0
    property real dirY: 0.0
    property real dirZ: 1.0

    property real cenX: sync(box.name+".rotPosX")+0.0;
    property real cenY: sync(box.name+".rotPosY")+0.0;
    property real cenZ: sync(box.name+".rotPosZ")-0.6;

    property real mpi: 2.0*Math.PI/360.0

    property real entVel: 0.0

//    property

    //property real ts: rocket.timeStepReal/30.0
    property real ts: rocket.getFrameTimeSmooth()/60.0

    property int flyCamMode: 3

//    function handleMoveKeys() {
// TBD!
//    }


    Connections {
        id: meshControl
        target: demo;

        property real acc: 0.0


        onFrameRendered: {
            input();
            physics();
        }

        function input() {
            var bMoveEnabled = box.flyCamMode>=2;

            meshControl.acc = 0.0;
            if (bMoveEnabled) {
                if (bUpPressed) {
                    meshControl.acc -= 1.0;
                }
                if (bDownPressed) {
                    meshControl.acc += 1.0;
                }

                var maxSteer = sync(box.name+".maxSteer",0.50)

                if (bLeftPressed) {
                    steeringAngle += 0.11*ts;
                    if (steeringAngle > maxSteer*Math.PI) {
                        steeringAngle = maxSteer*Math.PI;
                    }
                }
                if (bRightPressed) {
                    steeringAngle -= 0.11*ts;
                    if (steeringAngle < -maxSteer*Math.PI) {
                        steeringAngle = -maxSteer*Math.PI;
                    }
                }
            }
        }

        function physics() {
            var tsPow = 60.0/rocket.getFrameTimeSmooth();

            entVel += meshControl.acc*ts*0.005*sync(box.name+".accVel",1.0);
            entVel *= Math.pow(sync(box.name+".accVelDamp",0.985), tsPow);

            if (entVel > 0.0) {
             //   steeringRot -= steeringAngle*ts*sync(box.name+".accSteer",1.0)*0.1*Math.min(1.0, Math.abs(entVel));
                steeringRot -= steeringAngle*ts*sync(box.name+".accSteer",1.0)*0.1*Math.min(0.30, Math.abs(entVel));
            } else {
              //  steeringRot += steeringAngle*ts*sync(box.name+".accSteer",1.0)*0.1*Math.min(1.0, Math.abs(entVel));
                steeringRot += steeringAngle*ts*sync(box.name+".accSteer",1.0)*0.1*Math.min(0.30, Math.abs(entVel));
            }


            steeringAngle *= Math.pow(sync(box.name+".accSteerDamp",0.9), tsPow);


        //    steeringRotReal += steeringRot*Math.min(1.0, Math.abs(entVel));


        //    var velFactor = Math.min(1.0, Math.abs(entVel));
            dirX = Math.sin(steeringRot*mpi);
            dirZ = Math.cos(steeringRot*mpi);

            entPosX += dirX*entVel;
            entPosY += dirY*entVel;
            entPosZ += dirZ*entVel;


            root.followEntity(entPosX, entPosY, entPosZ, sync(box.name+".camFollowIndex"));

            if (Math.abs(steeringAngle)>0.001) {
                rocket.markUpdateFrequent();
            }
            if (Math.abs(entVel)>0.001) {
                rocket.markUpdateFrequent();
            }

        }


    }

    onBLeftPressedChanged: {
        if (bLeftPressed) {
            // trigger something fancy?!
        }
    }

    onBGDownChanged: {
        if (bGDown) {
            // reset
            entPosX = 0.0;
            entPosY = 0.0;
            entPosZ = 0.0;
            entVel = 0.0;
            steeringAngle = 0.0;
            steeringRot = 0.0;
        }
    }


    VariClockTrigger {
        id: animFrame
        clockSpeed: sync(box.name+".anim.FPS", 0.0)
        reset: syncTrigger(box.name+".anim.reset")
    }
    property real animFramesPerRow: sync(box.name+".anim.numCols", 1.0)
    property real animRows: sync(box.name+".anim.numRows", 1.0)
    property int animFrames: Math.max(1.0, sync(box.name+".anim.frames", 1.0))
    property int animLoopFadeFrames: sync(box.name+".anim.loopFadeFrames", 1.0)
    property int animFrameInt: (animFrame.time.toFixed(0)/animFrames-Math.floor(animFrame.time.toFixed(0)/animFrames))*(animFrames-1)
//    property real animFrameUVX: (animFrameInt/animFramesPerRow-Math.floor(animFrameInt/animFramesPerRow))*animFramesPerRow*sync(box.name+".anim.width", 1.0/6.0)
//    property real animFrameUVY: Math.floor(animFrameInt/animFramesPerRow)*sync(box.name+".anim.height", 1.0/6.0)

    property real uvScale: sync(box.name+".uvScale", 1.0);

    ShaderAtomicCounter { name: particlesName+"sacVortex1"; clear: clearParticleEmits }
    Texture { textureUnit: 1; imageUnit: 1; textureRT: particlesName+"emitVortexPartPos" }
    Texture { textureUnit: 2; imageUnit: 2; textureRT: particlesName+"emitVortexPartVel" }
    Texture { textureUnit: 3; imageUnit: 3; textureRT: particlesName+"emitVortexPartCol" }


    Texture { textureUnit: 0; imageUnit: 0; textureRT: "velBuf" }

    TextureSel { name: box.name }
    TextureSel { name: box.name; textureUnit: 1 }
    TextureSel { name: box.name; textureUnit: 6 }

    Texture { textureUnit: 7;  textureRT: "mainDepth" }
    Shader { file: {
            var v = sync(box.name+".shaderIndex");

//            if (abs(meshMorph)>0.001) {
//                if (v===0) return "smLogo";
//                if (v===1) return "smMeshMotionMorph";
//            }

            if (meshi.isMorph) {
                return "smMeshMotion";
                if (v===0) return "smLogoMorph";
                if (v===1) return "smMeshMotionMorph";
                if (v===2) return "smMeshMotion";
                return "smLogoMorph";
            } else {
                return "smMeshMotion";
                if (v===0) return "smLogo";
                if (v===1) return "smMeshMotion";
                return "smLogo";
            }
//            if (v===0) return "smLogo";
//            if (v===1) return "smMeshMotion";
//            if (v===2) return "smMeshMotionMorph";
//            if (v===1) return "smMeshMotion";
//            if (v===2) return "smGen";
            return "smLogo";
        }
    }

    property bool origScale: sync(box.name+".origScale", 0.0) < 0.5

    property real meshMorph: sync(box.name+".meshMorph", 0.0)

    DrawMesh {
        id: meshi
        property string name: box.name
        file: meshSel(box.name)
        file2: meshSel2(box.name)
        depthTest: sync(box.name+".depthEnabled", 1.0) > 0.5
        depthWrite: depthTest
        blendMode: blendSel(box.name)

        autoCenter: origScale
        autoScale: origScale

        smoothNormals: true; normalSmoothAngle: 80;

        Pos { x: syncOscFFT(box.name+".posX")+entPosX; y: syncOscFFT(box.name+".posY")+entPosY; z: syncOscFFT(box.name+".posZ")}
        Pos { x: cenX; y: cenY; z: cenZ }
        Rot { d: sync(box.name+".rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync(box.name+".rotY")+steeringRot; ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sync(box.name+".rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }
        Pos { x: -cenX; y: -cenY; z: -cenZ }
        Sca { s: sync(box.name+".scale"); x: sync(box.name+".scaX"); y: sync(box.name+".scaY"); z: sync(box.name+".scaZ") }

        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(box.name+".bright", 1.0) }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync(box.name+".ambient", 0.1) }
      //  ShaderParam { paramName: "g_uvScale"; paramValue: sync(box.name+".uvScale", 1.0) }
        ShaderParam { paramName: "g_uvScale"; paramValueVec4: (uvScale*syncFFT(box.name+".uvScaleX", 1.0))+","+(uvScale*syncFFT(box.name+".uvScaleY", 1.0))}
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(box.name+".prevBlur", 0.5) }
        ShaderParam { paramName: "g_prevBlurType"; paramValue: sync(box.name+".prevBlurType") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(box.name+".bump", 0.25) }
        ShaderParam { paramName: "g_genUV"; paramValue: sync(box.name+".genUV", 1.0) }
        ShaderParam { paramName: "g_alpha"; paramValue: sync(box.name+".alpha", 1.0) }
        ShaderParam { paramName: "g_alphaSub"; paramValue: sync(box.name+".alphaSub", 0.0) }

        ShaderParam { paramName: "g_meshMorph"; paramValue: meshMorph }

        ShaderParam { paramName: "g_mulTexAmp"; paramValue: sync(box.name+".mulTexAmp") }

        ShaderParam { paramName: "g_emitThr"; paramValue: sync(box.name+".palaEmitThr", 0.0) }
        ShaderParam { paramName: "g_emitAmp"; paramValue: syncFFT(box.name+".palaEmitAmp", 1.0) }

        ShaderParam { paramName: "g_uvOfsX"; paramValue: syncFFT(box.name+".uvOfsX", 0.0) }
        ShaderParam { paramName: "g_uvOfsY"; paramValue: syncFFT(box.name+".uvOfsY", 0.0) }

        ShaderParam { paramName: "g_animInfo"; paramValueVec4: animFramesPerRow+","+animFrames+","+animRows+","+animFrameInt }
        ShaderParam { paramName: "g_animLoopFadeFrames"; paramValue: animLoopFadeFrames }

        ShaderParam { paramName: "g_emitPercent"; paramValue: sync(box.name+".emitPercent") }
        ShaderParam { paramName: "g_vortexAngSpeed"; paramValue: sync(box.name+".emitAngSpd") }
        ShaderParam { paramName: "g_emitVelX"; paramValue: sync(box.name+".emitVel.x") }
        ShaderParam { paramName: "g_emitVelY"; paramValue: sync(box.name+".emitVel.y") }
        ShaderParam { paramName: "g_emitVelZ"; paramValue: sync(box.name+".emitVel.z") }
        ShaderParam { paramName: "g_emitColorThr"; paramValue: sync(box.name+".emitColThr") }
        ShaderParam { paramName: "g_emitGrayness"; paramValue: sync(box.name+".emitGrayness") }

        //ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(box.name+".uvOfsY", 0.0) }

//        SavePoint {
//            target: meshInst.name+"_SP"
//            x: meshInst.posX+sync(meshInst.name+".spx")/meshInst.sca; y: meshInst.posY/meshInst.sca+sync(meshInst.name+".spy"); z: meshInst.posZ/(meshInst.sca*meshInst.scaZ)+sync(meshInst.name+".spz");
//        }

    }

}
