import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "lighter"
  effectName: "Lighter"
  property bool enabledIn: true
  enabled: syncRootOn(effect.name, effectName) & enabledIn;


  property LighterImpl impl
  Component {
    id: ec
    LighterImpl {}
  }

  property bool effectExists: false
  onEnabledChanged: {
    if (!enabled && effectExists) {
      effectExists = false;
      impl.destroy(0);
      //log("lighter removed:"+effect.name)
      impl = undefined;
    }
  }

  Connections {
    target: demo
    onFrameRendered: {
      if (effect.enabled && !effectExists) {
        effectExists = true;
        impl = ec.createObject(effect, {
                                 name: effect.name
                               });
      }
    }
  }
}
