import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: godray
    name: "godray"
    effectName: "GodRay"
    enabled: syncRoot(godray.name+".ON")


    property real godRayX: 0.0
    property real godRayY: 0.0

    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }
    Blit {
        textureRT: "godRays"
        blitRT: 1
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    Texture {
        textureUnit: 1
        textureRT: "godRays"
    }

    // palette texture for chroma break
    TextureSel { textureUnit: 2; nameOverride: godray.name+".chromaPalette.texInd"; }
    property real chromaPaletteEnabled: sync(godray.name+".chromaPalette.texInd", 0.0) > 0.5 ? 1.0 : 0.0 // 0 not enabled & >0 ... enabled

    Shader {
        file: "godray"
        ShaderParam {
            paramName: "rayX"; paramValue: sync(godray.name+".x", 0.0)+godRayX
        }
        ShaderParam {
            paramName: "rayY"; paramValue: sync(godray.name+".y", 0.0)+godRayY
        }
        ShaderParam {
            paramName: "g_rotCenterX"; paramValue: sync(godray.name+".x", 0.5)+godRayX
        }
        ShaderParam {
            paramName: "g_rotCenterY"; paramValue: sync(godray.name+".y", 0.5)+godRayY
        }

        ShaderParam {
            paramName: "lightZ"
            paramValue: sync(godray.name+".lightZ", 1.0)+1.0
        }
        ShaderParam {
            paramName: "g_intensity"
            paramValue: sync(godray.name+".intensity", 1.0)
        }
        ShaderParam {
            paramName: "g_origAmount"
            paramValue: sync(godray.name+".origAmount", 1.0)
        }
        ShaderParam {
            paramName: "g_specRounds"
            paramValue: sync(godray.name+".specRounds", 1.0)
        }
        ShaderParam {
            paramName: "g_specOfs"
            paramValue: sync(godray.name+".specOfs", 0.0)
        }
        ShaderParam {
            paramName: "g_specWeight"
            paramValue: sync(godray.name+".specWeight", 1.0)
        }
        ShaderParam {
            paramName: "g_length"
            paramValue: sync(godray.name+".length", 1.0)
        }
        ShaderParam {
            paramName: "g_loops"
            paramValue: sync(godray.name+".loops", 64.0)
        }
        ShaderParam {
            paramName: "g_rotateAmp"
            paramValue: sync(godray.name+".rotateAmp", 0.0)
        }
        ShaderParam {
            paramName: "g_rotatePrim"
            paramValue: sync(godray.name+".rotatePrim", 0.0)
        }
        ShaderParam {
            paramName: "g_rotateSinAmp"
            paramValue: sync(godray.name+".rotateSinAmp", 0.0)
        }
        ShaderParam {
            paramName: "g_rotateSinFreq"
            paramValue: sync(godray.name+".rotateSinFreq", 0.0)
        }
        ShaderParam { paramName: "g_rotateMove"; paramValue: sync(godray.name+".rotateMove", 0.0) }
        ShaderParam { paramName: "g_rotateBrightMove"; paramValue: sync(godray.name+".rotateBrightMove", 0.0) }
        ShaderParam { paramName: "g_rotateBrightFreq"; paramValue: sync(godray.name+".rotateBrightFreq", 0.0) }
        ShaderParam { paramName: "g_rotateDist"; paramValue: sync(godray.name+".rotateDist", 0.0)+0.5 }
        ShaderParam { paramName: "g_timeRot"; paramValue: sync(godray.name+".timeRot", 0.0)+0.0 }
        ShaderParam { paramName: "g_timeBrightRot"; paramValue: sync(godray.name+".timeBrightRot", 0.0)+0.0 }

        ShaderParam { paramName: "g_screenSize"; paramValue: sync(godray.name+".screenSize", 1.0) }

        ShaderParam { paramName: "g_baseFromCol"; paramValue: sync(godray.name+".baseFromCol", 1.0) }

        ShaderParam { paramName: "g_chromaPaletteEnabled"; paramValue: chromaPaletteEnabled }
        ShaderParam { paramName: "g_chromaPaletteY"; paramValue: sync(godray.name+".chromaPalette.y", 0.0) }

    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
    }
    Blit {
        textureRT: "godRaysResult"
        blitRT: 0
    }


    // mix original and result

    Shader {
        file: "fx/_SharedQML/glow"
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    Texture {
        textureUnit: 1
        textureRT: "godRaysResult"
    }
    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: 0.0
        }
        ShaderParam {
            paramName: "overlayAlpha"
            paramValue: 1.0
        }

        ShaderParam {
            paramName: "g_origAmount"
            paramValue: sync(godray.name+".origAmount")
        }
        ShaderParam { paramName: "g_overlayScale"; paramValue: sync(godray.name+".screenSize", 1.0) }
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }

}

