import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: drawTrans
    name: "trans"
    effectName: "DrawTrans"

    property string transShader: "zoomTrans"
    property string drawShader: "zoomDraw"

    property alias drawParams: drawItRep.delegate
    property alias drawTexture: drawTexRep.delegate


    property real zoomPercent: 0.01
    property real emitIntervalMS: 40

    property real drawTexUvScale: 0.02

    property string file

    // shaderVaryings define the transform feedback emit and input vertex data structure
    property string shaderVaryings: "
        vec3 posG;
        vec3 normalG;
        vec2 uvG;
        vec3 tangentG;
        float brightG;
        vec3 origCenterG;"

    property int gWidth: 2000
    Shader {
        file: sceneDir+transShader; tfVaryings: shaderVaryings;
        ShaderParam { paramName: "g_emit"; paramValue: 0.0}
        ShaderParam { paramName: "g_zoomAmount"; paramValue: 1.0+zoomPercent}
    }
    // start drawing (with transform feedback) triangles to sceneName+"trans" named vertex buffer object (vbo)
    // all Draw* after this and before "drawStop" has the render to the screen disabled (goes only to the vertex buffer)
    DrawVB {
        type: "drawStart"; primType: "triangles"; vboId: sceneName+drawTrans.name; tfVaryings: shaderVaryings;
        reset: sync(drawTrans.name+".reset")
        onResetChanged: {if (reset > 0.5) resetParticles();}
        gridWidth: gWidth; gridHeight: 1000
        drawNumPoints: gridWidth*gridHeight
        depthTest: false; depthWrite: false
    }

    property real prevTi: 0.0
    property real ki: 0.0
    property real kii: 0.0
    property real pr: sync(drawTrans.name+".emitTrack.innerRad")
    property real er: sync(drawTrans.name+".emitTrack.rad")
    property int drawIndex: 0
    Connections {
        target: demo; onFrameRendered: {
            var ti = demoTime();
            var deltaTime = (ti-prevTi);
            if (deltaTime > emitIntervalMS*0.001 || deltaTime < -emitIntervalMS*0.001) {
                ki += deltaTime*sync(drawTrans.name+".emitTrack.freq");
                kii += deltaTime*sync(drawTrans.name+".emitTrack.freq")*sync(drawTrans.name+".emitTrack.innerFreq");
                prevTi = ti;
                if (dm.itemAt(0)) {
                    dm.itemAt(0).triggerRenderOnce();
                }
                // smallMeshi.triggerRenderOnce();
                drawIndex++;
            }
        }
    }

    // draw the given meshes (as given by the DrawTrans parameters!)
    property alias drawMesh: dm.delegate
    Repeater {
        id: dm
        model: 1
    }

    Greets { } // draws internally texts when trigger changes, adds relevant rocket tracks etc



    // stop drawing to the vertex buffer (with transform feedback)
    DrawVB {
        type: "drawStop";  primType: "triangles"; vboId: sceneName+drawTrans.name; tfVaryings: shaderVaryings
        gridWidth: gWidth; gridHeight: 1000; drawNumPoints: gridWidth*gridHeight
    }

    Shader {
        file: sceneDir+drawShader
        ShaderParam { paramName: "g_bump"; paramValue: 0.0}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.30 }
        ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: drawTexUvScale }
        ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0" }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.1*sync("prevBlurAmount") }
        ShaderParam { paramName: "g_bright"; paramValue: 1.0}
    }

    Repeater { id: drawTexRep; model: 1 }


    DrawVB {
        enabled: true
        type: "pointGridDraw"
        primType: "triangles"
        vboId: sceneName+drawTrans.name
        tfVaryings: drawTrans.shaderVaryings
        gridWidth: gWidth; gridHeight: 1000
        drawNumPoints: gridWidth*gridHeight
        depthTest: true; depthWrite: true

        Repeater { id: drawItRep; model: 1 }

        blendMode: "normal"
        onParticleCountChanged: {
            root.setCustomText("ginkku", "triangle count", "triangle count:"+particleCount);
        }
    }
}
