import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: effect
    name: "claude"
    enabled: syncRoot(effect.name+".ON");

    Blit { textureRT: "current" }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "blurClaude"
            format: "RGBA32F"
            width: demo.windowWidth
            height: demo.windowHeight
        }
        TextureImage { textureUnit: 0; file: texGrad.file }
        Shader { file: "fx/_SharedQML/drawRt" }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            ShaderParam { paramName: "flip"; paramValue: 1.0 }
            blendMode: "off"
        }
    }

    BlurRt { name: "claude.gradBlur"; textureRT: "blurClaude" }

    Shader { file: "claude" }
    Texture { textureUnit: 0; textureRT: "current" }
    TextureSel { id: texGrad; textureUnit: 1; nameOverride: effect.name+".gradient.texInd"  }
    TextureImage { textureUnit: 2;  file: "../../images/system/random16.png" }
    Texture { textureUnit: 3; textureRT: "blurClaude" }

    DrawVB {
        type: "quad"
        depthTest: false; depthWrite: false
        blendMode: "off"
        drawBuffers: 1
        ShaderParam { paramName: "noiseOct"; paramValue: sync(effect.name+".noise.octaves") }
        ShaderParam { paramName: "noiseFreq"; paramValue: sync(effect.name+".noise.freq") }
        ShaderParam { paramName: "noisePos"; paramValue: sync(effect.name+".noise.pos") }
        ShaderParam { paramName: "noisePosX"; paramValue: sync(effect.name+".noise.posX") }
        ShaderParam { paramName: "noisePosY"; paramValue: sync(effect.name+".noise.posY") }
        ShaderParam { paramName: "noiseAmp"; paramValue: sync(effect.name+".noise.amp") }
        ShaderParam { paramName: "noiseExp"; paramValue: sync(effect.name+".noise.exp") }
        ShaderParam { paramName: "noiseLevelMul"; paramValue: sync(effect.name+".noise.levelMul") }
        ShaderParam { paramName: "noiseLevelOct"; paramValue: sync(effect.name+".noise.levelOct") }
     //   ShaderParam { paramName: "turbOp"; paramValue: sync(effect.name+".noise.turbOp") }

        ShaderParam { paramName: "toAlphaLimit"; paramValue: sync(effect.name+".toAlphaLimit") }
        ShaderParam { paramName: "toAlphaAmp"; paramValue: sync(effect.name+".toAlphaAmp") }
        ShaderParam { paramName: "toAlphaExp"; paramValue: sync(effect.name+".toAlphaExp") }

        ShaderParam { paramName: "texScaleX"; paramValue: sync(effect.name+".texScaleX") }
        ShaderParam { paramName: "texScaleY"; paramValue: sync(effect.name+".texScaleY") }
        ShaderParam { paramName: "texOfsX"; paramValue: sync(effect.name+".texOfsX") }
        ShaderParam { paramName: "texOfsY"; paramValue: sync(effect.name+".texOfsY") }

        ShaderParam { paramName: "bright"; paramValue: sync(effect.name+".bright") }
        ShaderParam { paramName: "gradRot"; paramValue: sync(effect.name+".gradRot") }
        ShaderParam { paramName: "gradExp"; paramValue: sync(effect.name+".gradExp") }
        ShaderParam { paramName: "gradBlurDir"; paramValue: sync(effect.name+".gradBlurDir") }

    }

}
