/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0006\u0010\u001a\u001a\u00020\u0000J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006!"}, d2={"Lorg/openrndr/math/Spherical;", "", "radius", "", "theta", "phi", "(DDD)V", "cartesian", "Lorg/openrndr/math/Vector3;", "getCartesian", "()Lorg/openrndr/math/Vector3;", "getPhi", "()D", "getRadius", "getTheta", "component1", "component2", "component3", "copy", "div", "s", "equals", "", "other", "hashCode", "", "makeSafe", "minus", "plus", "times", "toString", "", "Companion", "openrndr-math"})
public final class Spherical {
    private final double radius;
    private final double theta;
    private final double phi;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Spherical makeSafe() {
        return new Spherical(this.radius, this.theta, FunctionsKt.clamp(this.phi, 1.0E-6, 3.141591653589793));
    }

    @NotNull
    public final Vector3 getCartesian() {
        return Vector3.Companion.fromSpherical(this);
    }

    @NotNull
    public final Spherical plus(@NotNull Spherical s2) {
        Intrinsics.checkParameterIsNotNull(s2, "s");
        return new Spherical(this.radius + s2.radius, this.theta + s2.theta, this.phi + s2.phi);
    }

    @NotNull
    public final Spherical minus(@NotNull Spherical s2) {
        Intrinsics.checkParameterIsNotNull(s2, "s");
        return new Spherical(this.radius - s2.radius, this.theta - s2.theta, this.phi - s2.phi);
    }

    @NotNull
    public final Spherical times(@NotNull Spherical s2) {
        Intrinsics.checkParameterIsNotNull(s2, "s");
        return new Spherical(this.radius * s2.radius, this.theta * s2.theta, this.phi * s2.phi);
    }

    @NotNull
    public final Spherical times(double s2) {
        return new Spherical(this.radius * s2, this.theta * s2, this.phi * s2);
    }

    @NotNull
    public final Spherical div(double s2) {
        return new Spherical(this.radius / s2, this.theta / s2, this.phi / s2);
    }

    public final double getRadius() {
        return this.radius;
    }

    public final double getTheta() {
        return this.theta;
    }

    public final double getPhi() {
        return this.phi;
    }

    public Spherical(double radius, double theta, double phi) {
        this.radius = radius;
        this.theta = theta;
        this.phi = phi;
    }

    public final double component1() {
        return this.radius;
    }

    public final double component2() {
        return this.theta;
    }

    public final double component3() {
        return this.phi;
    }

    @NotNull
    public final Spherical copy(double radius, double theta, double phi) {
        return new Spherical(radius, theta, phi);
    }

    @NotNull
    public static /* synthetic */ Spherical copy$default(Spherical spherical, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = spherical.radius;
        }
        if ((n & 2) != 0) {
            d2 = spherical.theta;
        }
        if ((n & 4) != 0) {
            d3 = spherical.phi;
        }
        return spherical.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "Spherical(radius=" + this.radius + ", theta=" + this.theta + ", phi=" + this.phi + ")";
    }

    public int hashCode() {
        return (Double.hashCode(this.radius) * 31 + Double.hashCode(this.theta)) * 31 + Double.hashCode(this.phi);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Spherical)) break block3;
                Spherical spherical = (Spherical)object;
                if (Double.compare(this.radius, spherical.radius) != 0 || Double.compare(this.theta, spherical.theta) != 0 || Double.compare(this.phi, spherical.phi) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/math/Spherical$Companion;", "", "()V", "fromVector", "Lorg/openrndr/math/Spherical;", "vector", "Lorg/openrndr/math/Vector3;", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final Spherical fromVector(@NotNull Vector3 vector) {
            Intrinsics.checkParameterIsNotNull(vector, "vector");
            double r = vector.getLength();
            return new Spherical(r, r == 0.0 ? 0.0 : Math.atan2(vector.getX(), vector.getZ()), r == 0.0 ? 0.0 : Math.acos(FunctionsKt.clamp(vector.getY() / r, -1.0, 1.0)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

