/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.IntVector2;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 52\u00020\u0001:\u00015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J1\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001J\u0011\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0086\u0002J\u0011\u00101\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0086\u0002J\u0011\u00102\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0003H\u0086\u0002J\t\u00103\u001a\u000204H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000eR\u0011\u0010\u001c\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0018R\u0011\u0010\u001e\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000e\u00a8\u00066"}, d2={"Lorg/openrndr/math/IntVector4;", "Ljava/io/Serializable;", "x", "", "y", "z", "w", "(IIII)V", "length", "", "getLength", "()D", "squaredLength", "getSquaredLength", "()I", "vector4", "Lorg/openrndr/math/Vector4;", "getVector4", "()Lorg/openrndr/math/Vector4;", "getW", "getX", "xx", "Lorg/openrndr/math/IntVector2;", "getXx", "()Lorg/openrndr/math/IntVector2;", "xy", "getXy", "getY", "yx", "getYx", "yy", "getYy", "getZ", "component1", "component2", "component3", "component4", "copy", "div", "d", "dot", "right", "equals", "", "other", "", "hashCode", "minus", "v", "plus", "times", "toString", "", "Companion", "openrndr-math"})
public final class IntVector4
implements Serializable {
    private final int x;
    private final int y;
    private final int z;
    private final int w;
    @NotNull
    private static final IntVector4 ZERO;
    @NotNull
    private static final IntVector4 UNIT_X;
    @NotNull
    private static final IntVector4 UNIT_Y;
    @NotNull
    private static final IntVector4 UNIT_Z;
    @NotNull
    private static final IntVector4 UNIT_W;
    public static final Companion Companion;

    public final double getLength() {
        return Math.sqrt(1.0 * (double)this.x * (double)this.x + (double)(this.y * this.y) + (double)(this.z * this.z) + (double)(this.w * this.w));
    }

    public final int getSquaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final int dot(@NotNull IntVector4 right) {
        Intrinsics.checkParameterIsNotNull(right, "right");
        return this.x * right.x + this.y * right.y + this.z * right.z + this.w * right.w;
    }

    @NotNull
    public final IntVector2 getXy() {
        return new IntVector2(this.x, this.y);
    }

    @NotNull
    public final IntVector2 getYx() {
        return new IntVector2(this.y, this.x);
    }

    @NotNull
    public final IntVector2 getXx() {
        return new IntVector2(this.x, this.x);
    }

    @NotNull
    public final IntVector2 getYy() {
        return new IntVector2(this.y, this.y);
    }

    @NotNull
    public final IntVector4 plus(@NotNull IntVector4 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new IntVector4(this.x + v.x, this.y + v.y, this.z + v.z, this.w + v.w);
    }

    @NotNull
    public final IntVector4 minus(@NotNull IntVector4 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new IntVector4(this.x - v.x, this.y - v.y, this.z - v.z, this.w - v.w);
    }

    @NotNull
    public final IntVector4 times(int d) {
        return new IntVector4(this.x * d, this.y * d, this.z * d, this.w * d);
    }

    @NotNull
    public final IntVector4 div(int d) {
        return new IntVector4(this.x / d, this.y / d, this.z / d, this.w / d);
    }

    @NotNull
    public final Vector4 getVector4() {
        return new Vector4(this.x, this.y, this.z, this.w);
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public final int getW() {
        return this.w;
    }

    public IntVector4(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    static {
        Companion = new Companion(null);
        ZERO = new IntVector4(0, 0, 0, 0);
        UNIT_X = new IntVector4(1, 0, 0, 0);
        UNIT_Y = new IntVector4(0, 1, 0, 0);
        UNIT_Z = new IntVector4(0, 0, 1, 0);
        UNIT_W = new IntVector4(0, 0, 0, 1);
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final int component3() {
        return this.z;
    }

    public final int component4() {
        return this.w;
    }

    @NotNull
    public final IntVector4 copy(int x, int y, int z, int w) {
        return new IntVector4(x, y, z, w);
    }

    @NotNull
    public static /* synthetic */ IntVector4 copy$default(IntVector4 intVector4, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = intVector4.x;
        }
        if ((n5 & 2) != 0) {
            n2 = intVector4.y;
        }
        if ((n5 & 4) != 0) {
            n3 = intVector4.z;
        }
        if ((n5 & 8) != 0) {
            n4 = intVector4.w;
        }
        return intVector4.copy(n, n2, n3, n4);
    }

    @NotNull
    public String toString() {
        return "IntVector4(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ")";
    }

    public int hashCode() {
        return ((Integer.hashCode(this.x) * 31 + Integer.hashCode(this.y)) * 31 + Integer.hashCode(this.z)) * 31 + Integer.hashCode(this.w);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof IntVector4)) break block3;
                IntVector4 intVector4 = (IntVector4)object;
                if (!(this.x == intVector4.x) || !(this.y == intVector4.y) || !(this.z == intVector4.z) || !(this.w == intVector4.w)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/openrndr/math/IntVector4$Companion;", "", "()V", "UNIT_W", "Lorg/openrndr/math/IntVector4;", "getUNIT_W", "()Lorg/openrndr/math/IntVector4;", "UNIT_X", "getUNIT_X", "UNIT_Y", "getUNIT_Y", "UNIT_Z", "getUNIT_Z", "ZERO", "getZERO", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final IntVector4 getZERO() {
            return ZERO;
        }

        @NotNull
        public final IntVector4 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final IntVector4 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final IntVector4 getUNIT_Z() {
            return UNIT_Z;
        }

        @NotNull
        public final IntVector4 getUNIT_W() {
            return UNIT_W;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

