/*
 * Decompiled with CFR 0.152.
 */
package jouvieje.bass.utils;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import jouvieje.bass.utils.BufferUtils;
import jouvieje.bass.utils.SizeOfPrimitive;

public class FileIOUtils
implements SizeOfPrimitive {
    private ByteBuffer shortBuffer = null;
    private ByteBuffer charBuffer = null;
    private ByteBuffer intBuffer = null;
    private ByteBuffer longBuffer = null;
    private ByteBuffer floatBuffer = null;
    private ByteBuffer doubleBuffer = null;

    public void freeMemory() {
        this.shortBuffer = null;
        this.charBuffer = null;
        this.intBuffer = null;
        this.longBuffer = null;
        this.floatBuffer = null;
        this.doubleBuffer = null;
    }

    public byte readByte(RandomAccessFile file) throws IOException {
        return file.readByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort(RandomAccessFile file) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getShortBuffer();
        synchronized (byteBuffer) {
            file.getChannel().read(buffer);
            buffer.rewind();
            return buffer.getShort(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char readChar(RandomAccessFile file) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getCharBuffer();
        synchronized (byteBuffer) {
            file.getChannel().read(buffer);
            buffer.rewind();
            return buffer.getChar(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt(RandomAccessFile file) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getIntBuffer();
        synchronized (byteBuffer) {
            file.getChannel().read(buffer);
            buffer.rewind();
            return buffer.getInt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float readFloat(RandomAccessFile file) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getFloatBuffer();
        synchronized (byteBuffer) {
            file.getChannel().read(buffer);
            buffer.rewind();
            return buffer.getFloat(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong(RandomAccessFile file) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getLongBuffer();
        synchronized (byteBuffer) {
            file.getChannel().read(buffer);
            buffer.rewind();
            return buffer.getLong(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readDouble(RandomAccessFile file) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getDoubleBuffer();
        synchronized (byteBuffer) {
            file.getChannel().read(buffer);
            buffer.rewind();
            return buffer.getDouble(0);
        }
    }

    public byte[] readByteArray(RandomAccessFile file, int nbBytes) throws IOException {
        byte[] datas = new byte[nbBytes];
        file.read(datas, 0, datas.length);
        return datas;
    }

    public void readByteArray(RandomAccessFile file, byte[] datas, int offset2, int nbBytes) throws IOException {
        file.read(datas, offset2, nbBytes);
    }

    public ByteBuffer readByteBuffer(RandomAccessFile file, int nbBytes) throws IOException {
        ByteBuffer datas = BufferUtils.newByteBuffer(nbBytes);
        file.getChannel().read(datas);
        return datas;
    }

    public void readByteBuffer(RandomAccessFile file, ByteBuffer buffer, int nbBytes) throws IOException {
        ByteBuffer view2 = buffer.duplicate();
        view2.limit(view2.position() + nbBytes);
        file.getChannel().read(view2);
        buffer.position(view2.position());
    }

    public void writeByte(RandomAccessFile file, byte value2) throws IOException {
        file.writeByte(value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeShort(RandomAccessFile file, short value2) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getShortBuffer();
        synchronized (byteBuffer) {
            buffer.putShort(0, value2);
            file.getChannel().write(buffer);
            buffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChar(RandomAccessFile file, char value2) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getCharBuffer();
        synchronized (byteBuffer) {
            buffer.putChar(0, value2);
            file.getChannel().write(buffer);
            buffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInt(RandomAccessFile file, int value2) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getIntBuffer();
        synchronized (byteBuffer) {
            buffer.putInt(0, value2);
            file.getChannel().write(buffer);
            buffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFloat(RandomAccessFile file, float value2) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getFloatBuffer();
        synchronized (byteBuffer) {
            buffer.putFloat(0, value2);
            file.getChannel().write(buffer);
            buffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLong(RandomAccessFile file, long value2) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getLongBuffer();
        synchronized (byteBuffer) {
            buffer.putLong(0, value2);
            file.getChannel().write(buffer);
            buffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDouble(RandomAccessFile file, double value2) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this.getDoubleBuffer();
        synchronized (byteBuffer) {
            buffer.putDouble(0, value2);
            file.getChannel().write(buffer);
            buffer.rewind();
        }
    }

    public void writeByteArray(RandomAccessFile file, byte[] datas) throws IOException {
        this.writeByteArray(file, datas, 0, datas.length);
    }

    public void writeByteArray(RandomAccessFile file, byte[] datas, int offset2, int length) throws IOException {
        file.write(datas, offset2, length);
    }

    public int writeByteBuffer(RandomAccessFile file, ByteBuffer buffer) throws IOException {
        return file.getChannel().write(buffer);
    }

    public int writeByteBuffer(RandomAccessFile file, ByteBuffer buffer, int length) throws IOException {
        ByteBuffer view2 = buffer.duplicate();
        view2.limit(view2.position() + length);
        int written = file.getChannel().write(view2);
        buffer.position(view2.position());
        return written;
    }

    private ByteBuffer getShortBuffer() {
        if (this.shortBuffer == null) {
            this.shortBuffer = BufferUtils.newByteBuffer(2);
        }
        return this.shortBuffer;
    }

    private ByteBuffer getCharBuffer() {
        if (this.charBuffer == null) {
            this.charBuffer = BufferUtils.newByteBuffer(2);
        }
        return this.charBuffer;
    }

    private ByteBuffer getIntBuffer() {
        if (this.intBuffer == null) {
            this.intBuffer = BufferUtils.newByteBuffer(4);
        }
        return this.intBuffer;
    }

    private ByteBuffer getLongBuffer() {
        if (this.longBuffer == null) {
            this.longBuffer = BufferUtils.newByteBuffer(8);
        }
        return this.longBuffer;
    }

    private ByteBuffer getFloatBuffer() {
        if (this.floatBuffer == null) {
            this.floatBuffer = BufferUtils.newByteBuffer(4);
        }
        return this.floatBuffer;
    }

    private ByteBuffer getDoubleBuffer() {
        if (this.doubleBuffer == null) {
            this.doubleBuffer = BufferUtils.newByteBuffer(8);
        }
        return this.doubleBuffer;
    }
}

