/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.utils;

public class Bits {
    private static final byte[] deBruijnIndex = new byte[]{0, 1, 2, 53, 3, 7, 54, 27, 4, 38, 41, 8, 34, 55, 48, 28, 62, 5, 39, 46, 44, 42, 22, 9, 24, 35, 59, 56, 49, 18, 29, 11, 63, 52, 6, 26, 37, 40, 33, 47, 61, 45, 43, 21, 23, 58, 17, 10, 51, 25, 36, 32, 60, 20, 57, 16, 50, 31, 19, 15, 30, 14, 13, 12};

    public static int bitOffset(long n) {
        return deBruijnIndex[0xFF & (int)(n * 157587932685088877L >>> 58)];
    }

    public static long lowestBit(long n) {
        return n & -n;
    }

    public static int lowestBit(int n) {
        return n & -n;
    }

    public static long highestBit(long n) {
        return Long.highestOneBit(n);
    }

    public static int highestBit(int n) {
        return Integer.highestOneBit(n);
    }

    public static int log2Floor(long n) {
        return Bits.bitOffset(Bits.highestBit(n));
    }

    public static int log2Ceil(long n) {
        int log2 = Bits.log2Floor(n);
        return Bits.isPowerOfTwo(n) ? log2 : log2 + 1;
    }

    public static long maskBelow(int bits) {
        return (1L << bits) - 1L;
    }

    public static long maskAbove(int bits) {
        return 0xFFFFFFFFFFFFFFFFL & (Bits.maskBelow(bits) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int branchingBit(long a2, long b) {
        if (a2 == b) {
            return -1;
        }
        return Bits.bitOffset(Bits.highestBit(a2 ^ b));
    }

    public static boolean isPowerOfTwo(long n) {
        return (n & n - 1L) == 0L;
    }
}

