/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan.nodes;

import io.lacuna.bifurcan.utils.UnicodeChunk;

public class RopeNodes {
    public static final int SHIFT_INCREMENT = 5;
    public static final int MAX_BRANCHES = 32;
    public static final int MAX_CHUNK_CODE_UNITS = 32;

    public static Object slice(Object chunk, int start, int end2, Object editor) {
        if (chunk instanceof byte[]) {
            return UnicodeChunk.slice((byte[])chunk, start, end2);
        }
        return ((Node)chunk).slice(start, end2, editor);
    }

    public static int numCodeUnits(Object node) {
        if (node instanceof byte[]) {
            return UnicodeChunk.numCodeUnits((byte[])node);
        }
        return ((Node)node).numCodeUnits();
    }

    public static int numCodePoints(Object node) {
        if (node instanceof byte[]) {
            return UnicodeChunk.numCodePoints((byte[])node);
        }
        return ((Node)node).numCodePoints();
    }

    public static Node pushLast(Node a2, Object b, Object editor) {
        if (b instanceof byte[]) {
            return a2.pushLast((byte[])b, editor);
        }
        return a2.concat((Node)b, editor);
    }

    public static class Node {
        public byte shift;
        public int[] unitOffsets;
        public int[] pointOffsets;
        public Object[] nodes;
        public int numNodes;
        public final Object editor;

        public Node(Object editor, int shift2) {
            this.shift = (byte)shift2;
            this.unitOffsets = new int[2];
            this.pointOffsets = new int[2];
            this.nodes = new Object[2];
            this.numNodes = 0;
            this.editor = editor;
        }

        private Node(Object editor) {
            this.editor = editor;
        }

        private static Node from(Object editor, int shift2, Node child) {
            return new Node(editor, shift2).pushLast(child, editor);
        }

        private static Node from(Object editor, int shift2, Node a2, Node b) {
            return new Node(editor, shift2).pushLast(a2, editor).pushLast(b, editor);
        }

        private static Node from(Object editor, byte[] child) {
            return new Node(editor, 5).pushLast(child, editor);
        }

        private int indexFor(int idx, int[] offsets) {
            int estimate;
            for (int i = estimate = this.shift > 30 ? 0 : idx >> this.shift & 0x1F; i < this.numNodes; ++i) {
                if (idx >= offsets[i]) continue;
                return i;
            }
            throw new IndexOutOfBoundsException(idx + " is not within [0," + Node.offsetFor(this.numNodes, offsets) + ")");
        }

        private static int offsetFor(int nodeIdx, int[] offsets) {
            return nodeIdx == 0 ? 0 : offsets[nodeIdx - 1];
        }

        public byte[] chunkFor(int idx) {
            Object o;
            Node n = this;
            while (true) {
                int nodeIdx;
                if ((nodeIdx = n.indexFor(idx, n.pointOffsets)) < 0) {
                    return null;
                }
                idx -= Node.offsetFor(nodeIdx, n.pointOffsets);
                o = n.nodes[nodeIdx];
                if (!(o instanceof Node)) break;
                n = (Node)o;
            }
            return (byte[])o;
        }

        public int nthPoint(int idx) {
            Object o;
            Node n = this;
            while (true) {
                int nodeIdx = n.indexFor(idx, n.pointOffsets);
                idx -= Node.offsetFor(nodeIdx, n.pointOffsets);
                o = n.nodes[nodeIdx];
                if (!(o instanceof Node)) break;
                n = (Node)o;
            }
            return UnicodeChunk.nthPoint((byte[])o, idx);
        }

        public char nthUnit(int idx) {
            Object o;
            Node n = this;
            while (true) {
                int nodeIdx = n.indexFor(idx, n.unitOffsets);
                idx -= Node.offsetFor(nodeIdx, n.unitOffsets);
                o = n.nodes[nodeIdx];
                if (!(o instanceof Node)) break;
                n = (Node)o;
            }
            return UnicodeChunk.nthUnit((byte[])o, idx);
        }

        public int numCodeUnits() {
            return this.numNodes == 0 ? 0 : this.unitOffsets[this.numNodes - 1];
        }

        public int numCodePoints() {
            return this.numNodes == 0 ? 0 : this.pointOffsets[this.numNodes - 1];
        }

        public Node update(int offset2, int idx, Object editor, ChunkUpdater updater) {
            byte[] newChild;
            if (this.numNodes == 0) {
                return null;
            }
            int nodeIdx = this.numNodes - 1;
            int nodeOffset = Node.offsetFor(nodeIdx, this.pointOffsets);
            if (idx != this.numCodePoints()) {
                nodeIdx = this.indexFor(idx, this.pointOffsets);
                nodeOffset = Node.offsetFor(nodeIdx, this.pointOffsets);
            }
            Object child = this.nodes[nodeIdx];
            int numUnits = RopeNodes.numCodeUnits(child);
            int numPoints = RopeNodes.numCodePoints(child);
            Object object = newChild = this.shift == 5 ? updater.update(offset2 + nodeOffset, (byte[])child) : (Object)((Node)child).update(offset2 + nodeOffset, idx - nodeOffset, editor, updater);
            if (newChild == null) {
                return null;
            }
            int deltaUnits = RopeNodes.numCodeUnits(newChild) - numUnits;
            int deltaPoints = RopeNodes.numCodePoints(newChild) - numPoints;
            Node node = editor == this.editor ? this : this.clone(editor);
            node.nodes[nodeIdx] = newChild;
            int i = nodeIdx;
            while (i < this.numNodes) {
                int n = i;
                node.unitOffsets[n] = node.unitOffsets[n] + deltaUnits;
                int n2 = i++;
                node.pointOffsets[n2] = node.pointOffsets[n2] + deltaPoints;
            }
            return node;
        }

        public Node concat(Node node, Object editor) {
            if (node.numCodeUnits() == 0) {
                return this;
            }
            if (this.numCodeUnits() == 0) {
                return node;
            }
            if (this.shift == node.shift) {
                Node newNode = this.editor == editor ? this : this.clone(editor);
                for (int i = 0; i < node.numNodes; ++i) {
                    newNode = RopeNodes.pushLast(newNode, node.nodes[i], editor);
                }
                return newNode;
            }
            if (this.shift < node.shift) {
                return node.pushFirst(this, editor);
            }
            return this.pushLast(node, editor);
        }

        public Node slice(int start, int end2, Object editor) {
            int endIdx;
            if (start == end2) {
                return new Node(editor, 5);
            }
            if (start == 0 && end2 == this.numCodePoints()) {
                return this;
            }
            int startIdx = this.indexFor(start, this.pointOffsets);
            if (startIdx == (endIdx = this.indexFor(end2 - 1, this.pointOffsets))) {
                int offset2 = Node.offsetFor(startIdx, this.pointOffsets);
                Object child = RopeNodes.slice(this.nodes[startIdx], start - offset2, end2 - offset2, editor);
                if (this.shift > 5) {
                    return (Node)child;
                }
                return Node.from(editor, (byte[])child);
            }
            Node newNode = new Node(editor, 5);
            int sLower = Node.offsetFor(startIdx, this.pointOffsets);
            int sUpper = Node.offsetFor(startIdx + 1, this.pointOffsets);
            newNode = RopeNodes.pushLast(newNode, RopeNodes.slice(this.nodes[startIdx], start - sLower, sUpper - sLower, editor), editor);
            for (int i = startIdx + 1; i < endIdx; ++i) {
                newNode = RopeNodes.pushLast(newNode, this.nodes[i], editor);
            }
            int eLower = Node.offsetFor(endIdx, this.pointOffsets);
            return RopeNodes.pushLast(newNode, RopeNodes.slice(this.nodes[endIdx], 0, end2 - eLower, editor), editor);
        }

        public Node pushLast(byte[] chunk, Object editor) {
            int i;
            if (this.numCodeUnits() == 0 && this.shift > 5) {
                return this.pushLast(Node.from(editor, chunk), editor);
            }
            Node[] stack = new Node[this.shift / 5];
            stack[0] = this;
            for (i = 1; i < stack.length; ++i) {
                Node n = stack[i - 1];
                stack[i] = (Node)n.nodes[n.numNodes - 1];
            }
            if (stack[stack.length - 1].numNodes == 32) {
                return this.numNodes == 32 ? new Node(editor, this.shift + 5).pushLast(this, editor).pushLast(chunk, editor) : this.pushLast(new Node(editor, 5).pushLast(chunk, editor), editor);
            }
            for (i = 0; i < stack.length; ++i) {
                if (stack[i].editor == editor) continue;
                stack[i] = stack[i].clone(editor);
            }
            int numCodePoints = UnicodeChunk.numCodePoints(chunk);
            int numCodeUnits = UnicodeChunk.numCodeUnits(chunk);
            Node parent = stack[stack.length - 1];
            if (parent.nodes.length == parent.numNodes) {
                parent.grow(parent.numNodes << 2);
            }
            parent.unitOffsets[parent.numNodes] = parent.numCodeUnits();
            parent.pointOffsets[parent.numNodes] = parent.numCodePoints();
            ++parent.numNodes;
            for (int i2 = 0; i2 < stack.length; ++i2) {
                Node n = stack[i2];
                int lastIdx = n.numNodes - 1;
                n.nodes[lastIdx] = i2 == stack.length - 1 ? chunk : (byte[])stack[i2 + 1];
                int n2 = lastIdx;
                n.unitOffsets[n2] = n.unitOffsets[n2] + numCodeUnits;
                int n3 = lastIdx;
                n.pointOffsets[n3] = n.pointOffsets[n3] + numCodePoints;
            }
            return stack[0];
        }

        public Node pushLast(Node node, Object editor) {
            int i;
            if (node.numCodeUnits() == 0) {
                return this;
            }
            if (this.shift < node.shift) {
                return node.pushFirst(this, editor);
            }
            if (this.shift == node.shift) {
                return Node.from(editor, this.shift + 5, this, node);
            }
            Node[] stack = new Node[(this.shift - node.shift) / 5];
            stack[0] = this;
            for (i = 1; i < stack.length; ++i) {
                Node n = stack[i - 1];
                stack[i] = (Node)n.nodes[n.numNodes - 1];
            }
            if (stack[stack.length - 1].numNodes == 32) {
                return this.pushLast(Node.from(editor, node.shift + 5, node), editor);
            }
            for (i = 0; i < stack.length; ++i) {
                if (stack[i].editor == editor) continue;
                stack[i] = stack[i].clone(editor);
            }
            Node parent = stack[stack.length - 1];
            if (parent.nodes.length == parent.numNodes) {
                parent.grow(parent.numNodes << 1);
            }
            parent.unitOffsets[parent.numNodes] = parent.numCodeUnits();
            parent.pointOffsets[parent.numNodes] = parent.numCodePoints();
            ++parent.numNodes;
            int numCodePoints = node.numCodePoints();
            int numCodeUnits = node.numCodeUnits();
            for (int i2 = 0; i2 < stack.length; ++i2) {
                Node n = stack[i2];
                int lastIdx = n.numNodes - 1;
                n.nodes[lastIdx] = i2 == stack.length - 1 ? node : stack[i2 + 1];
                int n2 = lastIdx;
                n.unitOffsets[n2] = n.unitOffsets[n2] + numCodeUnits;
                int n3 = lastIdx;
                n.pointOffsets[n3] = n.pointOffsets[n3] + numCodePoints;
            }
            return stack[0];
        }

        public Node pushFirst(Node node, Object editor) {
            int i;
            if (node.numCodeUnits() == 0) {
                return this;
            }
            if (this.shift < node.shift) {
                return node.pushLast(this, editor);
            }
            if (this.shift == node.shift) {
                return Node.from(editor, this.shift + 5, node, this);
            }
            Node[] stack = new Node[(this.shift - node.shift) / 5];
            stack[0] = this;
            for (i = 1; i < stack.length; ++i) {
                Node n = stack[i - 1];
                stack[i] = (Node)n.nodes[0];
            }
            if (stack[stack.length - 1].numNodes == 32) {
                return this.pushFirst(Node.from(editor, node.shift + 5, node), editor);
            }
            for (i = 0; i < stack.length; ++i) {
                if (stack[i].editor == editor) continue;
                stack[i] = stack[i].clone(editor);
            }
            Node parent = stack[stack.length - 1];
            if (parent.nodes.length == parent.numNodes) {
                parent.grow(parent.numNodes << 1);
            }
            System.arraycopy(parent.nodes, 0, parent.nodes, 1, parent.numNodes);
            System.arraycopy(parent.unitOffsets, 0, parent.unitOffsets, 1, parent.numNodes);
            System.arraycopy(parent.pointOffsets, 0, parent.pointOffsets, 1, parent.numNodes);
            ++parent.numNodes;
            parent.unitOffsets[0] = 0;
            parent.pointOffsets[0] = 0;
            int numCodePoints = node.numCodePoints();
            int numCodeUnits = node.numCodeUnits();
            for (int i2 = 0; i2 < stack.length; ++i2) {
                Node n = stack[i2];
                n.nodes[0] = i2 == stack.length - 1 ? node : stack[i2 + 1];
                int j = 0;
                while (j < n.numNodes) {
                    int n2 = j;
                    n.unitOffsets[n2] = n.unitOffsets[n2] + numCodeUnits;
                    int n3 = j++;
                    n.pointOffsets[n3] = n.pointOffsets[n3] + numCodePoints;
                }
            }
            return stack[0];
        }

        private void grow(int len) {
            len = Math.min(32, len);
            int[] newUnitOffsets = new int[len];
            int[] newPointOffsets = new int[len];
            Object[] newNodes = new Object[len];
            System.arraycopy(this.unitOffsets, 0, newUnitOffsets, 0, this.numNodes);
            System.arraycopy(this.pointOffsets, 0, newPointOffsets, 0, this.numNodes);
            System.arraycopy(this.nodes, 0, newNodes, 0, this.numNodes);
            this.nodes = newNodes;
            this.unitOffsets = newUnitOffsets;
            this.pointOffsets = newPointOffsets;
        }

        public Node clone(Object editor) {
            Node n = new Node(editor);
            n.shift = this.shift;
            n.numNodes = this.numNodes;
            n.unitOffsets = (int[])this.unitOffsets.clone();
            n.pointOffsets = (int[])this.pointOffsets.clone();
            n.nodes = (Object[])this.nodes.clone();
            return n;
        }
    }

    public static interface ChunkUpdater {
        public byte[] update(int var1, byte[] var2);
    }
}

