/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.bifurcan;

import io.lacuna.bifurcan.Rope;
import io.lacuna.bifurcan.hash.PerlHash;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class Ropes {
    private Ropes() {
    }

    static int compare(Iterator<ByteBuffer> a2, Iterator<ByteBuffer> b) {
        ByteBuffer x = a2.next();
        ByteBuffer y = b.next();
        while (true) {
            int len = Math.min(x.remaining(), y.remaining());
            for (int k = 0; k < len; ++k) {
                byte by;
                byte bx = x.get();
                if (bx == (by = y.get())) continue;
                return (bx & 0xFF) - (by & 0xFF);
            }
            if (!x.hasRemaining()) {
                if (!a2.hasNext()) break;
                x = a2.next();
            }
            if (y.hasRemaining()) continue;
            y = b.next();
        }
        return 0;
    }

    public static int hash(Rope r) {
        return PerlHash.hash(0, r.bytes());
    }

    public static boolean equals(Rope a2, Rope b) {
        if (a2.size() != b.size()) {
            return false;
        }
        if (a2.size() == 0) {
            return true;
        }
        return Ropes.compare(a2.bytes(), b.bytes()) == 0;
    }
}

