/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Box;
import io.lacuna.artifex.Box2;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec3;

public class Box3
extends Box<Vec3, Box3> {
    public static final Box3 EMPTY = new Box3(Vec.vec(Double.NaN, Double.NaN, Double.NaN), Vec.vec(Double.NaN, Double.NaN, Double.NaN));
    public final double lx;
    public final double ly;
    public final double lz;
    public final double ux;
    public final double uy;
    public final double uz;

    Box3(double ax, double ay, double az, double bx, double by, double bz) {
        if (ax < bx) {
            this.lx = ax;
            this.ux = bx;
        } else {
            this.ux = ax;
            this.lx = bx;
        }
        if (ay < by) {
            this.ly = ay;
            this.uy = by;
        } else {
            this.uy = ay;
            this.ly = by;
        }
        if (az < bz) {
            this.lz = az;
            this.uz = bz;
        } else {
            this.uz = az;
            this.lz = bz;
        }
    }

    public Box3(Vec3 a2, Vec3 b) {
        this(a2.x, a2.y, a2.z, b.x, b.y, b.z);
    }

    public Box2 box2() {
        return new Box2(this.lx, this.ly, this.ux, this.uz);
    }

    @Override
    protected Box3 construct(Vec3 a2, Vec3 b) {
        return new Box3(a2, b);
    }

    @Override
    protected Box3 empty() {
        return EMPTY;
    }

    @Override
    public Vec3 lower() {
        return new Vec3(this.lx, this.ly, this.lz);
    }

    @Override
    public Vec3 upper() {
        return new Vec3(this.ux, this.uy, this.uz);
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }
}

