/*
 * Decompiled with CFR 0.152.
 */
package gli_.tga;

import gli_.MiscKt;
import gli_.tga.Header;
import gli_.tga.TGAImageReader$WhenMappings;
import glm_.ExtensionsKt;
import glm_.vec2.Vec2i;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unsigned.ByteKt;
import unsigned.ShortKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010$\u001a\u00020\u000e2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001dH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006)"}, d2={"Lgli_/tga/TGAImageReader;", "Ljavax/imageio/ImageReader;", "originatingProvider", "Ljavax/imageio/spi/ImageReaderSpi;", "(Ljavax/imageio/spi/ImageReaderSpi;)V", "header", "Lgli_/tga/Header;", "inputStream", "Ljavax/imageio/stream/ImageInputStream;", "getInputStream", "()Ljavax/imageio/stream/ImageInputStream;", "setInputStream", "(Ljavax/imageio/stream/ImageInputStream;)V", "checkImageIndex", "", "imageIndex", "", "checkImageReadParam", "param", "Ljavax/imageio/ImageReadParam;", "getHeader", "getHeight", "getImageMetadata", "Ljavax/imageio/metadata/IIOMetadata;", "getImageTypes", "", "Ljavax/imageio/ImageTypeSpecifier;", "getNumImages", "allowSearch", "", "getStreamMetadata", "getWidth", "read", "Ljava/awt/image/BufferedImage;", "readColorMap", "", "setInput", "input", "", "seekForwardOnly", "ignoreMetadata", "build"})
public final class TGAImageReader
extends ImageReader {
    @Nullable
    private ImageInputStream inputStream;
    private Header header;

    @Nullable
    public final ImageInputStream getInputStream() {
        return this.inputStream;
    }

    public final void setInputStream(@Nullable ImageInputStream imageInputStream) {
        this.inputStream = imageInputStream;
    }

    @Override
    public void setInput(@Nullable Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input == null) {
            this.inputStream = null;
            this.header = null;
        }
        if (!(input instanceof ImageInputStream)) {
            throw (Throwable)new IllegalArgumentException("Only ImageInputStreams are accepted.");
        }
        this.inputStream = (ImageInputStream)input;
        ((ImageInputStream)input).setByteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    @NotNull
    public final synchronized Header getHeader() {
        if (this.header != null) {
            Header header = this.header;
            if (header == null) {
                Intrinsics.throwNpe();
            }
            return header;
        }
        if (this.inputStream == null) {
            throw (Throwable)new IllegalStateException("There is no ImageInputStream from which the header can be read.");
        }
        ImageInputStream imageInputStream = this.inputStream;
        if (imageInputStream == null) {
            Intrinsics.throwNpe();
        }
        Header header = this.header = new Header(imageInputStream);
        if (header == null) {
            Intrinsics.throwNpe();
        }
        return header;
    }

    public final void checkImageIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw (Throwable)new IndexOutOfBoundsException("Image index out of bounds (" + imageIndex + " != 0).");
        }
    }

    @Override
    @NotNull
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) {
        ColorSpace rgb;
        int alphaMask;
        this.checkImageIndex(imageIndex);
        Header header = this.getHeader();
        switch (TGAImageReader$WhenMappings.$EnumSwitchMapping$0[header.getImageType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                alphaMask = header.getSamplesPerPixel() == 4 ? ExtensionsKt.getI(0xFF000000L) : 0;
                rgb = ColorSpace.getInstance(1000);
                break;
            }
            case 5: 
            case 6: {
                throw (Throwable)new IllegalArgumentException("Monochrome image type not supported.");
            }
            case 7: {
                throw (Throwable)new IllegalArgumentException("The image type is not known.");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createPacked(rgb, 255, 65280, 0xFF0000, alphaMask, 3, false);
        Iterator<ImageTypeSpecifier> iterator2 = CollectionsKt.arrayListOf(imageTypeSpecifier).iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator2, "arrayListOf(imageTypeSpecifier).iterator()");
        return iterator2;
    }

    @Override
    public int getNumImages(boolean allowSearch) {
        return 1;
    }

    @Override
    @Nullable
    public IIOMetadata getStreamMetadata() {
        return null;
    }

    @Override
    @Nullable
    public IIOMetadata getImageMetadata(int imageIndex) {
        return null;
    }

    @Override
    public int getHeight(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getHeader().getSize().getY();
    }

    @Override
    public int getWidth(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getHeader().getSize().getX();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BufferedImage read(int imageIndex, @Nullable ImageReadParam param) {
        WritableRaster raster;
        BufferedImage image;
        Iterator<ImageTypeSpecifier> imageTypes = this.getImageTypes(imageIndex);
        if (!imageTypes.hasNext()) {
            throw (Throwable)new IOException("Unsupported Image Type");
        }
        Header header = this.getHeader();
        this.checkImageReadParam(param, header);
        Vec2i size = header.getSize();
        int[] colorMap = this.readColorMap(header);
        ImageInputStream imageInputStream = this.inputStream;
        if (imageInputStream == null) {
            Intrinsics.throwNpe();
        }
        ImageInputStream input = imageInputStream;
        input.seek(ExtensionsKt.getL(header.getPixelDataOffset()));
        BufferedImage bufferedImage = image = TGAImageReader.access$getDestination$s-494737954(param, imageTypes, size.getX(), size.getY());
        Intrinsics.checkExpressionValueIsNotNull(bufferedImage, "image");
        WritableRaster imageRaster = bufferedImage.getRaster();
        SampleModel sampleModel = image.getSampleModel();
        Intrinsics.checkExpressionValueIsNotNull(sampleModel, "image.sampleModel");
        int numberOfImageBands = sampleModel.getNumBands();
        TGAImageReader.access$checkReadParamBandSettings$s-494737954(param, header.getSamplesPerPixel(), numberOfImageBands);
        ImageReadParam imageReadParam = param;
        int[] destinationBands = (int[])(imageReadParam != null ? imageReadParam.getDestinationBands() : null);
        WritableRaster writableRaster = raster = imageRaster.createWritableChild(0, 0, size.getX(), size.getY(), 0, 0, destinationBands);
        Intrinsics.checkExpressionValueIsNotNull(writableRaster, "raster");
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        if (dataBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.image.DataBufferInt");
        }
        int[] intData2 = ((DataBufferInt)dataBuffer).getData();
        int runLength = 0;
        boolean readPixel = true;
        boolean isRaw = false;
        int pixel = 0;
        int n = 0;
        int n2 = size.getY();
        while (n < n2) {
            void y;
            void index = header.getBottomToTop() ? size.getY() - y - 1 : y;
            index *= size.getX().intValue();
            int n3 = 0;
            int n4 = size.getX();
            while (n3 < n4) {
                void x;
                if (header.isCompressed()) {
                    if (runLength > 0) {
                        --runLength;
                        readPixel = isRaw;
                    } else {
                        runLength = ByteKt.toUInt(input.readByte());
                        isRaw = MiscKt.hasnt(runLength, 128);
                        if (!isRaw) {
                            runLength -= 128;
                        }
                        readPixel = true;
                    }
                }
                if (readPixel) {
                    int alpha = 255;
                    switch (header.getBitsPerPixel()) {
                        case 15: 
                        case 16: {
                            int data2 = ShortKt.toUInt(input.readShort());
                            int red = (data2 >>> 10 & 0x1F) << 3;
                            int green = (data2 >>> 5 & 0x1F) << 3;
                            int blue = (data2 & 0x1F) << 3;
                            pixel = red | green << 8 | blue << 16;
                            break;
                        }
                        case 24: 
                        case 32: {
                            int blue = ByteKt.toUInt(input.readByte());
                            int green = ByteKt.toUInt(input.readByte());
                            int red = ByteKt.toUInt(input.readByte());
                            if (header.getBitsPerPixel() == 32) {
                                alpha = ByteKt.toUInt(input.readByte());
                            }
                            pixel = red | green << 8 | blue << 16 | alpha << 24;
                            break;
                        }
                        default: {
                            int n5;
                            int blue;
                            int green;
                            int red;
                            int data2 = ByteKt.toUInt(input.readByte());
                            if (header.getHasColorMap()) {
                                if (colorMap == null) {
                                    Intrinsics.throwNpe();
                                }
                                n5 = colorMap[data2];
                            } else {
                                red = data2;
                                green = data2;
                                blue = data2;
                                n5 = red | green << 8 | blue << 16;
                            }
                            pixel = n5;
                        }
                    }
                }
                intData2[index] = pixel;
                ++index;
                ++x;
            }
            ++y;
        }
        return image;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final int[] readColorMap(@NotNull Header header) {
        Intrinsics.checkParameterIsNotNull(header, "header");
        if (!header.getHasColorMap()) {
            return null;
        }
        ImageInputStream imageInputStream = this.inputStream;
        if (imageInputStream == null) {
            Intrinsics.throwNpe();
        }
        imageInputStream.seek(ExtensionsKt.getL(header.getColorMapDataOffset()));
        int numberOfColors = header.getColorMapLength();
        int bitsPerEntry = header.getBitsPerColorMapEntry();
        int[] colorMap = new int[numberOfColors + 1];
        int n = 0;
        int n2 = numberOfColors;
        while (n < n2) {
            void i;
            int blue;
            int green;
            int red;
            if (this.inputStream == null) {
                Intrinsics.throwNpe();
            }
            switch (bitsPerEntry) {
                case 15: 
                case 16: {
                    ImageInputStream input;
                    int data2 = ShortKt.toUInt(input.readShort());
                    red = (data2 >>> 10 & 0x1F) << 3;
                    green = (data2 >>> 5 & 0x1F) << 3;
                    blue = (data2 & 0x1F) << 3;
                    break;
                }
                case 24: 
                case 32: {
                    ImageInputStream input;
                    blue = ByteKt.toUInt(input.readByte());
                    green = ByteKt.toUInt(input.readByte());
                    red = ByteKt.toUInt(input.readByte());
                    break;
                }
                default: {
                    int data2;
                    ImageInputStream input;
                    blue = data2 = ByteKt.toUInt(input.readByte());
                    green = data2;
                    red = data2;
                }
            }
            colorMap[i] = red | green << 8 | blue << 16;
            ++i;
        }
        return colorMap;
    }

    public final void checkImageReadParam(@Nullable ImageReadParam param, @NotNull Header header) {
        Intrinsics.checkParameterIsNotNull(header, "header");
        if (param != null) {
            Vec2i size = header.getSize();
            Rectangle sourceROI = param.getSourceRegion();
            if (sourceROI != null && (sourceROI.x != 0 || sourceROI.y != 0 || sourceROI.width != size.getX() || sourceROI.height != size.getY())) {
                throw (Throwable)new IOException("The source region of interest is not the default.");
            }
            Rectangle destinationROI = param.getSourceRegion();
            if (destinationROI != null && (destinationROI.x != 0 || destinationROI.y != 0 || destinationROI.width != size.getX() || destinationROI.height != size.getY())) {
                throw (Throwable)new IOException("The destination region of interest is not the default.");
            }
            if (param.getSourceXSubsampling() != 1 || param.getSourceYSubsampling() != 1) {
                throw (Throwable)new IOException("Source sub-sampling is not supported.");
            }
        }
    }

    public TGAImageReader(@NotNull ImageReaderSpi originatingProvider) {
        Intrinsics.checkParameterIsNotNull(originatingProvider, "originatingProvider");
        super(originatingProvider);
    }

    public static final /* synthetic */ BufferedImage access$getDestination$s-494737954(ImageReadParam p0, Iterator p1, int p2, int p3) {
        return ImageReader.getDestination(p0, p1, p2, p3);
    }

    public static final /* synthetic */ void access$checkReadParamBandSettings$s-494737954(ImageReadParam p0, int p1, int p2) {
        ImageReader.checkReadParamBandSettings(p0, p1, p2);
    }
}

