/*
 * Decompiled with CFR 0.152.
 */
package gli_;

import gli_.Format;
import gli_.GliKt;
import gli_.ReinterpretersKt;
import gli_.reinterpreter;
import glm_.func.func_vector1_relational;
import glm_.func.func_vector2_relational;
import glm_.func.func_vector3_relational;
import glm_.glm;
import glm_.vec1.Vec1i;
import glm_.vec2.Vec2i;
import glm_.vec3.Vec3i;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import kool.BufferKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0004B/\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010%\u001a\u00020\nJV\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H201\"\u0006\b\u0000\u00102\u0018\u0001H\u0086\bJ\r\u00103\u001a\u0004\u0018\u00010'\u00a2\u0006\u0002\u00104J\u0006\u00105\u001a\u000206J\u0013\u00107\u001a\u0002062\b\u00108\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020\nJ\u0016\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\nJ\b\u0010<\u001a\u00020\nH\u0016J\u0016\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?J\u0016\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020A2\u0006\u0010@\u001a\u00020AJ\u0016\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020\n2\u0006\u0010@\u001a\u00020\nJ&\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\n2\u0006\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\nJ\u000e\u0010E\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nJ\u0006\u0010F\u001a\u000206J\u0006\u0010G\u001a\u00020\nR\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R$\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R$\u0010\f\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0017\"\u0004\b!\u0010\u0019\u00a8\u0006H"}, d2={"Lgli_/Storage;", "", "()V", "storage", "(Lgli_/Storage;)V", "format", "Lgli_/Format;", "extent", "Lglm_/vec3/Vec3i;", "layers", "", "faces", "levels", "(Lgli_/Format;Lglm_/vec3/Vec3i;III)V", "blockCount", "<set-?>", "blockExtent", "getBlockExtent", "()Lglm_/vec3/Vec3i;", "setBlockExtent", "(Lglm_/vec3/Vec3i;)V", "blockSize", "getBlockSize", "()I", "setBlockSize", "(I)V", "data", "Ljava/nio/ByteBuffer;", "getFaces", "setFaces", "getLayers", "setLayers", "getLevels", "setLevels", "baseOffset", "layer", "face", "level", "copy", "", "storageSrc", "layerSrc", "faceSrc", "levelSrc", "blockIndexSrc", "layerDst", "faceDst", "levelDst", "blockIndexDst", "Lgli_/reinterpreter;", "T", "dispose", "()Lkotlin/Unit;", "empty", "", "equals", "other", "faceSize", "baseLevel", "maxLevel", "hashCode", "imageOffset", "coord", "Lglm_/vec1/Vec1i;", "extend", "Lglm_/vec2/Vec2i;", "layerSize", "baseFace", "maxFace", "levelSize", "notEmpty", "size", "build"})
public final class Storage {
    private int layers;
    private int faces;
    private int levels;
    private int blockSize;
    private Vec3i blockCount;
    @NotNull
    private Vec3i blockExtent;
    private Vec3i extent;
    private ByteBuffer data;

    public final int getLayers() {
        return this.layers;
    }

    private final void setLayers(int n) {
        this.layers = n;
    }

    public final int getFaces() {
        return this.faces;
    }

    private final void setFaces(int n) {
        this.faces = n;
    }

    public final int getLevels() {
        return this.levels;
    }

    private final void setLevels(int n) {
        this.levels = n;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    private final void setBlockSize(int n) {
        this.blockSize = n;
    }

    @NotNull
    public final Vec3i getBlockExtent() {
        return this.blockExtent;
    }

    private final void setBlockExtent(Vec3i vec3i) {
        this.blockExtent = vec3i;
    }

    public final boolean empty() {
        return this.data == null;
    }

    public final boolean notEmpty() {
        return this.data != null;
    }

    @NotNull
    public final Vec3i blockCount(int level) {
        int n = level;
        int n2 = n = 0 <= n && this.levels > n ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return glm.INSTANCE.ceilMultiple(this.extent(level), this.blockExtent).div(this.blockExtent);
    }

    @NotNull
    public final Vec3i extent(int level) {
        int n = level;
        int n2 = n = 0 <= n && this.levels > n ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return glm.INSTANCE.max(this.extent.shr(level), 1);
    }

    public final int size() {
        ByteBuffer byteBuffer = this.data;
        if (byteBuffer == null) {
            Intrinsics.throwNpe();
        }
        Buffer $receiver$iv = byteBuffer;
        return $receiver$iv.remaining();
    }

    @NotNull
    public final ByteBuffer data() {
        ByteBuffer byteBuffer = this.data;
        if (byteBuffer == null) {
            Intrinsics.throwNpe();
        }
        return byteBuffer;
    }

    private final <T> reinterpreter<T> data() {
        reinterpreter reinterpreter2;
        Intrinsics.reifiedOperationMarker(4, "T");
        reinterpreter $receiver = reinterpreter2 = ReinterpretersKt.getReinterpreter(Reflection.getOrCreateKotlinClass(Object.class));
        $receiver.setData(this.data());
        return reinterpreter2;
    }

    /*
     * WARNING - void declaration
     */
    public final int baseOffset(int layer, int face, int level) {
        int n;
        void $receiver$iv;
        int n2 = this.notEmpty();
        if (_Assertions.ENABLED && n2 == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n2 = layer;
        int n3 = n2 = 0 <= n2 && this.layers > n2 && 0 <= (n2 = face) && this.faces > n2 && 0 <= (n2 = level) && this.levels > n2 ? 1 : 0;
        if (_Assertions.ENABLED && n2 == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int layerSize = this.layerSize(0, this.faces - 1, 0, this.levels - 1);
        int faceSize = this.faceSize(0, this.levels - 1);
        Iterable iterable = RangesKt.until(0, level);
        int n4 = layerSize * layer + faceSize * face;
        int sum$iv = 0;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int element$iv;
            int n5 = element$iv = ((IntIterator)iterator2).nextInt();
            n = sum$iv;
            int n6 = this.levelSize((int)it);
            sum$iv = n + n6;
        }
        n = sum$iv;
        return n4 + n;
    }

    public final int imageOffset(int coord, int extend2) {
        boolean bl;
        boolean bl2 = bl = coord <= extend2;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return coord;
    }

    public final int imageOffset(@NotNull Vec1i coord, @NotNull Vec1i extend2) {
        Intrinsics.checkParameterIsNotNull(coord, "coord");
        Intrinsics.checkParameterIsNotNull(extend2, "extend");
        boolean bl = glm.INSTANCE.all(func_vector1_relational.DefaultImpls.lessThan$default(glm.INSTANCE, coord, extend2, null, 4, null));
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return coord.x.intValue();
    }

    public final int imageOffset(@NotNull Vec2i coord, @NotNull Vec2i extend2) {
        Intrinsics.checkParameterIsNotNull(coord, "coord");
        Intrinsics.checkParameterIsNotNull(extend2, "extend");
        boolean bl = glm.INSTANCE.all(func_vector2_relational.DefaultImpls.lessThan$default(glm.INSTANCE, coord, extend2, null, 4, null));
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return coord.getX() + coord.getY() * extend2.getX();
    }

    public final int imageOffset(@NotNull Vec3i coord, @NotNull Vec3i extent) {
        Intrinsics.checkParameterIsNotNull(coord, "coord");
        Intrinsics.checkParameterIsNotNull(extent, "extent");
        boolean bl = glm.INSTANCE.all(func_vector3_relational.DefaultImpls.lessThan$default(glm.INSTANCE, coord, extent, null, 4, null));
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return coord.getX() + coord.getY() * extent.getX() + coord.getZ() * extent.getX() * extent.getY();
    }

    /*
     * WARNING - void declaration
     */
    public final void copy(@NotNull Storage storageSrc, int layerSrc, int faceSrc, int levelSrc, @NotNull Vec3i blockIndexSrc, int layerDst, int faceDst, int levelDst, @NotNull Vec3i blockIndexDst, @NotNull Vec3i blockCount) {
        Intrinsics.checkParameterIsNotNull(storageSrc, "storageSrc");
        Intrinsics.checkParameterIsNotNull(blockIndexSrc, "blockIndexSrc");
        Intrinsics.checkParameterIsNotNull(blockIndexDst, "blockIndexDst");
        Intrinsics.checkParameterIsNotNull(blockCount, "blockCount");
        int baseOffsetSrc = storageSrc.baseOffset(layerSrc, faceSrc, levelSrc);
        int baseOffsetDst = this.baseOffset(layerDst, faceDst, levelDst);
        ByteBuffer byteBuffer = storageSrc.data;
        if (byteBuffer == null) {
            Intrinsics.throwNpe();
        }
        Buffer $receiver$iv = byteBuffer;
        long imageSrc = MemoryUtil.memAddress($receiver$iv) + (long)baseOffsetSrc;
        ByteBuffer byteBuffer2 = this.data;
        if (byteBuffer2 == null) {
            Intrinsics.throwNpe();
        }
        Buffer $receiver$iv22 = byteBuffer2;
        long imageDst = MemoryUtil.memAddress($receiver$iv22) + (long)baseOffsetDst;
        int $receiver$iv22 = 0;
        int n = blockCount.getZ();
        while ($receiver$iv22 < n) {
            void blockIndexZ;
            int n2 = 0;
            int n3 = blockCount.getY();
            while (n2 < n3) {
                void blockIndexY;
                Vec3i blockIndex = new Vec3i(0, (int)blockIndexY, (int)blockIndexZ);
                int offsetSrc = storageSrc.imageOffset(blockIndexSrc.plus(blockIndex), storageSrc.extent(levelSrc)) * storageSrc.blockSize;
                int offsetDst = this.imageOffset(blockIndexDst.plus(blockIndex), this.extent(levelDst)) * this.blockSize;
                long dataSrc = imageSrc + (long)offsetSrc;
                long dataDst = imageDst + (long)offsetDst;
                GliKt.memCopy(dataSrc, dataDst, this.blockSize * blockCount.getX());
                ++blockIndexY;
            }
            ++blockIndexZ;
        }
    }

    public final int levelSize(int level) {
        int n = level;
        int n2 = n = 0 <= n && this.levels > n ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.blockSize * glm.INSTANCE.compMul(this.blockCount(level));
    }

    /*
     * WARNING - void declaration
     */
    public final int faceSize(int baseLevel, int maxLevel) {
        int n = maxLevel;
        int n2 = n = 0 <= n && this.levels > n ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n = baseLevel;
        int n3 = n = 0 <= n && this.levels > n ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int n4 = n = baseLevel <= maxLevel ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n = baseLevel;
        Iterable $receiver$iv = new IntRange(n, maxLevel);
        int sum$iv = 0;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int element$iv;
            int n5 = element$iv = ((IntIterator)iterator2).nextInt();
            int n6 = sum$iv;
            int n7 = this.levelSize((int)it);
            sum$iv = n6 + n7;
        }
        return sum$iv;
    }

    public final int layerSize(int baseFace, int maxFace, int baseLevel, int maxLevel) {
        int n = maxFace;
        int n2 = n = 0 <= n && this.faces > n ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n = baseFace;
        int n3 = n = 0 <= n && this.faces > n ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n = maxLevel;
        int n4 = n = 0 <= n && this.levels > n ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        n = baseLevel;
        int n5 = n = 0 <= n && this.levels > n ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.faceSize(baseLevel, maxLevel) * (maxFace - baseFace + 1);
    }

    @Nullable
    public final Unit dispose() {
        Unit unit;
        ByteBuffer byteBuffer = this.data;
        if (byteBuffer != null) {
            BufferKt.free(byteBuffer);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public boolean equals(@Nullable Object other) {
        return !(other instanceof Storage) ? false : this.layers == ((Storage)other).layers && this.faces == ((Storage)other).faces && this.levels == ((Storage)other).levels && this.blockSize == ((Storage)other).blockSize && Intrinsics.areEqual(this.blockCount, ((Storage)other).blockCount) && Intrinsics.areEqual(this.blockExtent, ((Storage)other).blockExtent) && Intrinsics.areEqual(this.extent, ((Storage)other).extent) && Intrinsics.areEqual(this.data, ((Storage)other).data);
    }

    public int hashCode() {
        int result2 = this.layers;
        result2 = 31 * result2 + this.faces;
        result2 = 31 * result2 + this.levels;
        result2 = 31 * result2 + this.blockSize;
        result2 = 31 * result2 + this.blockCount.hashCode();
        result2 = 31 * result2 + this.blockExtent.hashCode();
        result2 = 31 * result2 + this.extent.hashCode();
        ByteBuffer byteBuffer = this.data;
        result2 = 31 * result2 + (byteBuffer != null ? byteBuffer.hashCode() : 0);
        return result2;
    }

    public Storage() {
        this.blockCount = new Vec3i(0);
        this.blockExtent = new Vec3i(0);
        this.extent = new Vec3i(0);
    }

    /*
     * WARNING - void declaration
     */
    public Storage(@NotNull Storage storage2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(storage2, "storage");
        this.blockCount = new Vec3i(0);
        this.blockExtent = new Vec3i(0);
        this.extent = new Vec3i(0);
        this.layers = storage2.layers;
        this.faces = storage2.faces;
        this.levels = storage2.levels;
        this.blockSize = storage2.blockSize;
        this.blockCount = new Vec3i(storage2.blockCount);
        this.blockExtent = new Vec3i(storage2.blockExtent);
        this.extent = new Vec3i(storage2.extent);
        ByteBuffer byteBuffer = storage2.data;
        if (byteBuffer == null) {
            Intrinsics.throwNpe();
        }
        Buffer buffer = byteBuffer;
        Storage storage3 = this;
        long l = MemoryUtil.memAddress((Buffer)$receiver$iv);
        ByteBuffer byteBuffer2 = storage2.data;
        if (byteBuffer2 == null) {
            Intrinsics.throwNpe();
        }
        storage3.data = MemoryUtil.memByteBuffer(l, byteBuffer2.remaining());
    }

    public Storage(@NotNull Format format, @NotNull Vec3i extent, int layers2, int faces, int levels) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)format, "format");
        Intrinsics.checkParameterIsNotNull(extent, "extent");
        this.blockCount = new Vec3i(0);
        this.blockExtent = new Vec3i(0);
        this.extent = new Vec3i(0);
        this.layers = layers2;
        this.faces = faces;
        this.levels = levels;
        this.blockSize = format.getBlockSize();
        this.blockCount = glm.INSTANCE.max(extent.div(format.getBlockExtend()), 1);
        this.blockExtent = format.getBlockExtend();
        this.extent = extent;
        boolean bl2 = bl = layers2 >= 0 && faces >= 0 && levels >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = glm.INSTANCE.all(func_vector3_relational.DefaultImpls.greaterThan$default(glm.INSTANCE, extent, new Vec3i(0), null, 4, null));
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.data = MemoryUtil.memCalloc(this.layerSize(0, faces - 1, 0, levels - 1) * layers2);
    }
}

