import HTTP

extension Message {
    public static var mediaTypes: [String: String] {
        return Vapor.mediaTypes
    }
}

// Scraped from http://www.freeformatter.com/mime-types-list.html

private let mediaTypes = [
    "aw": "application/applixware", // Applixware Vistasource
    "atom": "application/atom+xml", // Atom Syndication Format RFC 4287
    "atomcat": "application/atomcat+xml", // Atom Publishing Protocol RFC 5023
    "atomsvc": "application/atomsvc+xml", // Atom Publishing Protocol Service Document RFC 5023
    "ccxml": "application/ccxml+xml", // Voice Browser Call Control Voice Browser Call Control: CCXML Version 1.0
    "cdmia": "application/cdmi-capability", // Cloud Data Management Interface (CDMI) - Capability RFC 6208
    "cdmic": "application/cdmi-container", // Cloud Data Management Interface (CDMI) - Contaimer RFC 6209
    "cdmid": "application/cdmi-domain", // Cloud Data Management Interface (CDMI) - Domain RFC 6210
    "cdmio": "application/cdmi-object", // Cloud Data Management Interface (CDMI) - Object RFC 6211
    "cdmiq": "application/cdmi-queue", // Cloud Data Management Interface (CDMI) - Queue RFC 6212
    "cu": "application/cu-seeme", // CU-SeeMe White Pine
    "davmount": "application/davmount+xml", // Web Distributed Authoring and Versioning RFC 4918
    "dssc": "application/dssc+der", // Data Structure for the Security Suitability of Cryptographic Algorithms RFC 5698
    "xdssc": "application/dssc+xml", // Data Structure for the Security Suitability of Cryptographic Algorithms RFC 5698
    "es": "application/ecmascript", // ECMAScript ECMA-357
    "emma": "application/emma+xml", // Extensible MultiModal Annotation EMMA: Extensible MultiModal Annotation markup languageWikipedia: EPUB
    "exi": "application/exi", // Efficient XML Interchange Efficient XML Interchange (EXI) Best Practices
    "pfr": "application/font-tdpfr", // Portable Font Resource RFC 3073
    "stk": "application/hyperstudio", // Hyperstudio IANA - Hyperstudio
    "ipfix": "application/ipfix", // Internet Protocol Flow Information Export RFC 3917
    "jar": "application/java-archive", // Java Archive Wikipedia: JAR file format
    "ser": "application/java-serialized-object", // Java Serialized Object Java Serialization API
    "class": "application/java-vm", // Java Bytecode File Wikipedia: Java Bytecode
    "js": "application/javascript", // JavaScript JavaScript
    "json": "application/json", // JavaScript Object Notation (JSON) Wikipedia: JSON
    "hqx": "application/mac-binhex40", // Macintosh BinHex 4.0 MacMIME
    "cpt": "application/mac-compactpro", // Compact Pro Compact Pro
    "mads": "application/mads+xml", // Metadata Authority  Description Schema RFC 6207
    "mrc": "application/marc", // MARC Formats RFC 2220
    "mrcx": "application/marcxml+xml", // MARC21 XML Schema RFC 6207
    "ma": "application/mathematica", // Mathematica Notebooks IANA - Mathematica
    "mathml": "application/mathml+xml", // Mathematical Markup Language W3C Math Home
    "mbox": "application/mbox", // Mbox database files RFC 4155
    "mscml": "application/mediaservercontrol+xml", // Media Server Control Markup Language RFC 5022
    "meta4": "application/metalink4+xml", // Metalink Wikipedia: Metalink
    "mets": "application/mets+xml", // Metadata Encoding and Transmission Standard RFC 6207
    "mods": "application/mods+xml", // Metadata Object Description Schema RFC 6207
    "m21": "application/mp21", // MPEG-21 Wikipedia: MPEG-21
    "doc": "application/msword", // Microsoft Word Wikipedia: Microsoft Word
    "mxf": "application/mxf", // Material Exchange Format RFC 4539
    "bin": "application/octet-stream", // Binary Data
    "oda": "application/oda", // Office Document Architecture RFC 2161
    "opf": "application/oebps-package+xml", // Open eBook Publication Structure Wikipedia: Open eBook
    "ogx": "application/ogg", // Ogg Wikipedia: Ogg
    "onetoc": "application/onenote", // Microsoft OneNote MS OneNote 2010
    "xer": "application/patch-ops-error+xml", // XML Patch Framework RFC 5261
    "pdf": "application/pdf", // Adobe Portable Document Format Adobe PDF
    "pgp": "application/pgp-signature", // Pretty Good Privacy - Signature RFC 2015
    "prf": "application/pics-rules", // PICSRules W3C PICSRules
    "p10": "application/pkcs10", // PKCS #10 - Certification Request Standard RFC 2986
    "p7m": "application/pkcs7-mime", // PKCS #7 - Cryptographic Message Syntax Standard RFC 2315
    "p7s": "application/pkcs7-signature", // PKCS #7 - Cryptographic Message Syntax Standard RFC 2315
    "p8": "application/pkcs8", // PKCS #8 - Private-Key Information Syntax Standard RFC 5208
    "ac": "application/pkix-attr-cert", // Attribute Certificate RFC 5877
    "cer": "application/pkix-cert", // Internet Public Key Infrastructure - Certificate RFC 2585
    "crl": "application/pkix-crl", // Internet Public Key Infrastructure - Certificate Revocation Lists RFC 2585
    "pkipath": "application/pkix-pkipath", // Internet Public Key Infrastructure - Certification Path RFC 2585
    "pki": "application/pkixcmp", // Internet Public Key Infrastructure - Certificate Management Protocole RFC 2585
    "pls": "application/pls+xml", // Pronunciation Lexicon Specification RFC 4267
    "ai": "application/postscript", // PostScript Wikipedia: PostScript
    "cww": "application/prs.cww", // CU-Writer
    "pskcxml": "application/pskc+xml", // Portable Symmetric Key Container RFC 6030
    "rdf": "application/rdf+xml", // Resource Description Framework RFC 3870
    "rif": "application/reginfo+xml", // IMS Networks
    "rnc": "application/relax-ng-compact-syntax", // Relax NG Compact Syntax Relax NG
    "rl": "application/resource-lists+xml", // XML Resource Lists RFC 4826
    "rld": "application/resource-lists-diff+xml", // XML Resource Lists Diff RFC 4826
    "rs": "application/rls-services+xml", // XML Resource Lists RFC 4826
    "rsd": "application/rsd+xml", // Really Simple Discovery Wikipedia: Really Simple Discovery
    "rss, .xml": "application/rss+xml", // RSS - Really Simple Syndication Wikipedia: RSS
    "rtf": "application/rtf", // Rich Text Format Wikipedia: Rich Text Format
    "sbml": "application/sbml+xml", // Systems Biology Markup Language RFC 3823
    "scq": "application/scvp-cv-request", // Server-Based Certificate Validation Protocol - Validation Request RFC 5055
    "scs": "application/scvp-cv-response", // Server-Based Certificate Validation Protocol - Validation Response RFC 5055
    "spq": "application/scvp-vp-request", // Server-Based Certificate Validation Protocol - Validation Policies - Request RFC 5055
    "spp": "application/scvp-vp-response", // Server-Based Certificate Validation Protocol - Validation Policies - Response RFC 5055
    "sdp": "application/sdp", // Session Description Protocol RFC 2327
    "setpay": "application/set-payment-initiation", // Secure Electronic Transaction - Payment IANA: SET PaymentIANA: SET
    "shf": "application/shf+xml", // S Hexdump Format RFC 4194
    "smi": "application/smil+xml", // Synchronized Multimedia Integration Language RFC 4536
    "rq": "application/sparql-query", // SPARQL - Query W3C SPARQL
    "srx": "application/sparql-results+xml", // SPARQL - Results W3C SPARQL
    "gram": "application/srgs", // Speech Recognition Grammar Specification W3C Speech Grammar
    "grxml": "application/srgs+xml", // Speech Recognition Grammar Specification - XML W3C Speech Grammar
    "sru": "application/sru+xml", // Search/Retrieve via URL Response Format RFC 6207
    "ssml": "application/ssml+xml", // Speech Synthesis Markup Language W3C Speech Synthesis
    "tei": "application/tei+xml", // Text Encoding and Interchange RFC 6129
    "tfi": "application/thraud+xml", // Sharing Transaction Fraud Data RFC 5941
    "tsd": "application/timestamped-data", // Time Stamped Data Envelope RFC 5955
    "plb": "application/vnd.3gpp.pic-bw-large", // 3rd Generation Partnership Project - Pic Large 3GPP
    "psb": "application/vnd.3gpp.pic-bw-small", // 3rd Generation Partnership Project - Pic Small 3GPP
    "pvb": "application/vnd.3gpp.pic-bw-var", // 3rd Generation Partnership Project - Pic Var 3GPP
    "tcap": "application/vnd.3gpp2.tcap", // 3rd Generation Partnership Project - Transaction Capabilities Application Part 3GPP
    "pwn": "application/vnd.3m.post-it-notes", // 3M Post It Notes IANA: 3M Post It NotesIANA: Simply AccountingIANA: Simply AccountingIANA: ACU Cobol
    "atc": "application/vnd.acucorp", // ACU Cobol IANA: ACU Cobol
    "air": "application/vnd.adobe.air-application-installer-package+zip", // Adobe AIR Application Building AIR Applications
    "fxp": "application/vnd.adobe.fxp", // Adobe Flex Project IANA: Adobe Flex Project
    "xdp": "application/vnd.adobe.xdp+xml", // Adobe XML Data Package Wikipedia: XML Data Package
    "xfdf": "application/vnd.adobe.xfdf", // Adobe XML Forms Data Format Wikipedia: XML Portable Document Format
    "ahead": "application/vnd.ahead.space", // Ahead AIR Application IANA: Ahead AIR ApplicationIANA: AirZip
    "azs": "application/vnd.airzip.filesecure.azs", // AirZip FileSECURE IANA: AirZip
    "azw": "application/vnd.amazon.ebook", // Amazon Kindle eBook format Kindle Direct Publishing
    "acc": "application/vnd.americandynamics.acc", // Active Content Compression IANA: Active Content
    "ami": "application/vnd.amiga.ami", // AmigaDE IANA: Amiga
    "apk": "application/vnd.android.package-archive", // Android Package Archive Wikipedia: APK File Format
    "cii": "application/vnd.anser-web-certificate-issue-initiation", // ANSER-WEB Terminal Client - Certificate Issue IANA:
    "fti": "application/vnd.anser-web-funds-transfer-initiation", // ANSER-WEB Terminal Client - Web Funds Transfer IANA:
    "atx": "application/vnd.antix.game-component", // Antix Game Player IANA: Antix Game
    "mpkg": "application/vnd.apple.installer+xml", // Apple Installer Package IANA: Apple InstallerWikipedia: M3U
    "swi": "application/vnd.aristanetworks.swi", // Arista Networks Software Image IANA: Arista Networks
    "aep": "application/vnd.audiograph", // Audiograph IANA: Audiograph
    "mpm": "application/vnd.blueice.multipass", // Blueice Research Multipass IANA:
    "bmi": "application/vnd.bmi", // BMI Drawing Data Interchange IANA: BMI
    "rep": "application/vnd.businessobjects", // BusinessObjects IANA: BusinessObjects
    "cdxml": "application/vnd.chemdraw+xml", // CambridgeSoft Chem Draw IANA: Chem Draw
    "mmd": "application/vnd.chipnuts.karaoke-mmd", // Karaoke on Chipnuts Chipsets IANA: Chipnuts KaraokeIANA: Cinderella
    "cla": "application/vnd.claymore", // Claymore Data Files IANA: Claymore
    "rp9": "application/vnd.cloanto.rp9", // RetroPlatform Player IANA: RetroPlatform PlayerIANA: Clonk
    "c11amc": "application/vnd.cluetrust.cartomobile-config", // ClueTrust CartoMobile - Config IANA:
    "c11amz": "application/vnd.cluetrust.cartomobile-config-pkg", // ClueTrust CartoMobile - Config Package IANA:
    "csp": "application/vnd.commonspace", // Sixth Floor Media - CommonSpace IANA: CommonSpace
    "cdbcmsg": "application/vnd.contact.cmsg", // CIM Database IANA: CIM Database
    "cmc": "application/vnd.cosmocaller", // CosmoCaller IANA: CosmoCaller
    "clkx": "application/vnd.crick.clicker", // CrickSoftware - Clicker IANA: Clicker
    "clkk": "application/vnd.crick.clicker.keyboard", // CrickSoftware - Clicker - Keyboard IANA: Clicker
    "clkp": "application/vnd.crick.clicker.palette", // CrickSoftware - Clicker - Palette IANA: Clicker
    "clkt": "application/vnd.crick.clicker.template", // CrickSoftware - Clicker - Template IANA: Clicker
    "clkw": "application/vnd.crick.clicker.wordbank", // CrickSoftware - Clicker - Wordbank IANA: Clicker
    "wbs": "application/vnd.criticaltools.wbs+xml", // Critical Tools - PERT Chart EXPERT IANA: Critical ToolsIANA: PosML
    "ppd": "application/vnd.cups-ppd", // Adobe PostScript Printer Description File Format IANA: Cups
    "car": "application/vnd.curl.car", // CURL Applet IANA: CURL Applet
    "pcurl": "application/vnd.curl.pcurl", // CURL Applet IANA: CURL Applet
    "rdz": "application/vnd.data-vision.rdz", // RemoteDocs R-Viewer IANA: Data-Vision
    "fe_launch": "application/vnd.denovo.fcselayout-link", // FCS Express Layout Link IANA: FCS
    "dna": "application/vnd.dna", // New Moon Liftoff/DNA IANA: New Moon Liftoff/DNA
    "mlp": "application/vnd.dolby.mlp", // Dolby Meridian Lossless Packing IANA: Dolby Meridian Lossless
    "dpg": "application/vnd.dpgraph", // DPGraph IANA: DPGraph
    "dfac": "application/vnd.dreamfactory", // DreamFactory IANA: DreamFactory
    "ait": "application/vnd.dvb.ait", // Digital Video Broadcasting IANA: Digital Video BroadcastingIANA: Digital Video BroadcastingIANA: DynaGeo
    "mag": "application/vnd.ecowin.chart", // EcoWin Chart IANA: EcoWin Chart
    "nml": "application/vnd.enliven", // Enliven Viewer IANA: Enliven Viewer
    "esf": "application/vnd.epson.esf", // QUASS Stream Player IANA: QUASS Stream Player
    "msf": "application/vnd.epson.msf", // QUASS Stream Player IANA: QUASS Stream Player
    "qam": "application/vnd.epson.quickanime", // QuickAnime Player IANA: QuickAnime PlayerIANA: SimpleAnimeLite PlayerIANA: QUASS Stream Player
    "es3": "application/vnd.eszigno3+xml", // MICROSEC e-Szign¢ IANA: MICROSEC e-Szign¢
    "ez2": "application/vnd.ezpix-album", // EZPix Secure Photo Album IANA: EZPix Secure Photo AlbumIANA: EZPix Secure Photo AlbumIANA: Forms Data Format
    "seed": "application/vnd.fdsn.seed", // Digital Siesmograph Networks - SEED Datafiles IANA: SEED
    "gph": "application/vnd.flographit", // NpGraphIt IANA: FloGraphIt
    "ftc": "application/vnd.fluxtime.clip", // FluxTime Clip IANA: FluxTime Clip
    "fm": "application/vnd.framemaker", // FrameMaker Normal Format IANA: FrameMaker
    "fnc": "application/vnd.frogans.fnc", // Frogans Player IANA: Frogans Player
    "ltf": "application/vnd.frogans.ltf", // Frogans Player IANA: Frogans Player
    "fsc": "application/vnd.fsc.weblaunch", // Friendly Software Corporation IANA: Friendly Software
    "oas": "application/vnd.fujitsu.oasys", // Fujitsu Oasys IANA: Fujitsu Oasys
    "oa2": "application/vnd.fujitsu.oasys2", // Fujitsu Oasys IANA: Fujitsu Oasys
    "oa3": "application/vnd.fujitsu.oasys3", // Fujitsu Oasys IANA: Fujitsu Oasys
    "fg5": "application/vnd.fujitsu.oasysgp", // Fujitsu Oasys IANA: Fujitsu Oasys
    "bh2": "application/vnd.fujitsu.oasysprs", // Fujitsu Oasys IANA: Fujitsu Oasys
    "ddd": "application/vnd.fujixerox.ddd", // Fujitsu - Xerox 2D CAD Data IANA: Fujitsu DDD
    "xdw": "application/vnd.fujixerox.docuworks", // Fujitsu - Xerox DocuWorks IANA: Docuworks
    "xbd": "application/vnd.fujixerox.docuworks.binder", // Fujitsu - Xerox DocuWorks Binder IANA: Docuworks
    "fzs": "application/vnd.fuzzysheet", // FuzzySheet IANA: FuzySheet
    "txd": "application/vnd.genomatix.tuxedo", // Genomatix Tuxedo Framework IANA: Genomatix Tuxedo
    "ggb": "application/vnd.geogebra.file", // GeoGebra IANA: GeoGebra
    "ggt": "application/vnd.geogebra.tool", // GeoGebra IANA: GeoGebra
    "gex": "application/vnd.geometry-explorer", // GeoMetry Explorer IANA: GeoMetry ExplorerIANA: GEONExT and JSXGraph
    "g2w": "application/vnd.geoplan", // GeoplanW IANA: GeoplanW
    "g3w": "application/vnd.geospace", // GeospacW IANA: GeospacW
    "gmx": "application/vnd.gmx", // GameMaker ActiveX IANA: GameMaker ActiveX
    "kml": "application/vnd.google-earth.kml+xml", // Google Earth - KML IANA: Google EarthIANA: Google Earth
    "gqf": "application/vnd.grafeq", // GrafEq IANA: GrafEq
    "gac": "application/vnd.groove-account", // Groove - Account IANA: Groove
    "ghf": "application/vnd.groove-help", // Groove - Help IANA: Groove
    "gim": "application/vnd.groove-identity-message", // Groove - Identity Message IANA: Groove
    "grv": "application/vnd.groove-injector", // Groove - Injector IANA: Groove
    "gtm": "application/vnd.groove-tool-message", // Groove - Tool Message IANA: Groove
    "tpl": "application/vnd.groove-tool-template", // Groove - Tool Template IANA: Groove
    "vcg": "application/vnd.groove-vcard", // Groove - Vcard IANA: Groove
    "hal": "application/vnd.hal+xml", // Hypertext Application Language IANA: HAL
    "zmm": "application/vnd.handheld-entertainment+xml", // ZVUE Media Manager IANA: ZVUE Media
    "hbci": "application/vnd.hbci", // Homebanking Computer Interface (HBCI) IANA: HBCI
    "les": "application/vnd.hhe.lesson-player", // Archipelago Lesson Player IANA: Archipelago Lesson
    "hpgl": "application/vnd.hp-hpgl", // HP-GL/2 and HP RTL IANA: HP-GL/2 and HP RTL
    "hpid": "application/vnd.hp-hpid", // Hewlett Packard Instant Delivery IANA: Hewlett Packard Instant
    "hps": "application/vnd.hp-hps", // Hewlett-Packard's WebPrintSmart IANA: Hewlett-Packard's WebPrintSmartIANA: HP Job Layout Language
    "pcl": "application/vnd.hp-pcl", // HP Printer Command Language IANA: HP Printer Command LanguageIANA: HP PCL XL
    "sfd-hdstx": "application/vnd.hydrostatix.sof-data", // Hydrostatix Master Suite IANA: Hydrostatix
    "x3d": "application/vnd.hzn-3d-crossword", // 3D Crossword Plugin IANA: 3D Crossword PluginIANA: MiniPay
    "afp": "application/vnd.ibm.modcap", // MO: "DCA-P IANA: MO: "DCA-P
    "irm": "application/vnd.ibm.rights-management", // IBM DB2 Rights Manager IANA: IBM DB2 Rights
    "sc": "application/vnd.ibm.secure-container", // IBM Electronic Media Management System - Secure Container IANA: EMMS
    "icc": "application/vnd.iccprofile", // ICC profile IANA: ICC profile
    "igl": "application/vnd.igloader", // igLoader IANA: igLoader
    "ivp": "application/vnd.immervision-ivp", // ImmerVision PURE Players IANA: ImmerVision PURE
    "ivu": "application/vnd.immervision-ivu", // ImmerVision PURE Players IANA: ImmerVision PURE
    "igm": "application/vnd.insors.igm", // IOCOM Visimeet IANA: IOCOM Visimeet
    "xpw": "application/vnd.intercon.formnet", // Intercon FormNet IANA: Intercon FormNetIANA: Interactive Geometry SoftwareIANA: Open Financial ExchangeIANA: Quicken
    "rcprofile": "application/vnd.ipunplugged.rcprofile", // IP Unplugged Roaming Client IANA: IP
    "irp": "application/vnd.irepository.package+xml", // iRepository / Lucidoc Editor IANA: iRepository /
    "xpr": "application/vnd.is-xpr", // Express by Infoseek IANA: Express by Infoseek
    "fcs": "application/vnd.isac.fcs", // International Society for Advancement of Cytometry IANA: International Society for
    "jam": "application/vnd.jam", // Lightspeed Audio Lab IANA: Lightspeed Audio Lab
    "rms": "application/vnd.jcp.javame.midlet-rms", // Mobile Information Device Profile IANA: Mobile
    "jisp": "application/vnd.jisp", // RhymBox IANA: RhymBox
    "joda": "application/vnd.joost.joda-archive", // Joda Archive IANA: Joda ArchiveIANA: Kahootz
    "karbon": "application/vnd.kde.karbon", // KDE KOffice Office Suite - Karbon IANA
    "kia": "application/vnd.kidspiration", // Kidspiration IANA: Kidspiration
    "kne": "application/vnd.kinar", // Kinar Applications IANA: Kina Applications
    "skp": "application/vnd.koan", // SSEYO Koan Play File IANA: SSEYO Koan Play File
    "sse": "application/vnd.kodak-descriptor", // Kodak Storyshare IANA: Kodak StoryshareIANA: Laser app EnterpriseIANA: Life
    "lbe": "application/vnd.llamagraphics.life-balance.exchange+xml", // Life Balance - Exchange Format IANA:
    "123": "application/vnd.lotus-1-2-3", // Lotus 1-2-3 IANA: Lotus 1-2-3
    "apr": "application/vnd.lotus-approach", // Lotus Approach IANA: Lotus Approach
    "pre": "application/vnd.lotus-freelance", // Lotus Freelance IANA: Lotus Freelance
    "nsf": "application/vnd.lotus-notes", // Lotus Notes IANA: Lotus Notes
    "org": "application/vnd.lotus-organizer", // Lotus Organizer IANA: Lotus Organizer
    "scm": "application/vnd.lotus-screencam", // Lotus Screencam IANA: Lotus Screencam
    "lwp": "application/vnd.lotus-wordpro", // Lotus Wordpro IANA: Lotus Wordpro
    "portpkg": "application/vnd.macports.portpkg", // MacPorts Port System IANA: MacPorts Port
    "mcd": "application/vnd.mcd", // Micro CADAM Helix D&D IANA: Micro CADAM Helix D&D
    "mc1": "application/vnd.medcalcdata", // MedCalc IANA: MedCalc
    "cdkey": "application/vnd.mediastation.cdkey", // MediaRemote IANA: MediaRemoteIANA: Medical Waveform Encoding FormatIANA: Melody Format for Mobile PlatformIANA: Micrografx
    "igx": "application/vnd.micrografx.igx", // Micrografx iGrafx Professional IANA: Micrografx
    "mif": "application/vnd.mif", // FrameMaker Interchange Format IANA: FrameMaker Interchange FormatIANA: Mobius Management Systems
    "mpc": "application/vnd.mophun.certificate", // Mophun Certificate IANA: Mophun CertificateIANA: XUL
    "cil": "application/vnd.ms-artgalry", // Microsoft Artgalry IANA: MS Artgalry
    "cab": "application/vnd.ms-cab-compressed", // Microsoft Cabinet File IANA: MS Cabinet FileIANA: MS Excel
    "xlam": "application/vnd.ms-excel.addin.macroenabled.12", // Microsoft Excel - Add-In File IANA: MS
    "xlsb": "application/vnd.ms-excel.sheet.binary.macroenabled.12", // Microsoft Excel - Binary Workbook IANA:
    "xlsm": "application/vnd.ms-excel.sheet.macroenabled.12", // Microsoft Excel - Macro-Enabled Workbook IANA: MS
    "xltm": "application/vnd.ms-excel.template.macroenabled.12", // Microsoft Excel - Macro-Enabled Template File IANA: MS
    "eot": "application/vnd.ms-fontobject", // Microsoft Embedded OpenType IANA: MS Embedded OpenTypeIANA: "MS Html Help File
    "ims": "application/vnd.ms-ims", // Microsoft Class Server IANA: MS Class Server
    "lrm": "application/vnd.ms-lrm", // Microsoft Learning Resource Module IANA: MS Learning Resource ModuleIANA: MS Office System
    "cat": "application/vnd.ms-pki.seccat", // Microsoft Trust UI Provider - Security Catalog IANA: MS Trust UI ProviderIANA: MS Trust UI Provider
    "ppt": "application/vnd.ms-powerpoint", // Microsoft PowerPoint IANA: MS PowerPoint
    "ppam": "application/vnd.ms-powerpoint.addin.macroenabled.12", // Microsoft PowerPoint - Add-in file IANA: MS
    "pptm": "application/vnd.ms-powerpoint.presentation.macroenabled.12", // Microsoft PowerPoint - Macro-Enabled Presentation File
    "sldm": "application/vnd.ms-powerpoint.slide.macroenabled.12", // Microsoft PowerPoint - Macro-Enabled Open XML Slide IANA: MS
    "ppsm": "application/vnd.ms-powerpoint.slideshow.macroenabled.12", // Microsoft PowerPoint - Macro-Enabled Slide Show File
    "potm": "application/vnd.ms-powerpoint.template.macroenabled.12", // Micosoft PowerPoint - Macro-Enabled Template File IANA:
    "mpp": "application/vnd.ms-project", // Microsoft Project IANA: MS PowerPoint
    "docm": "application/vnd.ms-word.document.macroenabled.12", // Micosoft Word - Macro-Enabled Document IANA: MS
    "dotm": "application/vnd.ms-word.template.macroenabled.12", // Micosoft Word - Macro-Enabled Template IANA: MS
    "wps": "application/vnd.ms-works", // Microsoft Works IANA: MS Works
    "wpl": "application/vnd.ms-wpl", // Microsoft Windows Media Player Playlist IANA: MS Windows Media Player PlaylistIANA: MS XML Paper
    "mseq": "application/vnd.mseq", // 3GPP MSEQ File IANA: 3GPP MSEQ File
    "mus": "application/vnd.musician", // MUsical Score Interpreted Code Invented  for the ASCII designation of Notation IANA: MUSICIAN
    "msty": "application/vnd.muvee.style", // Muvee Automatic Video Editing IANA: Muvee
    "nlu": "application/vnd.neurolanguage.nlu", // neuroLanguage IANA: neuroLanguage
    "nnd": "application/vnd.noblenet-directory", // NobleNet Directory IANA: NobleNet DirectoryIANA: NobleNet Sealer
    "nnw": "application/vnd.noblenet-web", // NobleNet Web IANA: NobleNet Web
    "ngdat": "application/vnd.nokia.n-gage.data", // N-Gage Game Data IANA: N-Gage Game DataIANA: N-Gage
    "rpst": "application/vnd.nokia.radio-preset", // Nokia Radio Application - Preset IANA: Nokia Radio
    "rpss": "application/vnd.nokia.radio-presets", // Nokia Radio Application - Preset IANA: Nokia Radio
    "edm": "application/vnd.novadigm.edm", // Novadigm's RADIA and EDM products IANA: Novadigm's RADIA and EDM
    "edx": "application/vnd.novadigm.edx", // Novadigm's RADIA and EDM products IANA: Novadigm's RADIA and EDM
    "ext": "application/vnd.novadigm.ext", // Novadigm's RADIA and EDM products IANA: Novadigm's RADIA and EDM
    "odc": "application/vnd.oasis.opendocument.chart", // OpenDocument Chart IANA: OpenDocument
    "otc": "application/vnd.oasis.opendocument.chart-template", // OpenDocument Chart Template IANA:
    "odb": "application/vnd.oasis.opendocument.database", // OpenDocument Database IANA:
    "odf": "application/vnd.oasis.opendocument.formula", // OpenDocument Formula IANA: OpenDocument
    "odft": "application/vnd.oasis.opendocument.formula-template", // OpenDocument Formula Template IANA:
    "odg": "application/vnd.oasis.opendocument.graphics", // OpenDocument Graphics IANA:
    "otg": "application/vnd.oasis.opendocument.graphics-template", // OpenDocument Graphics Template IANA:
    "odi": "application/vnd.oasis.opendocument.image", // OpenDocument Image IANA: OpenDocument
    "oti": "application/vnd.oasis.opendocument.image-template", // OpenDocument Image Template IANA:
    "odp": "application/vnd.oasis.opendocument.presentation", // OpenDocument Presentation IANA:
    "otp": "application/vnd.oasis.opendocument.presentation-template", // OpenDocument Presentation Template
    "ods": "application/vnd.oasis.opendocument.spreadsheet", // OpenDocument Spreadsheet IANA:
    "ots": "application/vnd.oasis.opendocument.spreadsheet-template", // OpenDocument Spreadsheet Template IANA:
    "odt": "application/vnd.oasis.opendocument.text", // OpenDocument Text IANA: OpenDocument
    "odm": "application/vnd.oasis.opendocument.text-master", // OpenDocument Text Master IANA:
    "ott": "application/vnd.oasis.opendocument.text-template", // OpenDocument Text Template IANA:
    "oth": "application/vnd.oasis.opendocument.text-web", // Open Document Text Web IANA:
    "xo": "application/vnd.olpc-sugar", // Sugar Linux Application Bundle IANA: Sugar Linux app BundleIANA: OMA Download Agents
    "oxt": "application/vnd.openofficeorg.extension", // Open Office Extension IANA: Open Office
    "pptx": "application/vnd.openxmlformats-officedocument.presentationml.presentation", // Microsoft Office - OOXML - Presentation
    "xlsx": "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", // Microsoft Office - OOXML - Spreadsheet IANA: MapGuide DBXMLIANA: OSGi Deployment Package
    "pdb": "application/vnd.palm", // PalmOS Data IANA: PalmOS Data
    "paw": "application/vnd.pawaafile", // PawaaFILE IANA: PawaaFILE
    "str": "application/vnd.pg.format", // Proprietary P&G Standard Reporting System IANA: Proprietary P&G Standard
    "ei6": "application/vnd.pg.osasli", // Proprietary P&G Standard Reporting System IANA: Proprietary P&G Standard
    "efif": "application/vnd.picsel", // Pcsel eFIF File IANA: Picsel eFIF File
    "wg": "application/vnd.pmi.widget", // Qualcomm's Plaza Mobile Internet IANA: Qualcomm's Plaza Mobile
    "plf": "application/vnd.pocketlearn", // PocketLearn Viewers IANA: PocketLearn Viewers
    "pbd": "application/vnd.powerbuilder6", // PowerBuilder IANA: PowerBuilder
    "box": "application/vnd.previewsystems.box", // Preview Systems ZipLock/VBox IANA: Preview Systems
    "mgz": "application/vnd.proteus.magazine", // EFI Proteus IANA: EFI Proteus
    "qps": "application/vnd.publishare-delta-tree", // PubliShare Objects IANA: PubliShare
    "ptid": "application/vnd.pvi.ptid1", // Princeton Video Image IANA: Princeton Video ImageIANA: QuarkXPress
    "bed": "application/vnd.realvnc.bed", // RealVNC IANA: RealVNC
    "mxl": "application/vnd.recordare.musicxml", // Recordare Applications IANA: Recordare AppsIANA: Recordare
    "cryptonote": "application/vnd.rig.cryptonote", // CryptoNote IANA: CryptoNote
    "rm": "application/vnd.rn-realmedia", // RealMedia
    "link66": "application/vnd.route66.link66+xml", // ROUTE 66 Location Based Services IANA: ROUTE 66
    "st": "application/vnd.sailingtracker.track", // SailingTracker IANA: SailingTrackerIANA: SeeMail
    "sema": "application/vnd.sema", // Secured eMail IANA: Secured eMail
    "semd": "application/vnd.semd", // Secured eMail IANA: Secured eMail
    "semf": "application/vnd.semf", // Secured eMail IANA: Secured eMail
    "ifm": "application/vnd.shana.informed.formdata", // Shana Informed Filler IANA: Shana Informed
    "itp": "application/vnd.shana.informed.formtemplate", // Shana Informed Filler IANA: Shana
    "iif": "application/vnd.shana.informed.interchange", // Shana Informed Filler IANA: Shana
    "ipk": "application/vnd.shana.informed.package", // Shana Informed Filler IANA: Shana Informed
    "twd": "application/vnd.simtech-mindmapper", // SimTech MindMapper IANA: SimTech MindMapperIANA: SMAF File
    "teacher": "application/vnd.smart.teacher", // SMART Technologies Apps IANA: SMART Technologies
    "sdkm": "application/vnd.solent.sdkm+xml", // SudokuMagic IANA: SudokuMagic
    "dxp": "application/vnd.spotfire.dxp", // TIBCO Spotfire IANA: TIBCO Spotfire
    "sfs": "application/vnd.spotfire.sfs", // TIBCO Spotfire IANA: TIBCO Spotfire
    "sdc": "application/vnd.stardivision.calc", // StarOffice - Calc
    "sda": "application/vnd.stardivision.draw", // StarOffice - Draw
    "sdd": "application/vnd.stardivision.impress", // StarOffice - Impress
    "smf": "application/vnd.stardivision.math", // StarOffice - Math
    "sdw": "application/vnd.stardivision.writer", // StarOffice - Writer
    "sgl": "application/vnd.stardivision.writer-global", // StarOffice - Writer  (Global)
    "sm": "application/vnd.stepmania.stepchart", // StepMania IANA: StepMania
    "sxc": "application/vnd.sun.xml.calc", // OpenOffice - Calc (Spreadsheet) Wikipedia: OpenOffice
    "stc": "application/vnd.sun.xml.calc.template", // OpenOffice - Calc Template (Spreadsheet) Wikipedia: OpenOffice
    "sxd": "application/vnd.sun.xml.draw", // OpenOffice - Draw (Graphics) Wikipedia: OpenOffice
    "std": "application/vnd.sun.xml.draw.template", // OpenOffice - Draw Template (Graphics) Wikipedia: OpenOffice
    "sxi": "application/vnd.sun.xml.impress", // OpenOffice - Impress (Presentation) Wikipedia: OpenOffice
    "sti": "application/vnd.sun.xml.impress.template", // OpenOffice - Impress Template (Presentation) Wikipedia: OpenOffice
    "sxm": "application/vnd.sun.xml.math", // OpenOffice - Math (Formula) Wikipedia: OpenOffice
    "sxw": "application/vnd.sun.xml.writer", // OpenOffice - Writer (Text - HTML) Wikipedia: OpenOffice
    "sxg": "application/vnd.sun.xml.writer.global", // OpenOffice - Writer (Text - HTML) Wikipedia: OpenOffice
    "stw": "application/vnd.sun.xml.writer.template", // OpenOffice - Writer Template (Text - HTML) Wikipedia: OpenOffice
    "sus": "application/vnd.sus-calendar", // ScheduleUs IANA: ScheduleUs
    "svd": "application/vnd.svd", // SourceView Document IANA: SourceView Document
    "sis": "application/vnd.symbian.install", // Symbian Install Package IANA: Symbian
    "xsm": "application/vnd.syncml+xml", // SyncML IANA: SyncML
    "bdm": "application/vnd.syncml.dm+wbxml", // SyncML - Device Management IANA: SyncML
    "xdm": "application/vnd.syncml.dm+xml", // SyncML - Device Management IANA: SyncML
    "tao": "application/vnd.tao.intent-module-archive", // Tao Intent IANA: Tao IntentIANA: MobileTV
    "tpt": "application/vnd.trid.tpt", // TRI Systems Config IANA: TRI Systems
    "mxs": "application/vnd.triscape.mxs", // Triscape Map Explorer IANA: Triscape Map ExplorerIANA: True BASIC
    "ufd": "application/vnd.ufdl", // Universal Forms Description Language IANA: Universal Forms Description
    "utz": "application/vnd.uiq.theme", // User Interface Quartz - Theme (Symbian) IANA: User Interface Quartz
    "umj": "application/vnd.umajin", // UMAJIN IANA: UMAJIN
    "unityweb": "application/vnd.unity", // Unity 3d IANA: Unity 3d
    "uoml": "application/vnd.uoml+xml", // Unique Object Markup Language IANA: UOML
    "vcx": "application/vnd.vcx", // VirtualCatalog IANA: VirtualCatalog
    "vsd": "application/vnd.visio", // Microsoft Visio IANA: Visio
    "vis": "application/vnd.visionary", // Visionary IANA: Visionary
    "vsf": "application/vnd.vsf", // Viewport+ IANA: Viewport+
    "wbxml": "application/vnd.wap.wbxml", // WAP Binary XML (WBXML) IANA: WBXML
    "wmlc": "application/vnd.wap.wmlc", // Compiled Wireless Markup Language (WMLC) IANA: WMLC
    "wmlsc": "application/vnd.wap.wmlscriptc", // WMLScript IANA: WMLScript
    "wtb": "application/vnd.webturbo", // WebTurbo IANA: WebTurbo
    "nbp": "application/vnd.wolfram.player", // Mathematica Notebook Player IANA: Mathematica Notebook
    "wpd": "application/vnd.wordperfect", // Wordperfect IANA: Wordperfect
    "wqd": "application/vnd.wqd", // SundaHus WQ IANA: SundaHus WQ
    "stf": "application/vnd.wt.stf", // Worldtalk IANA: Worldtalk
    "xar": "application/vnd.xara", // CorelXARA IANA: CorelXARA
    "xfdl": "application/vnd.xfdl", // Extensible Forms Description Language IANA: Extensible Forms Description
    "hvd": "application/vnd.yamaha.hv-dic", // HV Voice Dictionary IANA: HV Voice DictionaryIANA: HV Script
    "hvp": "application/vnd.yamaha.hv-voice", // HV Voice Parameter IANA: HV Voice ParameterIANA: Open Score
    "osfpvg": "application/vnd.yamaha.openscoreformat.osfpvg+xml", // OSFPVG IANA:
    "saf": "application/vnd.yamaha.smaf-audio", // SMAF Audio IANA: SMAF Audio
    "spf": "application/vnd.yamaha.smaf-phrase", // SMAF Phrase IANA: SMAF Phrase
    "cmp": "application/vnd.yellowriver-custom-menu", // CustomMenu IANA: CustomMenuIANA: Z.U.L.
    "zaz": "application/vnd.zzazz.deck+xml", // Zzazz Deck IANA: Zzazz
    "vxml": "application/voicexml+xml", // VoiceXML RFC 4267
    "wgt": "application/widget", // Widget Packaging and XML Configuration W3C Widget Packaging and XML
    "hlp": "application/winhlp", // WinHelp Wikipedia: WinHelp
    "wsdl": "application/wsdl+xml", // WSDL - Web Services Description Language W3C Web Service Description LanguageW3C Web Services Policy
    "7z": "application/x-7z-compressed", // 7-Zip Wikipedia: 7-Zip
    "abw": "application/x-abiword", // AbiWord Wikipedia: AbiWord
    "ace": "application/x-ace-compressed", // Ace Archive Wikipedia: ACE
    "aab": "application/x-authorware-bin", // Adobe (Macropedia) Authorware - Binary File Wikipedia: Authorware
    "aam": "application/x-authorware-map", // Adobe (Macropedia) Authorware - Map Wikipedia: Authorware
    "aas": "application/x-authorware-seg", // Adobe (Macropedia) Authorware - Segment File Wikipedia: Authorware
    "bcpio": "application/x-bcpio", // Binary CPIO Archive Wikipedia: cpio
    "torrent": "application/x-bittorrent", // BitTorrent Wikipedia: BitTorrent
    "bz": "application/x-bzip", // Bzip Archive Wikipedia: Bzip
    "bz2": "application/x-bzip2", // Bzip2 Archive Wikipedia: Bzip
    "vcd": "application/x-cdlink", // Video CD Wikipedia: Video CD
    "chat": "application/x-chat", // pIRCh Wikipedia: pIRCh
    "pgn": "application/x-chess-pgn", // Portable Game Notation (Chess Games) Wikipedia: Portable Game Notationb
    "cpio": "application/x-cpio", // CPIO Archive Wikipedia: cpio
    "csh": "application/x-csh", // C Shell Script Wikipedia: C Shell
    "deb": "application/x-debian-package", // Debian Package Wikipedia: Debian Package
    "dir": "application/x-director", // Adobe Shockwave Player Wikipedia: Adobe Shockwave Player
    "wad": "application/x-doom", // Doom Video Game Wikipedia: Doom WAD
    "ncx": "application/x-dtbncx+xml", // Navigation Control file for XML (for ePub) Wikipedia: EPUB
    "dtb": "application/x-dtbook+xml", // Digital Talking Book Wikipedia: EPUB
    "res": "application/x-dtbresource+xml", // Digital Talking Book - Resource File Digital Talking Book
    "dvi": "application/x-dvi", // Device Independent File Format (DVI) Wikipedia: DVI
    "bdf": "application/x-font-bdf", // Glyph Bitmap Distribution Format Wikipedia: Glyph Bitmap Distribution FormatWikipedia: Ghostscript
    "psf": "application/x-font-linux-psf", // PSF Fonts PSF Fonts
    "otf": "application/x-font-otf", // OpenType Font File OpenType Font File
    "pcf": "application/x-font-pcf", // Portable Compiled Format Wikipedia: Portable Compiled Format
    "snf": "application/x-font-snf", // Server Normal Format Wikipedia: Server Normal Format
    "ttf": "application/x-font-ttf", // TrueType Font Wikipedia: TrueType
    "pfa": "application/x-font-type1", // PostScript Fonts Wikipedia: PostScript Fonts
    "woff": "application/x-font-woff", // Web Open Font Format Wikipedia: Web Open Font Format
    "spl": "application/x-futuresplash", // FutureSplash Animator Wikipedia: FutureSplash Animator
    "gnumeric": "application/x-gnumeric", // Gnumeric Wikipedia: Gnumeric
    "gtar": "application/x-gtar", // GNU Tar Files GNU Tar
    "hdf": "application/x-hdf", // Hierarchical Data Format Wikipedia: Hierarchical Data Format
    "jnlp": "application/x-java-jnlp-file", // Java Network Launching Protocol Wikipedia: Java Web Start
    "latex": "application/x-latex", // LaTeX Wikipedia: LaTeX
    "prc": "application/x-mobipocket-ebook", // Mobipocket Wikipedia: Mobipocket
    "application": "application/x-ms-application", // Microsoft ClickOnce Wikipedia: ClickOnce
    "wmd": "application/x-ms-wmd", // Microsoft Windows Media Player Download Package Wikipedia: Windows Media Player
    "wmz": "application/x-ms-wmz", // Microsoft Windows Media Player Skin Package Wikipedia: Windows Media Player
    "xbap": "application/x-ms-xbap", // Microsoft XAML Browser Application Wikipedia: XAML Browser
    "mdb": "application/x-msaccess", // Microsoft Access Wikipedia: Microsoft Access
    "obd": "application/x-msbinder", // Microsoft Office Binder Wikipedia: Microsoft Shared Tools
    "crd": "application/x-mscardfile", // Microsoft Information Card Wikipedia: Information Card
    "clp": "application/x-msclip", // Microsoft Clipboard Clip Wikipedia: Clipboard
    "exe": "application/x-msdownload", // Microsoft Application Wikipedia: EXE
    "mvb": "application/x-msmediaview", // Microsoft MediaView
    "wmf": "application/x-msmetafile", // Microsoft Windows Metafile Wikipedia: Windows Metafile
    "mny": "application/x-msmoney", // Microsoft Money Wikipedia: Microsoft Money
    "pub": "application/x-mspublisher", // Microsoft Publisher Wikipedia: Microsoft Publisher
    "scd": "application/x-msschedule", // Microsoft Schedule+ Wikipedia: Microsoft Schedule Plus
    "trm": "application/x-msterminal", // Microsoft Windows Terminal Services Wikipedia: Terminal Server
    "wri": "application/x-mswrite", // Microsoft Wordpad Wikipedia: Wordpad
    "nc": "application/x-netcdf", // Network Common Data Form (NetCDF) Wikipedia: NetCDF
    "p12": "application/x-pkcs12", // PKCS #12 - Personal Information Exchange Syntax Standard RFC 2986
    "p7b": "application/x-pkcs7-certificates", // PKCS #7 - Cryptographic Message Syntax Standard (Certificates) RFC 2986
    "p7r": "application/x-pkcs7-certreqresp", // PKCS #7 - Cryptographic Message Syntax Standard (Certificate Request Response) RFC 2986
    "rar": "application/x-rar-compressed", // RAR Archive Wikipedia: RAR
    "sh": "application/x-sh", // Bourne Shell Script Wikipedia: Bourne Shell
    "shar": "application/x-shar", // Shell Archive Wikipedia: Shell Archie
    "swf": "application/x-shockwave-flash", // Adobe Flash Wikipedia: Adobe Flash
    "xap": "application/x-silverlight-app", // Microsoft Silverlight Wikipedia: Silverlight
    "sit": "application/x-stuffit", // Stuffit Archive Wikipedia: Stuffit
    "sitx": "application/x-stuffitx", // Stuffit Archive Wikipedia: Stuffit
    "sv4cpio": "application/x-sv4cpio", // System V Release 4 CPIO Archive Wikipedia: pax
    "sv4crc": "application/x-sv4crc", // System V Release 4 CPIO Checksum Data Wikipedia: pax
    "tar": "application/x-tar", // Tar File (Tape Archive) Wikipedia: Tar
    "tcl": "application/x-tcl", // Tcl Script Wikipedia: Tcl
    "tex": "application/x-tex", // TeX Wikipedia: TeX
    "tfm": "application/x-tex-tfm", // TeX Font Metric Wikipedia: TeX Font Metric
    "texinfo": "application/x-texinfo", // GNU Texinfo Document Wikipedia: Texinfo
    "ustar": "application/x-ustar", // Ustar (Uniform Standard Tape Archive) Wikipedia: Ustar
    "src": "application/x-wais-source", // WAIS Source YoLinux
    "der": "application/x-x509-ca-cert", // X.509 Certificate Wikipedia: X.509
    "fig": "application/x-xfig", // Xfig Wikipedia: Xfig
    "xpi": "application/x-xpinstall", // XPInstall - Mozilla Wikipedia: XPI
    "xdf": "application/xcap-diff+xml", // XML Configuration Access Protocol - XCAP Diff Wikipedia: XCAP
    "xenc": "application/xenc+xml", // XML Encryption Syntax and Processing W3C XML Encryption Syntax and Processing
    "xhtml": "application/xhtml+xml", // XHTML - The Extensible HyperText Markup Language W3C XHTML
    "xml": "application/xml", // XML - Extensible Markup Language W3C XML
    "dtd": "application/xml-dtd", // Document Type Definition W3C DTD
    "xop": "application/xop+xml", // XML-Binary Optimized Packaging W3C XOP
    "xslt": "application/xslt+xml", // XML Transformations W3C XSLT
    "xspf": "application/xspf+xml", // XSPF - XML Shareable Playlist Format XML Shareable Playlist Format
    "mxml": "application/xv+xml", // MXML Wikipedia: MXML
    "yang": "application/yang", // YANG Data Modeling Language Wikipedia: YANG
    "yin": "application/yin+xml", // YIN (YANG - XML) Wikipedia: YANG
    "zip": "application/zip", // Zip Archive Wikipedia: Zip
    "adp": "audio/adpcm", // Adaptive differential pulse-code modulation Wikipedia: ADPCM
    "au": "audio/basic", // Sun Audio - Au file format Wikipedia: Sun audio
    "mid": "audio/midi", // MIDI - Musical Instrument Digital Interface Wikipedia: MIDI
    "mp4a": "audio/mp4", // MPEG-4 Audio Wikipedia: MP4A
    "mpga": "audio/mpeg", // MPEG Audio Wikipedia: MPGA
    "oga": "audio/ogg", // Ogg Audio Wikipedia: Ogg
    "uva": "audio/vnd.dece.audio", // DECE Audio IANA: Dece Audio
    "eol": "audio/vnd.digital-winds", // Digital Winds Music IANA: Digital Winds
    "dra": "audio/vnd.dra", // DRA Audio IANA: DRA
    "dts": "audio/vnd.dts", // DTS Audio IANA: DTS
    "dtshd": "audio/vnd.dts.hd", // DTS High Definition Audio IANA: DTS HD
    "lvp": "audio/vnd.lucent.voice", // Lucent Voice IANA: Lucent Voice
    "pya": "audio/vnd.ms-playready.media.pya", // Microsoft PlayReady Ecosystem IANA: Microsoft PlayReady
    "ecelp4800": "audio/vnd.nuera.ecelp4800", // Nuera ECELP 4800 IANA: ECELP 4800
    "ecelp7470": "audio/vnd.nuera.ecelp7470", // Nuera ECELP 7470 IANA: ECELP 7470
    "ecelp9600": "audio/vnd.nuera.ecelp9600", // Nuera ECELP 9600 IANA: ECELP 9600
    "rip": "audio/vnd.rip", // Hit'n'Mix IANA: Hit'n'Mix
    "weba": "audio/webm", // Open Web Media Project - Audio WebM Project
    "aac": "audio/x-aac", // Advanced Audio Coding (AAC) Wikipedia: AAC
    "aif": "audio/x-aiff", // Audio Interchange File Format Wikipedia: Audio Interchange File FormatWikipedia: M3U
    "wax": "audio/x-ms-wax", // Microsoft Windows Media Audio Redirector Windows Media MetafilesWikipedia: Windows Media Audio
    "ram": "audio/x-pn-realaudio", // Real Audio Sound Wikipedia: RealPlayer
    "rmp": "audio/x-pn-realaudio-plugin", // Real Audio Sound Wikipedia: RealPlayer
    "wav": "audio/x-wav", // Waveform Audio File Format (WAV) Wikipedia: WAV
    "cdx": "chemical/x-cdx", // ChemDraw eXchange file ChemDraw eXchange file
    "cif": "chemical/x-cif", // Crystallographic Interchange Format Crystallographic Interchange Format
    "cmdf": "chemical/x-cmdf", // CrystalMaker Data Format CrystalMaker Data Format
    "cml": "chemical/x-cml", // Chemical Markup Language Wikipedia: Chemical Markup Language
    "csml": "chemical/x-csml", // Chemical Style Markup Language Wikipedia: Chemical Style Markup Language
    "xyz": "chemical/x-xyz", // XYZ File Format Wikipedia: XYZ File Format
    "bmp": "image/bmp", // Bitmap Image File Wikipedia: BMP File Format
    "cgm": "image/cgm", // Computer Graphics Metafile Wikipedia: Computer Graphics Metafile
    "g3": "image/g3fax", // G3 Fax Image Wikipedia: G3 Fax Image
    "gif": "image/gif", // Graphics Interchange Format Wikipedia: Graphics Interchange Format
    "ief": "image/ief", // Image Exchange Format RFC 1314
    "jpeg": "image/jpeg", // JPEG Image RFC 1314
    "jpg": "image/jpeg", // JPEG Image RFC 1314
    "ktx": "image/ktx", // OpenGL Textures (KTX) KTX File Format
    "png": "image/png", // Portable Network Graphics (PNG) RFC 2083
    "btif": "image/prs.btif", // BTIF IANA: BTIF
    "svg": "image/svg+xml", // Scalable Vector Graphics (SVG) Wikipedia: SVG
    "tiff": "image/tiff", // Tagged Image File Format Wikipedia: TIFF
    "psd": "image/vnd.adobe.photoshop", // Photoshop Document Wikipedia: Photoshop Document
    "uvi": "image/vnd.dece.graphic", // DECE Graphic IANA: DECE Graphic
    "sub": "image/vnd.dvb.subtitle", // Close Captioning - Subtitle Wikipedia: Closed Captioning
    "djvu": "image/vnd.djvu", // DjVu Wikipedia: DjVu
    "dwg": "image/vnd.dwg", // DWG Drawing Wikipedia: DWG
    "dxf": "image/vnd.dxf", // AutoCAD DXF Wikipedia: AutoCAD DXF
    "fbs": "image/vnd.fastbidsheet", // FastBid Sheet IANA: FastBid Sheet
    "fpx": "image/vnd.fpx", // FlashPix IANA: FPX
    "fst": "image/vnd.fst", // FAST Search & Transfer ASA IANA: FAST Search & Transfer ASA
    "mmr": "image/vnd.fujixerox.edmics-mmr", // EDMICS 2000 IANA: EDMICS 2000
    "rlc": "image/vnd.fujixerox.edmics-rlc", // EDMICS 2000 IANA: EDMICS 2000
    "mdi": "image/vnd.ms-modi", // Microsoft Document Imaging Format Wikipedia: Microsoft Document Image FormatIANA: FPX
    "wbmp": "image/vnd.wap.wbmp", // WAP Bitamp (WBMP) IANA: WBMP
    "xif": "image/vnd.xiff", // eXtended Image File Format (XIFF) IANA: XIFF
    "webp": "image/webp", // WebP Image Wikipedia: WebP
    "ras": "image/x-cmu-raster", // CMU Image
    "cmx": "image/x-cmx", // Corel Metafile Exchange (CMX) Wikipedia: CorelDRAW
    "fh": "image/x-freehand", // FreeHand MX Wikipedia: Macromedia Freehand
    "ico": "image/x-icon", // Icon Image Wikipedia: ICO File Format
    "pcx": "image/x-pcx", // PCX Image Wikipedia: PCX
    "pic": "image/x-pict", // PICT Image Wikipedia: PICT
    "pnm": "image/x-portable-anymap", // Portable Anymap Image Wikipedia: Netpbm Format
    "pbm": "image/x-portable-bitmap", // Portable Bitmap Format Wikipedia: Netpbm Format
    "pgm": "image/x-portable-graymap", // Portable Graymap Format Wikipedia: Netpbm Format
    "ppm": "image/x-portable-pixmap", // Portable Pixmap Format Wikipedia: Netpbm Format
    "rgb": "image/x-rgb", // Silicon Graphics RGB Bitmap RGB Image Format
    "xbm": "image/x-xbitmap", // X BitMap Wikipedia: X BitMap
    "xpm": "image/x-xpixmap", // X PixMap Wikipedia: X PixMap
    "xwd": "image/x-xwindowdump", // X Window Dump Wikipedia: X Window Dump
    "eml": "message/rfc822", // Email Message RFC 2822
    "igs": "model/iges", // Initial Graphics Exchange Specification (IGES) Wikipedia: IGES
    "msh": "model/mesh", // Mesh Data Type RFC 2077
    "dae": "model/vnd.collada+xml", // COLLADA IANA: COLLADA
    "dwf": "model/vnd.dwf", // Autodesk Design Web Format (DWF) Wikipedia: Design Web Format
    "gdl": "model/vnd.gdl", // Geometric Description Language (GDL) IANA: GDL
    "gtw": "model/vnd.gtw", // Gen-Trix Studio IANA: GTW
    "mts": "model/vnd.mts", // Virtue MTS IANA: MTS
    "vtu": "model/vnd.vtu", // Virtue VTU IANA: VTU
    "wrl": "model/vrml", // Virtual Reality Modeling Language Wikipedia: VRML
    "ics": "text/calendar", // iCalendar Wikipedia: iCalendar
    "css": "text/css", // Cascading Style Sheets (CSS) Wikipedia: CSS
    "csv": "text/csv", // Comma-Seperated Values Wikipedia: CSV
    "html": "text/html", // HyperText Markup Language (HTML) Wikipedia: HTML
    "n3": "text/n3", // Notation3 Wikipedia: Notation3
    "txt": "text/plain", // Text File Wikipedia: Text File
    "dsc": "text/prs.lines.tag", // PRS Lines Tag IANA: PRS Lines Tag
    "rtx": "text/richtext", // Rich Text Format (RTF) Wikipedia: Rich Text Format
    "sgml": "text/sgml", // Standard Generalized Markup Language (SGML) Wikipedia: SGML
    "tsv": "text/tab-separated-values", // Tab Seperated Values Wikipedia: TSV
    "t": "text/troff", // troff Wikipedia: troff
    "ttl": "text/turtle", // Turtle (Terse RDF Triple Language) Wikipedia: Turtle
    "uri": "text/uri-list", // URI Resolution Services RFC 2483
    "curl": "text/vnd.curl", // Curl - Applet Curl AppletCurl Detached
    "scurl": "text/vnd.curl.scurl", // Curl - Source Code Curl Source
    "mcurl": "text/vnd.curl.mcurl", // Curl - Manifest File Curl Manifest
    "fly": "text/vnd.fly", // mod_fly / fly.cgi IANA: Fly
    "flx": "text/vnd.fmi.flexstor", // FLEXSTOR IANA: FLEXSTOR
    "gv": "text/vnd.graphviz", // Graphviz IANA: Graphviz
    "3dml": "text/vnd.in3d.3dml", // In3D - 3DML IANA: In3D
    "spot": "text/vnd.in3d.spot", // In3D - 3DML IANA: In3D
    "jad": "text/vnd.sun.j2me.app-descriptor", // J2ME app Descriptor IANA: J2ME app DescriptorWikipedia: WML
    "wmls": "text/vnd.wap.wmlscript", // Wireless Markup Language Script (WMLScript) Wikipedia: WMLScript
    "s": "text/x-asm", // Assembler Source File Wikipedia: Assembly
    "c": "text/x-c", // C Source File Wikipedia: C Programming Language
    "f": "text/x-fortran", // Fortran Source File Wikipedia: Fortran
    "p": "text/x-pascal", // Pascal Source File Wikipedia: Pascal
    "java": "text/x-java-source,java", // Java Source File Wikipedia: Java
    "etx": "text/x-setext", // Setext Wikipedia: Setext
    "uu": "text/x-uuencode", // UUEncode Wikipedia: UUEncode
    "vcs": "text/x-vcalendar", // vCalendar Wikipedia: vCalendar
    "vcf": "text/x-vcard", // vCard Wikipedia: vCard
    "3gp": "video/3gpp", // 3GP Wikipedia: 3GP
    "3g2": "video/3gpp2", // 3GP2 Wikipedia: 3G2
    "h261": "video/h261", // H.261 Wikipedia: H.261
    "h263": "video/h263", // H.263 Wikipedia: H.263
    "h264": "video/h264", // H.264 Wikipedia: H.264
    "jpgv": "video/jpeg", // JPGVideo RFC 3555
    "jpm": "video/jpm", // JPEG 2000 Compound Image File Format IANA: JPM
    "mj2": "video/mj2", // Motion JPEG 2000 IANA: MJ2
    "mp4": "video/mp4", // MPEG-4 Video Wikipedia: MP4
    "mpeg": "video/mpeg", // MPEG Video Wikipedia: MPEG
    "ogv": "video/ogg", // Ogg Video Wikipedia: Ogg
    "qt": "video/quicktime", // Quicktime Video Wikipedia: Quicktime
    "uvh": "video/vnd.dece.hd", // DECE High Definition Video IANA: DECE HD Video
    "uvm": "video/vnd.dece.mobile", // DECE Mobile Video IANA: DECE Mobile Video
    "uvp": "video/vnd.dece.pd", // DECE PD Video IANA: DECE PD Video
    "uvs": "video/vnd.dece.sd", // DECE SD Video IANA: DECE SD Video
    "uvv": "video/vnd.dece.video", // DECE Video IANA: DECE Video
    "fvt": "video/vnd.fvt", // FAST Search & Transfer ASA IANA: FVT
    "mxu": "video/vnd.mpegurl", // MPEG Url IANA: MPEG Url
    "pyv": "video/vnd.ms-playready.media.pyv", // Microsoft PlayReady Ecosystem Video IANA: Microsoft PlayReady
    "uvu": "video/vnd.uvvu.mp4", // DECE MP4 IANA: DECE MP4
    "viv": "video/vnd.vivo", // Vivo IANA: Vivo
    "webm": "video/webm", // Open Web Media Project - Video WebM Project
    "f4v": "video/x-f4v", // Flash Video Wikipedia: Flash Video
    "fli": "video/x-fli", // FLI/FLC Animation Format FLI/FLC Animation Format
    "flv": "video/x-flv", // Flash Video Wikipedia: Flash Video
    "m4v": "video/x-m4v", // M4v Wikipedia: M4v
    "asf": "video/x-ms-asf", // Microsoft Advanced Systems Format (ASF) Wikipedia: Advanced Systems Format (ASF)
    "wm": "video/x-ms-wm", // Microsoft Windows Media Wikipedia: Advanced Systems Format (ASF)
    "wmv": "video/x-ms-wmv", // Microsoft Windows Media Video Wikipedia: Advanced Systems Format (ASF)
    "wmx": "video/x-ms-wmx", // Microsoft Windows Media Audio/Video Playlist Wikipedia: Advanced Systems Format (ASF)
    "wvx": "video/x-ms-wvx", // Microsoft Windows Media Video Playlist Wikipedia: Advanced Systems Format (ASF)
    "avi": "video/x-msvideo", // Audio Video Interleave (AVI) Wikipedia: AVI
    "movie": "video/x-sgi-movie", // SGI Movie SGI Facts
    "ice": "x-conference/x-cooltalk", // CoolTalk Wikipedia: CoolTalk
    "par": "text/plain-bas" // BAS Partitur Format Phonetik BAS
]