
Branch tree;

void resetTree() {
  tree = new Branch(0, 0, 0, 0.0, 0.0, 200, new float[]{}, 0.0, 0);
}

class Branch {
  Branch parent;
  Branch[] children;
  int[] org;
  float[] dir;
  int len;
  float[] seeds;
  float phase;
  int dead = 0;
  //alive, last, leaves
  float deathChance;
  float deathChanceIncrement = 0.19;
  int maxBranches = 8;
  int dist = 0;

  Branch(int x, int y, int z, float a, float b, int l, float[] s, float dc, int distFromRoot){
    parent = null;
    children = new Branch[]{};
    len = l;
    dir = new float[]{ a, b };
    org = new int[]{ x, y, z };
    seeds = s;
    phase = 0.0;
    deathChance = dc;
    if (random(1.0)*random(1.0) > deathChance){
      dead += 1;
    }
    dist = distFromRoot;
  }

  void setParent(Branch b){
    b.children = (Branch[]) append( b.children, this);
    parent = b;
  }
  
  void grow() {
    if (children.length < maxBranches*(1.0-deathChance)){
      children = (Branch[]) append( children, addBranch() );
    }      
  }

  void update(float delta_phase, int deathDist, int cutDist){
    if (dist > 1){
      phase += delta_phase / len;
      dir[0] += sin(phase);
      dir[1] += cos(phase);
    }
    int ex = org[0] + int (sin( dir[0] ) * cos(dir[1]) * len);
    int ey = org[1] + int (sin( dir[0] ) * sin(dir[1]) * len);
    int ez = org[2] + int (cos( dir[0] ) * len);
    //line(org[0], org[1], org[2], ex, ey, ez);
    drawTrunk(ex, ey, ez, deathDist, cutDist);
    for (int i = 0; i < children.length; i++) {
      children[i].org[0] = org[0] + int (sin( dir[0] ) * cos(dir[1]) * children[i].seeds[0]);
      children[i].org[1] = org[1] + int (sin( dir[0] ) * sin(dir[1]) * children[i].seeds[0]);
      children[i].org[2] = org[2] + int (cos( dir[0] ) * children[i].seeds[0]);
      children[i].dir[0] = dir[0] + children[i].seeds[1];
      children[i].dir[1] = dir[1] + children[i].seeds[2];
      children[i].update(delta_phase, deathDist, cutDist);
    }
    grow();
  }
  
  Branch addBranch(){
    float s;
    int l;
    float ra;
    if (dead<2){
      s = len / 1.61803398875;//random(0.35, 0.85) * len;
      l = int ( len / 1.61803398875);
      ra = random(0, (1.0-deathChance)*TWO_PI/4);
    }
    else{
      s = len;
      l = len/2;
      ra = random(0, TWO_PI/2);
    }
    float rb = random(-TWO_PI, TWO_PI);
    Branch nb = new Branch(0, 0, 0, 0.0, 0.0, l, new float[]{s,ra,rb}, deathChance + deathChanceIncrement, dist+1 );
    nb.setParent( this );
    return nb;
  }

  void drawTrunk(int x, int y, int z, int deathDist, int cutDist){
    if (dist > cutDist) return;
    
    int width = (int) sqrt( len );
    int cwidth = int(width * 0.58061118421);
    int swidth = int(width * 0.81418097052);
    pushMatrix();
    if (dead<1){
      if (dist > deathDist) {
        stroke( 180, 95, 11);
        fill(180, 168, 59);
      } else {
        stroke( 58, 95, 11);
        fill(77, 168, 59);
      }
    }
    else{
      stroke( 102, 51, 0);
      fill(112, 60, 20);
    }

    beginShape(TRIANGLE_STRIP);

    vertex(x              , y              , z      ); //tip
    vertex(org[0] + width , org[1]         , org[2] );
    vertex(org[0] - cwidth, org[1] + swidth, org[2] );
    vertex(org[0] - cwidth, org[1] - swidth, org[2] );

    vertex(x              , y              , z      ); //tip
    vertex(org[0] + width , org[1]         , org[2] );

    vertex(org[0] - cwidth, org[1] - swidth, org[2] );
    vertex(org[0] - cwidth, org[1] + swidth, org[2] );
    vertex(org[0] + width , org[1]         , org[2] );

    endShape(CLOSE);
    popMatrix();

  }
}
