PFont narratorFont;

String[] narration = {
  "It is the year 2049",
  "Collapse of ecosystems in mid-2020s",
  "  ruined everyone's musical tastes (sorry!)",
  
  "All seas are so polluted",
  "  that they blink",
};
 
String[] talk = {
  "Hey",
  "what's up?",
  "Not much",
  "Same old huh",
  "Yea",
  "busy busy",
  "Where are you going?",
  "What does it look like?",
  "Oh...",
  "Right...",
  "Dumbass",

  "Hey",
  "What's that?",
  "\"Sur...stromming\"?",
  "what the shit?",
  "\"Open under water\"",
  "Check",
  "All right...",
  "pull it open...",

  "Oh god",
  "Flee!",
  "What the hell",
  "Hurts",
  "That stink",
  "My eyes"
};

String credits = "Thanks to Graffathon organizers!        " +
"Credits: Earlo (music), aleksandr, sig (gfx)        " +
"Diamond effect: Flynn, O. J., & Shapiro, A. G. (2018). " + 
"Available at https://sci-hub.se/https://doi.org/10.1177/2041669518815708           " +
"Font: Whoopass by Blambot Comic Fonts          " +
"Greetings go to hipo(pim!), Kuukunen, raimo_t, dokaus.net";

void drawDialogue() {
  int msgI = moonlander.getIntValue("scriptLine") - narration.length;
  if (msgI < 0 || msgI >= talk.length) { return; }
  double startRow = moonlander.getValue("scriptStartRow");
  float t = (float)(moonlander.getCurrentRow() - startRow);
  
  float x = (float)moonlander.getValue("dialoguePosX");
  float y = (float)moonlander.getValue("dialoguePosY");
  float speed = (float)moonlander.getValue("dialogueSpeed");
  
  String message = talk[msgI];
  
  if (t < 0.f) { return; }
  int chars = min(ceil(t / speed), message.length());
  String msg = message.substring(0, chars);
  drawPulseText(msg, v(x, y), 20, v(2, 0), talkColor);
}

void drawNarration() {
  int msgI = moonlander.getIntValue("scriptLine");
  if (msgI >= narration.length) { return; }
  double startRow = moonlander.getValue("scriptStartRow");
  float t = (float)(moonlander.getCurrentRow() - startRow);
  pushMatrix();
  scale(height / 1000.0);
  textFont(narratorFont);
  textSize(50);
  fill(0, 200, 0);
  int startI = msgI < 3 ? 0 : 3;
  PVector pos = v(100, 100);
  for (int i = startI; i < msgI; i++) {
    text(narration[i], pos.x, pos.y);
    pos = pos.add(0, 100);
  }
  drawNarrationTextLine(narration[msgI], pos, t, 1.0f);
  popMatrix();
}

void drawNarrationTextLine(String message, PVector pos, float t, float speed) {
  if (t < 0.f) { return; }
  int chars = min(ceil(t / speed), message.length());
  String msg = message.substring(0, chars);
  text(msg, pos.x, pos.y);
}