void setPulseColor(float shift) {
  float t = millis();
  float phase = 0.5 + 0.5 * sin(t / 100 + shift);
  color c = lerpColor(pulseColor1, pulseColor2, phase);
  //float c = 255 * phase;
  fill(c);
}

void drawBlock(PVector pos, float size, PVector tail, color bodyColor) {
  setPulseColor(PI * 0.5);
  rect(pos.x - tail.x - size/2, pos.y - tail.y - size/2, size, size);
  setPulseColor(PI * 1.5);
  rect(pos.x + tail.x - size/2, pos.y + tail.y - size/2, size, size);
  fill(bodyColor);
  rect(pos.x - size/2, pos.y - size/2, size, size);
}

void drawFish(PVector pos, float size, float angle, float tailSize, boolean flip, color bodyColor, boolean isDead) {
  noStroke();
  pushMatrix();
  translate(pos.x, pos.y);
  if (flip) { scale(-1.0, 1.0); }
  if (isDead) {
    setPulseColor(PI * 0.5);
    float x = -size * 0.6;
    float y = -size * 0.6;
    shape(deadFish, x, y - tailSize, size, size);
    setPulseColor(PI * 1.5);
    shape(deadFish, x, y + tailSize, size, size);
    fill(bodyColor);
    shape(deadFish, x, y, size, size);
  } else {
    rotate(angle);
    setPulseColor(PI * 0.5);
    shape(fish, -size*0.7 + tailSize, -size, size, size);
    setPulseColor(PI * 1.5);
    shape(fish, -size*0.7 - tailSize, -size, size, size);
    fill(bodyColor);
    shape(fish, -size*0.7, -size, size, size);
  }
  popMatrix();
}

void drawPulseText(String msg, PVector pos, int size, PVector tail, color bodyColor) {
  textFont(fatFont);
  textSize(size);
  setPulseColor(PI * 0.5);
  text(msg, pos.x - tail.x - size/2, pos.y - tail.y - size/2);
  setPulseColor(PI * 1.5);
  text(msg, pos.x + tail.x - size/2, pos.y + tail.y - size/2);
  fill(bodyColor);
  text(msg, pos.x - size/2, pos.y - size/2);
}