import moonlander.library.*;

import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;
import java.util.*;



//Global variables
Stack<Float> circlesX=new Stack<Float>();

Stack<Float> circlesY=new Stack<Float>();
boolean beatflag=true;

float p2Radius=400;
float p2Current=random(TAU);
Stack<Float> p2Old=new Stack<Float>();
PFont font;


Moonlander moonlander;

void settings(){
  fullScreen();
}

//setup is run at the beginning
void setup(){
  
  frameRate(60);
  colorMode(HSB, 360, 100, 100);
  
  printArray(PFont.list());
  font = createFont("SourceCodePro-Regular.ttf", 48);
  textFont(font);
  
  background(255,100,0);
  noCursor();
  moonlander = Moonlander.initWithSoundtrack(this,"../Club Seamus short.mp3",112,12);
  moonlander.start();
}
  
void draw() {
  moonlander.update();
  translate(width/2, height/2);
  scale(height/1000.0);
  float phase=(float)moonlander.getValue("phase");
  float beat=(float)moonlander.getValue("beat");
  float rotation=(float)moonlander.getValue("rotation");
  if(phase==1||phase==3){
    if(abs(rotation)<1){
      background(255,100,0);
      circlesX=new Stack();
      circlesY=new Stack();
      if(phase==3){
        setRandomCircleCoordinates(400);
        noFill();
        beginShape();
        int stacksize=p2Old.size();
        for(int i=0;i< min(1000,stacksize);i++){
          Pair vCoords=(new Pair(p2Radius,p2Old.get(stacksize-1-i))).polarToCartesian();
          vertex(vCoords.x,vCoords.y);
        }
        endShape();
      }else{
        setRandomCircleCoordinates((float)random(500));
      }
      
    }
    
    if(beat==1){
      if(beatflag){
        setRandomCircleCoordinates((float)random(500));
        beatflag=false;
      }
    }else{
      beatflag=true; 
    }
    
    
    
    rotate(radians(rotation));
    stroke(0,0,100);
    fill(0,0,100);
    
    int radius=15;
    if(phase==3){
     radius=10; 
    }
    
    for(int i=0 ; i<circlesX.size(); i++){
        circle(circlesX.get(i),circlesY.get(i),radius);
    }
    
    
  p2Old=new Stack<Float>();
  }else if(phase==2){
    background(0);
    
    if(beat==2 && beatflag){
      p2Current=p2Current+random(PI/2,3*PI/2);
      p2Old.push((Float)p2Current);
      beatflag=false;
    }else if(beat==3 && !beatflag){
      p2Current=p2Current+random(PI/2,3*PI/2);
      p2Old.push((Float)p2Current);
      beatflag=true;
    }else if(beat>0.5){
      if(beatflag){
        //chooses a new circle
        p2Current=p2Current+random(PI/2,PI);
        beatflag=false;
      }
      //draws a fading circle
    }else if(beat==-1){
      if(!beatflag){
        beatflag=true; 
        p2Old.push((Float)p2Current);
      }
    }
    
    noFill();
    stroke(0,0,100);
    Pair cCoords=(new Pair(p2Radius,p2Current)).polarToCartesian();
    circle(cCoords.x,cCoords.y,30);
    
    beginShape();
    int stacksize=p2Old.size();
    for(int i=0;i< min(1000,stacksize);i++){
      Pair vCoords=(new Pair(p2Radius,p2Old.get(stacksize-1-i))).polarToCartesian();
      vertex(vCoords.x,vCoords.y);
    }
    endShape();
    
    
    
    
  }else if(phase==4){
    if(beat<=8){
      stroke(0,0,100); 
      fill(0,0,100);
      Pair coords=(new Pair(70*beat,2.5*beat)).polarToCartesian();
      circle(coords.x,coords.y,50*beat*beat);
    }else{
      textAlign(CENTER);
      fill(0);
      text("\"Club Seamus\" Kevin MacLeod (incompetech.com)\n Licensed under Creative Commons: By Attribution 3.0 License\nhttp://creativecommons.org/licenses/by/3.0/\n\n\nDemo by Selim Virtanen",0,-200);
    }
  }
  
  
  //circle(circlesX.get(0),circlesY.get(0),50);
  
  
  
  /*fill(255); rectMode(CENTER);
  noStroke();
  
  
  for (int i = 0; i <= 10; i++) {
    for (int j = 0; j <= 10; j++) {
      float x = map(i, 0, 10, -500, 500);
      float y = map(j, 0, 10, -500, 500);
      rect(x, y, 15, 100*rotation);
    }
  }*/
  
  
  
  
}
public class Pair{
  float x;
  float y;
  public Pair(float x1,float y1){
    x=x1;
    y=y1;
  }
  public Pair polarToCartesian(){
    return new Pair(x*cos(y),x*sin(y));
  }
}

void setRandomCircleCoordinates(float r){
  Pair randomCoords=(new Pair(r,(float)random(TAU))).polarToCartesian();
  
  circlesX.push((Float)randomCoords.x);
  circlesY.push((Float)randomCoords.y);
}
