/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.SourcedInterruptedException;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.AnimatorBase;

public class Animator
extends AnimatorBase {
    private ThreadGroup threadGroup;
    private Runnable runnable;
    private boolean runAsFastAsPossible;
    boolean isAnimating;
    volatile boolean pauseIssued;
    volatile boolean stopIssued;
    private final AnimatorBase.Condition waitForStartedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return !Animator.this.isStarted() || !Animator.this.drawablesEmpty && !Animator.this.isAnimating;
        }
    };
    private final AnimatorBase.Condition waitForStoppedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return Animator.this.isStarted();
        }
    };
    private final AnimatorBase.Condition waitForPausedCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return Animator.this.isStarted() && Animator.this.isAnimating;
        }
    };
    private final AnimatorBase.Condition waitForResumeCondition = new AnimatorBase.Condition(){

        @Override
        public boolean eval() {
            return Animator.this.isStarted() && (!Animator.this.drawablesEmpty && !Animator.this.isAnimating || Animator.this.drawablesEmpty && !Animator.this.pauseIssued);
        }
    };

    public Animator() {
        if (DEBUG) {
            System.err.println("Animator created");
        }
    }

    public Animator(ThreadGroup threadGroup) {
        this.setThreadGroup(threadGroup);
        if (DEBUG) {
            System.err.println("Animator created, ThreadGroup: " + this.threadGroup);
        }
    }

    public Animator(GLAutoDrawable gLAutoDrawable) {
        this.add(gLAutoDrawable);
        if (DEBUG) {
            System.err.println("Animator created, w/ " + gLAutoDrawable);
        }
    }

    public Animator(ThreadGroup threadGroup, GLAutoDrawable gLAutoDrawable) {
        this.setThreadGroup(threadGroup);
        this.add(gLAutoDrawable);
        if (DEBUG) {
            System.err.println("Animator created, ThreadGroup: " + this.threadGroup + " and " + gLAutoDrawable);
        }
    }

    @Override
    protected final String getBaseName(String string) {
        return string + "Animator";
    }

    public final synchronized void setRunAsFastAsPossible(boolean bl) {
        this.runAsFastAsPossible = bl;
    }

    @Override
    public final synchronized boolean isAnimating() {
        return this.animThread != null && this.isAnimating;
    }

    @Override
    public final synchronized boolean isPaused() {
        return this.animThread != null && this.pauseIssued;
    }

    public final synchronized void setThreadGroup(ThreadGroup threadGroup) throws GLException {
        if (this.isStarted()) {
            throw new GLException("Animator already started.");
        }
        this.threadGroup = threadGroup;
    }

    @Override
    public final synchronized boolean start() {
        if (this.isStarted()) {
            return false;
        }
        if (this.runnable == null) {
            this.runnable = new MainLoop();
        }
        this.fpsCounter.resetFPSCounter();
        InterruptSource.Thread thread = new InterruptSource.Thread(this.threadGroup, this.runnable, Animator.getThreadName() + "-" + this.baseName);
        thread.setDaemon(false);
        if (DEBUG) {
            Thread thread2 = Thread.currentThread();
            System.err.println("Animator " + thread2.getName() + "[daemon " + thread2.isDaemon() + "]: starting " + thread.getName() + "[daemon " + thread.isDaemon() + "]");
        }
        thread.start();
        return this.finishLifecycleAction(this.waitForStartedCondition, 0L);
    }

    @Override
    public final synchronized boolean stop() {
        if (!this.isStarted()) {
            return false;
        }
        this.stopIssued = true;
        return this.finishLifecycleAction(this.waitForStoppedCondition, 0L);
    }

    @Override
    public final synchronized boolean pause() {
        if (!this.isStarted() || this.pauseIssued) {
            return false;
        }
        this.pauseIssued = true;
        return this.finishLifecycleAction(this.waitForPausedCondition, 0L);
    }

    @Override
    public final synchronized boolean resume() {
        if (!this.isStarted() || !this.pauseIssued) {
            return false;
        }
        this.pauseIssued = false;
        return this.finishLifecycleAction(this.waitForResumeCondition, 0L);
    }

    class MainLoop
    implements Runnable {
        MainLoop() {
        }

        public String toString() {
            return "[started " + Animator.this.isStarted() + ", animating " + Animator.this.isAnimating() + ", paused " + Animator.this.isPaused() + ", drawable " + Animator.this.drawables.size() + ", drawablesEmpty " + Animator.this.drawablesEmpty + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl;
            ThreadDeath threadDeath = null;
            AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException = null;
            try {
                Animator animator = Animator.this;
                synchronized (animator) {
                    if (AnimatorBase.DEBUG) {
                        System.err.println("Animator start on " + AnimatorBase.getThreadName() + ": " + this.toString());
                    }
                    Animator.this.fpsCounter.resetFPSCounter();
                    Animator.this.animThread = Thread.currentThread();
                    Animator.this.isAnimating = false;
                }
                while (!Animator.this.stopIssued) {
                    animator = Animator.this;
                    synchronized (animator) {
                        bl = false;
                        while (!Animator.this.stopIssued && (Animator.this.pauseIssued || Animator.this.drawablesEmpty)) {
                            if (Animator.this.drawablesEmpty) {
                                Animator.this.pauseIssued = true;
                            }
                            boolean bl2 = Animator.this.pauseIssued;
                            if (AnimatorBase.DEBUG) {
                                System.err.println("Animator pause on " + Animator.this.animThread.getName() + ": " + this.toString());
                            }
                            if (Animator.this.exclusiveContext && !Animator.this.drawablesEmpty && !bl) {
                                bl = true;
                                Animator.this.setDrawablesExclCtxState(false);
                                try {
                                    Animator.this.display();
                                }
                                catch (AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException2) {
                                    uncaughtAnimatorException = uncaughtAnimatorException2;
                                    Animator.this.stopIssued = true;
                                    break;
                                }
                            }
                            Animator.this.isAnimating = false;
                            Animator.this.notifyAll();
                            try {
                                Animator.this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                uncaughtAnimatorException = new AnimatorBase.UncaughtAnimatorException(null, (Throwable)SourcedInterruptedException.wrap((InterruptedException)interruptedException));
                                Animator.this.stopIssued = true;
                                break;
                            }
                            if (!bl2) continue;
                            Animator.this.fpsCounter.resetFPSCounter();
                            if (!AnimatorBase.DEBUG) continue;
                            System.err.println("Animator resume on " + Animator.this.animThread.getName() + ": " + this.toString());
                        }
                        if (!Animator.this.stopIssued && !Animator.this.isAnimating) {
                            Animator.this.isAnimating = true;
                            Animator.this.setDrawablesExclCtxState(Animator.this.exclusiveContext);
                            Animator.this.notifyAll();
                        }
                    }
                    if (Animator.this.pauseIssued || Animator.this.stopIssued) continue;
                    try {
                        Animator.this.display();
                    }
                    catch (AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException3) {
                        uncaughtAnimatorException = uncaughtAnimatorException3;
                        Animator.this.stopIssued = true;
                        break;
                    }
                    if (Animator.this.runAsFastAsPossible) continue;
                    Thread.yield();
                }
            }
            catch (ThreadDeath threadDeath2) {
                if (AnimatorBase.DEBUG) {
                    ExceptionUtils.dumpThrowable((String)"", (Throwable)threadDeath2);
                }
                threadDeath = threadDeath2;
            }
            if (Animator.this.exclusiveContext && !Animator.this.drawablesEmpty) {
                Animator.this.setDrawablesExclCtxState(false);
                try {
                    Animator.this.display();
                }
                catch (AnimatorBase.UncaughtAnimatorException uncaughtAnimatorException4) {
                    if (null == uncaughtAnimatorException) {
                        uncaughtAnimatorException = uncaughtAnimatorException4;
                    }
                    ExceptionUtils.dumpThrowable((String)"(setExclusiveContextThread)", (Throwable)uncaughtAnimatorException4);
                }
            }
            boolean bl3 = false;
            bl = false;
            Animator animator = Animator.this;
            synchronized (animator) {
                if (AnimatorBase.DEBUG) {
                    System.err.println("Animator stop on " + Animator.this.animThread.getName() + ": " + this.toString());
                    if (null != uncaughtAnimatorException) {
                        ExceptionUtils.dumpThrowable((String)"", (Throwable)uncaughtAnimatorException);
                    }
                }
                Animator.this.stopIssued = false;
                Animator.this.pauseIssued = false;
                Animator.this.isAnimating = false;
                if (null != uncaughtAnimatorException) {
                    bl3 = true;
                    bl = !Animator.this.handleUncaughtException(uncaughtAnimatorException);
                }
                Animator.this.animThread = null;
                Animator.this.notifyAll();
            }
            if (bl3) {
                Animator.this.flushGLRunnables();
            }
            if (bl) {
                throw uncaughtAnimatorException;
            }
            if (null != threadDeath) {
                throw threadDeath;
            }
        }
    }
}

