/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;

public class rumademo
extends PApplet {
    Moonlander moonlander;
    int c1 = -6185217;
    int c2 = -7025429;
    int c3 = -7536681;
    int c4 = -6163048;
    int c5 = -128;
    int[] colors = new int[]{this.c1, this.c2, this.c3, this.c4, this.c5};
    int bg_red = 0;
    int bg_green = 0;
    int bg_blue = 0;
    double startRow5 = -1.0;
    double dynStartRow = -1.0;
    int prevState = -1;

    public void setup() {
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"data/exit_the_premises_short.mp3", (int)128, (int)8);
        this.background(0);
        this.noCursor();
        this.moonlander.start("localhost", 1338, "data/syncdata.rocket");
    }

    public void draw() {
        this.moonlander.update();
        int scene = this.moonlander.getIntValue("scene");
        if (scene == 0) {
            this.intro();
        } else if (scene == 1) {
            this.scene1();
        } else if (scene == 2) {
            this.scene2();
        } else if (scene == 3) {
            this.scene3();
        } else if (scene == 4) {
            this.scene4();
        } else if (scene == 5) {
            this.scene5();
        } else if (scene == 6) {
            this.scene6();
        }
    }

    public void scene1() {
        this.hexagonGrid();
    }

    public void scene2() {
        this.drawManyTriangles();
    }

    public void scene3() {
        this.background(0);
        int size = 5;
        int n = 5;
        float trianglesX = 0.01f * (float)this.width;
        float trianglesY = 0.01f * (float)this.height;
        float widthKerroin = 1.0f / trianglesX;
        float heightKerroin = 1.0f / trianglesY;
        float i = 0.0f;
        while (i <= 1.0f) {
            float j = 0.0f;
            while (j <= 1.0f) {
                this.drawTriangles(n, i, j, size);
                j += heightKerroin;
            }
            i += widthKerroin;
        }
    }

    public void scene4() {
        int state = this.moonlander.getIntValue("state");
        int startRow = 872;
        int row = (int)this.moonlander.getCurrentRow();
        if (row < 1152) {
            this.background(0);
        }
        int rowDelta = row - startRow + 75;
        float insideRadius = rowDelta / 10;
        float outsideRadius = rowDelta / 10;
        int i = 4;
        while (i <= 40) {
            this.pushMatrix();
            this.translate(this.width / 2, this.height / 2);
            this.rotate(rowDelta);
            this.triangleStrip(i, insideRadius, outsideRadius);
            insideRadius *= 1.2f;
            outsideRadius *= 1.2f;
            this.fill(this.colors[i % this.colors.length], state);
            this.popMatrix();
            i += 2;
        }
    }

    public void scene5() {
        this.expandingCircle();
    }

    public void scene6() {
        this.background(0);
        if (this.startRow5 == -1.0) {
            this.startRow5 = this.moonlander.getCurrentTime();
        }
        float deltaRow = (float)(this.startRow5 - this.moonlander.getCurrentTime()) / 2.13f;
        int state = this.moonlander.getIntValue("state");
        float div = (float)(state + 1) * 10.0f;
        float vertexRadius = (float)this.width / div;
        float edgeRadius = vertexRadius / 2.0f * rumademo.tan((float)1.0471976f);
        float radMod = (rumademo.cos((float)(4.0f * deltaRow)) + 9.0f) / 10.0f;
        float hPad = 1.5f * vertexRadius;
        float wPad = 2.0f * edgeRadius;
        if (state == 8 && this.prevState == 7) {
            this.dynStartRow = this.moonlander.getCurrentTime();
        }
        this.prevState = state;
        float dynDelta = (float)(this.moonlander.getCurrentTime() - this.dynStartRow);
        float x = dynDelta * (float)(this.width / 2) - (float)this.width;
        float max_distance = rumademo.dist((float)0.0f, (float)0.0f, (float)this.width, (float)this.height);
        int k = 0;
        int p = 0;
        int n = 0;
        float i = 0.0f;
        while (i < (float)this.height + hPad) {
            if (k % 2 == 0) {
                this.resetMatrix();
            } else {
                this.translate(edgeRadius, 0.0f);
            }
            float d = 0.0f;
            while (d <= (float)this.width + wPad) {
                this.pushMatrix();
                this.translate(d, i);
                if (state >= 1) {
                    this.rotate(-0.6666667f * deltaRow);
                }
                if (state <= 1) {
                    this.fill(this.colors[4]);
                } else if (state == 2) {
                    this.fill(this.colors[k % 5]);
                } else if (state < 5) {
                    this.fill(this.colors[(k * n + p) % 5]);
                } else {
                    this.fill(this.colors[k % 5], this.random(255.0f));
                }
                if (state >= 8) {
                    float size = rumademo.dist((float)x, (float)((float)this.height - i), (float)d, (float)i);
                    float maxSize = radMod * vertexRadius;
                    size = rumademo.min((float)(size / max_distance * maxSize), (float)maxSize);
                    if (d > x) {
                        this.polygon(0.0f, 0.0f, size, 6, 1.5707964f);
                    }
                } else {
                    this.polygon(0.0f, 0.0f, radMod * vertexRadius, 6, 1.5707964f);
                }
                this.popMatrix();
                ++p;
                d += wPad;
            }
            n = rumademo.max((int)(++k), (int)n);
            i += hPad;
        }
    }

    public void drawTriangles(int n, float widthKerroin, float heightKerroin, int size) {
        int x = 0;
        int y = 0;
        float multip = 0.001f * (float)this.height;
        float rowCount = (float)this.moonlander.getCurrentRow() * 8.0f;
        float rotation = rumademo.sin((float)(rowCount / 25.0f)) + rumademo.sin((float)(rowCount / -75.0f));
        this.pushMatrix();
        this.translate((float)this.width * widthKerroin, (float)this.height * heightKerroin);
        this.rotate(rotation);
        int i = 0;
        while (i <= n) {
            this.polygon(x, y, multip * (float)size, 3);
            this.fill(this.colors[i % this.colors.length]);
            x += 20;
            y += 20;
            multip += 0.1f;
            ++i;
        }
        this.popMatrix();
    }

    public void polygon(float x, float y, float radius, int npoints, float sAngle) {
        float angle = (float)Math.PI * 2 / (float)npoints;
        this.beginShape();
        float a = sAngle;
        while (a < (float)Math.PI * 2 + sAngle) {
            float sx = x + rumademo.cos((float)a) * radius;
            float sy = y + rumademo.sin((float)a) * radius;
            this.vertex(sx, sy);
            a += angle;
        }
        this.endShape(2);
    }

    public void polygon(float x, float y, float radius, int npoints) {
        this.polygon(x, y, radius, npoints, 0.0f);
    }

    public void triangleStrip(int sides, float outsideRadius, float insideRadius) {
        boolean x = false;
        boolean y = false;
        float angle = 0.0f;
        float angleStep = 180.0f / (float)sides;
        this.beginShape(10);
        int i = 0;
        while (i <= sides) {
            float px = (float)x + rumademo.cos((float)rumademo.radians((float)angle)) * outsideRadius;
            float py = (float)y + rumademo.sin((float)rumademo.radians((float)angle)) * outsideRadius;
            this.vertex(px, py);
            px = (float)x + rumademo.cos((float)rumademo.radians((float)(angle += angleStep))) * insideRadius;
            py = (float)y + rumademo.sin((float)rumademo.radians((float)angle)) * insideRadius;
            this.vertex(px, py);
            angle += angleStep;
            ++i;
        }
        this.endShape();
    }

    public void drawManyTriangles() {
        int row = (int)this.moonlander.getCurrentRow();
        if (row >= 384) {
            this.drawColorfulTriangles();
        } else {
            this.drawBlackTriangles();
        }
    }

    public void drawColorfulTriangles() {
        int startRow = 248;
        int rowDelta = (int)this.moonlander.getCurrentRow() - startRow;
        float randX = this.random(this.width);
        float randY = this.random(this.height);
        int i = 0;
        while (i <= rowDelta) {
            this.polygon(randX, randY, this.random((float)this.width * 0.1f), 3);
            this.fill(this.colors[(int)this.random(5.0f)]);
            ++i;
        }
    }

    public void drawBlackTriangles() {
        float randX = this.random(this.width);
        float randY = this.random(this.height);
        this.polygon(randX, randY, this.random((float)this.width * 0.2f), 3);
        this.fill(this.random(150.0f), this.random(150.0f));
    }

    public void expandingCircle() {
        int state = this.moonlander.getIntValue("state");
        int startRow = 1384;
        int size = ((int)this.moonlander.getCurrentRow() - startRow) * this.width / 16;
        this.fill(255, state);
        this.circle(this.width / 2, this.height / 2, size);
    }

    public void hexagonGrid() {
        int startRow = 136;
        int row = (int)this.moonlander.getCurrentRow();
        int x = (row - startRow) * (this.width / 64);
        float max_distance = rumademo.dist((float)0.0f, (float)0.0f, (float)this.width, (float)this.height);
        if (row % 2 == 0) {
            int i = 0;
            while (i <= x) {
                int j = 0;
                while (j <= this.height) {
                    float size = rumademo.dist((float)x, (float)(this.height - j), (float)i, (float)j);
                    size = size / max_distance * 15.0f;
                    this.polygon(i, j, size, 6);
                    this.fill(this.colors[(int)this.random(5.0f)]);
                    j += 20;
                }
                i += 20;
            }
        }
    }

    public void intro() {
        this.background(this.bg_red, this.bg_green, this.bg_blue);
        boolean blink = this.moonlander.getIntValue("beat") == 1;
        this.blinkScreen(blink);
    }

    public void blinkScreen(boolean blink) {
        int k = 10;
        if (blink) {
            this.bg_red = 255;
            this.bg_green = 255;
            this.bg_blue = 255;
        } else {
            this.bg_red -= k;
            this.bg_green -= k;
            this.bg_blue -= k;
        }
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#666666", "--hide-stop", "rumademo"};
        if (passedArgs != null) {
            PApplet.main((String[])rumademo.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

