/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import moonlander.library.Connector;
import moonlander.library.Controller;
import moonlander.library.MinimController;
import moonlander.library.ProjectFileConnector;
import moonlander.library.SocketConnector;
import moonlander.library.Track;
import moonlander.library.TrackContainer;
import processing.core.PApplet;

public class Moonlander {
    public static final String VERSION = "1.0.2";
    PApplet parent;
    private TrackContainer tracks;
    private Connector connector;
    private Controller controller;
    private static Logger logger = Logger.getLogger("moonlander.library");

    public Moonlander(PApplet pApplet, Controller controller) {
        this.setupLogging(Level.INFO);
        this.tracks = new TrackContainer();
        this.parent = pApplet;
        this.controller = controller;
    }

    public static Moonlander initWithSoundtrack(PApplet pApplet, String string, int n, int n2) {
        Minim minim = new Minim((Object)pApplet);
        AudioPlayer audioPlayer = minim.loadFile(string, 1024);
        return new Moonlander(pApplet, new MinimController(audioPlayer, n, n2));
    }

    private void setupLogging(Level level) {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINEST);
        logger.setUseParentHandlers(false);
        logger.addHandler(consoleHandler);
        logger.setLevel(level);
    }

    public void changeLogLevel(Level level) {
        logger.setLevel(level);
    }

    public boolean start(String string, int n, String string2) {
        try {
            this.connector = new SocketConnector(logger, this.tracks, this.controller, string, n);
        }
        catch (Exception exception) {
            try {
                this.connector = new ProjectFileConnector(logger, this.tracks, this.controller, this.parent.sketchPath(string2));
            }
            catch (Exception exception2) {
                logger.severe("Both connectors failed. Either run Rocket or put 'syncdata.rocket' file into sketch's folder.");
                return false;
            }
        }
        logger.info("Moonlander initialized successfully.");
        return true;
    }

    public boolean start() {
        return this.start("localhost", 1338, "syncdata.rocket");
    }

    public void update() {
        if (this.controller != null && this.connector != null) {
            this.controller.update();
            this.connector.update();
        }
    }

    public Track getTrack(String string) {
        return this.tracks.getOrCreate(string);
    }

    public double getValue(String string) {
        return this.getTrack(string).getValue(this.controller.getCurrentRow());
    }

    public int getIntValue(String string) {
        return (int)this.getValue(string);
    }

    public double getCurrentTime() {
        return this.controller.getCurrentTime();
    }

    public double getCurrentRow() {
        return this.controller.getCurrentRow();
    }

    public static String version() {
        return VERSION;
    }
}

