/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.opengl.PShader;

public class Kuplakylpy_by_Kylpykopla
extends PApplet {
    Moonlander moonlander;
    AnnanPallerot annanPallerot;
    KiminJaRikunKotostys kiminJaRikunKotostys;
    KuplaKylpy kuplaKylpy;
    KuutioKaksi kuutioKaksi;
    Water water;

    public void setup() {
        this.frameRate(60.0f);
        this.noCursor();
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"morelove_edit_120bpm.mp3", (int)120, (int)8);
        this.moonlander.start();
        this.annanPallerot = new AnnanPallerot();
        this.annanPallerot.setup();
        this.kiminJaRikunKotostys = new KiminJaRikunKotostys();
        this.kiminJaRikunKotostys.setup();
        this.kuplaKylpy = new KuplaKylpy();
        this.kuplaKylpy.setup();
        this.kuutioKaksi = new KuutioKaksi();
        this.kuutioKaksi.setup();
        this.water = new Water();
        this.water.setup();
    }

    public void keyPressed() {
        this.kiminJaRikunKotostys.keyPressed();
        this.kuplaKylpy.keyPressed();
        this.water.keyPressed();
    }

    public void draw() {
        this.moonlander.update();
        this.background(0);
        this.translate(this.width / 2, this.height / 2);
        this.scale((float)this.height / 1000.0f);
        double scene = this.moonlander.getValue("scene");
        float time = (float)this.moonlander.getCurrentTime();
        float beat = this.beatGenerator(time, 120.0f);
        float waterHeight = (float)this.moonlander.getValue("waterHeight");
        if (scene == 0.0) {
            this.annanPallerot.draw();
        } else if (scene == 1.0) {
            this.kiminJaRikunKotostys.draw(time, beat);
        } else if (scene == 2.0) {
            this.kuplaKylpy.draw(time, beat);
        } else if (scene == 3.0) {
            this.kuutioKaksi.draw(time, beat);
        }
        if (waterHeight > 0.0f) {
            this.water.draw(time, beat, waterHeight);
        }
        if (this.moonlander.getValue("exit") == 1.0) {
            this.exit();
        }
    }

    public float beatGenerator(float time, float bpm) {
        float beatInterval = 1.0f / (bpm / 60.0f);
        float v = 1.0f - time % beatInterval / beatInterval;
        return v;
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
        this.pixelDensity(this.displayDensity());
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Kuplakylpy_by_Kylpykopla"};
        if (passedArgs != null) {
            PApplet.main((String[])Kuplakylpy_by_Kylpykopla.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class AnnanPallerot {
        float colorRed;
        float colorGreen;
        float colorBlue;
        float w = 1066.8f;
        float h = 600.0f;
        float x = 0.0f;
        float y = 0.0f;
        float xSpeed = 0.05f;
        float ySpeed = 0.051f;
        int ballCount = 100;

        AnnanPallerot() {
        }

        public void setup() {
        }

        public void draw() {
            Kuplakylpy_by_Kylpykopla.this.background(100.0f, 55.0f, 100.0f);
            Kuplakylpy_by_Kylpykopla.this.fill(this.colorRed, this.colorGreen, this.colorBlue);
            Kuplakylpy_by_Kylpykopla.this.noStroke();
            int i = 0;
            while (i < this.ballCount) {
                Kuplakylpy_by_Kylpykopla.this.circle(this.x * this.w - this.w / 2.0f, this.y * this.h - this.h / 2.0f, this.h * 0.0625f);
                this.x += this.xSpeed;
                this.y += this.ySpeed;
                if (this.x > 1.0f || this.x < 0.0f) {
                    this.xSpeed *= -1.0f;
                    this.resetColors();
                }
                if (this.y > 1.0f || this.y < 0.0f) {
                    this.ySpeed *= -1.0f;
                    this.resetColors();
                }
                ++i;
            }
        }

        public void resetColors() {
            this.colorRed = Kuplakylpy_by_Kylpykopla.this.random(255.0f);
            this.colorGreen = Kuplakylpy_by_Kylpykopla.this.random(255.0f);
            this.colorBlue = Kuplakylpy_by_Kylpykopla.this.random(255.0f);
        }
    }

    class Box {
        float x;
        float y;
        float z;
        float xR;
        float yR;
        float zR;
        int c;

        Box(float xOffset, float yOffset, float zOffset, float xRotation, float yRotation, float zRotation) {
            this.x = xOffset;
            this.y = yOffset;
            this.z = zOffset;
            this.xR = xRotation;
            this.yR = yRotation;
            this.zR = zRotation;
            this.c = Kuplakylpy_by_Kylpykopla.this.color(Kuplakylpy_by_Kylpykopla.this.random(256.0f), Kuplakylpy_by_Kylpykopla.this.random(256.0f), Kuplakylpy_by_Kylpykopla.this.random(256.0f));
        }

        public void update(float t, float b) {
            Kuplakylpy_by_Kylpykopla.this.translate(0.0f, 0.0f, -t * (b / ((t - 1.0f) % 2.0f)));
            Kuplakylpy_by_Kylpykopla.this.rotateX(0.0f);
            Kuplakylpy_by_Kylpykopla.this.rotateY(0.0f);
            Kuplakylpy_by_Kylpykopla.this.rotateZ(this.zR);
            if (t > 3.0f && (t - 1.0f) % 2.0f < 0.05f) {
                this.c = Kuplakylpy_by_Kylpykopla.this.color(Kuplakylpy_by_Kylpykopla.this.random(256.0f), Kuplakylpy_by_Kylpykopla.this.random(256.0f), Kuplakylpy_by_Kylpykopla.this.random(256.0f));
            }
        }
    }

    class KiminJaRikunKotostys {
        float colorRed;
        float colorGreen;
        float colorBlue;
        int x;
        int y;
        int xSpeed;
        int ySpeed;
        int index;
        PShader blur;

        KiminJaRikunKotostys() {
            this.x = Kuplakylpy_by_Kylpykopla.this.width / 2;
            this.y = Kuplakylpy_by_Kylpykopla.this.height / 2;
            this.xSpeed = 5;
            this.ySpeed = 5;
            this.index = 0;
        }

        public void setup() {
            this.blur = Kuplakylpy_by_Kylpykopla.this.loadShader("blur.glsl");
            Kuplakylpy_by_Kylpykopla.this.stroke(0.0f, 102.0f, 153.0f);
            Kuplakylpy_by_Kylpykopla.this.rectMode(3);
        }

        public void keyPressed() {
            if (Kuplakylpy_by_Kylpykopla.this.key == ' ') {
                try {
                    PShader newShader = Kuplakylpy_by_Kylpykopla.this.loadShader("blur.glsl");
                    if (newShader != null) {
                        this.blur = newShader;
                    }
                }
                catch (RuntimeException e) {
                    Kuplakylpy_by_Kylpykopla.print((String)("failed: " + e));
                }
            }
        }

        public void draw(float time, float beat) {
            Kuplakylpy_by_Kylpykopla.this.millis();
            this.blur.set("time", time);
            this.blur.set("pulse", beat);
            this.blur.set("screenSize", 1.77777f, 1.0f);
            Kuplakylpy_by_Kylpykopla.this.filter(this.blur);
        }
    }

    class KuplaKylpy {
        PShader kuplaShader;

        KuplaKylpy() {
        }

        public void reloadShaders() {
            try {
                PShader newShader = Kuplakylpy_by_Kylpykopla.this.loadShader("kuplakylpy.glsl");
                if (newShader != null) {
                    Kuplakylpy_by_Kylpykopla.print((String)"reloaded kuplakylpy");
                    this.kuplaShader = newShader;
                }
            }
            catch (RuntimeException e) {
                Kuplakylpy_by_Kylpykopla.print((String)("vituixm\u00e4n kuplashaderin lataaminen: " + e));
            }
        }

        public void setup() {
            this.reloadShaders();
            Kuplakylpy_by_Kylpykopla.this.rectMode(3);
        }

        public void keyPressed() {
            if (Kuplakylpy_by_Kylpykopla.this.key == ' ') {
                this.reloadShaders();
            }
        }

        public void draw(float time, float beat) {
            this.kuplaShader.set("time", time);
            this.kuplaShader.set("beat", beat);
            Kuplakylpy_by_Kylpykopla.this.filter(this.kuplaShader);
        }
    }

    class KuutioKaksi {
        float w = 1422.4f;
        float h = 800.0f;
        float boxSize = this.h / 1.6f;
        int boxRotation = 1;
        int count = 8;
        int countDiv = 2;
        Box[] boxes;

        KuutioKaksi() {
        }

        public void setup() {
            Kuplakylpy_by_Kylpykopla.this.randomSeed(0L);
            this.boxes = new Box[this.count];
            int dim = this.countDiv;
            int i = 0;
            int y = 0;
            while (y < dim) {
                int x = 0;
                while (x < dim) {
                    int z = 0;
                    while (z < dim) {
                        this.boxes[i++] = new Box(-(this.w / 5.0f) + (float)x * this.boxSize, this.h + (float)y * this.boxSize, (float)z * this.boxSize, this.boxRotation, this.boxRotation, this.boxRotation);
                        ++z;
                    }
                    ++x;
                }
                ++y;
            }
        }

        public void draw(float t, float b) {
            Kuplakylpy_by_Kylpykopla.this.rotateX(-0.4f * Kuplakylpy_by_Kylpykopla.sin((float)t));
            Kuplakylpy_by_Kylpykopla.this.rotateY(1.25f * (Kuplakylpy_by_Kylpykopla.sin((float)t) / 7.0f));
            Kuplakylpy_by_Kylpykopla.this.rotateZ(t / 6.0f);
            Box[] boxArray = this.boxes;
            int n = this.boxes.length;
            int n2 = 0;
            while (n2 < n) {
                Box box = boxArray[n2];
                box.update(t, b);
                Kuplakylpy_by_Kylpykopla.this.fill(box.c);
                Kuplakylpy_by_Kylpykopla.this.box(this.boxSize);
                ++n2;
            }
        }
    }

    class Water {
        PShader waterShader;

        Water() {
        }

        public void reloadShaders() {
            try {
                PShader newShader = Kuplakylpy_by_Kylpykopla.this.loadShader("water.glsl");
                if (newShader != null) {
                    Kuplakylpy_by_Kylpykopla.print((String)"reloaded water");
                    this.waterShader = newShader;
                }
            }
            catch (RuntimeException e) {
                Kuplakylpy_by_Kylpykopla.print((String)("vituixm\u00e4n watersaheinf lataaminen: " + e));
            }
        }

        public void setup() {
            this.reloadShaders();
            Kuplakylpy_by_Kylpykopla.this.rectMode(3);
        }

        public void keyPressed() {
            if (Kuplakylpy_by_Kylpykopla.this.key == ' ') {
                this.reloadShaders();
            }
        }

        public void draw(float time, float beat, float water) {
            this.waterShader.set("time", time);
            this.waterShader.set("beat", beat);
            this.waterShader.set("water", water);
            Kuplakylpy_by_Kylpykopla.this.filter(this.waterShader);
        }
    }
}

