/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.Minim;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Frequency {
    static float HZA4 = 440.0f;
    static float MIDIA4 = 69.0f;
    static float MIDIOCTAVE = 12.0f;
    private static TreeMap<String, Integer> noteNameOffsets = Frequency.initializeNoteNameOffsets();
    private static String noteNameRegex = Frequency.initializeNoteNameRegex();
    private static String noteNaturalnessRegex = "[#b]";
    private static String noteOctaveRegex = "(-1|10|[0-9])";
    private static String pitchRegex = "^" + noteNameRegex + "?[ ]*" + noteNaturalnessRegex + "*[ ]*" + noteOctaveRegex + "?$";
    private float freq;

    private static TreeMap<String, Integer> initializeNoteNameOffsets() {
        TreeMap<String, Integer> initNNO = new TreeMap<String, Integer>();
        initNNO.put("A", new Integer(9));
        initNNO.put("B", new Integer(11));
        initNNO.put("C", new Integer(0));
        initNNO.put("D", new Integer(2));
        initNNO.put("E", new Integer(4));
        initNNO.put("F", new Integer(5));
        initNNO.put("G", new Integer(7));
        initNNO.put("La", new Integer(9));
        initNNO.put("Si", new Integer(11));
        initNNO.put("Do", new Integer(0));
        initNNO.put("Re", new Integer(2));
        initNNO.put("Mi", new Integer(4));
        initNNO.put("Fa", new Integer(5));
        initNNO.put("Sol", new Integer(7));
        return initNNO;
    }

    private static String initializeNoteNameRegex() {
        ArrayList<String> reverserList = new ArrayList<String>();
        Iterator<String> iterator = noteNameOffsets.keySet().iterator();
        while (iterator.hasNext()) {
            reverserList.add(iterator.next());
        }
        String nNR = "(";
        ListIterator listIterator = reverserList.listIterator(reverserList.size());
        while (listIterator.hasPrevious()) {
            nNR = nNR + (String)listIterator.previous() + "|";
        }
        nNR = nNR.substring(0, nNR.length() - 1);
        nNR = nNR + ")";
        return nNR;
    }

    private Frequency(float hz) {
        this.freq = hz;
    }

    public float asHz() {
        return this.freq;
    }

    public void setAsHz(float hz) {
        this.freq = hz;
    }

    public float asMidiNote() {
        float midiNote = MIDIA4 + MIDIOCTAVE * (float)Math.log(this.freq / HZA4) / (float)Math.log(2.0);
        return midiNote;
    }

    public static Frequency ofHertz(float hz) {
        return new Frequency(hz);
    }

    public static Frequency ofMidiNote(float midiNote) {
        float hz = HZA4 * (float)Math.pow(2.0, (midiNote - MIDIA4) / MIDIOCTAVE);
        return new Frequency(hz);
    }

    public static Frequency ofPitch(String pitchName) {
        if ((pitchName = pitchName.trim()).matches(pitchRegex)) {
            float noteOctave;
            Minim.debug(pitchName + " matches the pitchRegex.");
            Pattern pattern = Pattern.compile(noteOctaveRegex);
            Matcher matcher = pattern.matcher(pitchName);
            if (matcher.find()) {
                String octaveString = pitchName.substring(matcher.start(), matcher.end());
                noteOctave = Float.valueOf(octaveString.trim()).floatValue();
            } else {
                noteOctave = 4.0f;
            }
            float midiNote = noteOctave * 12.0f + 12.0f;
            Minim.debug("midiNote based on octave = " + midiNote);
            pattern = Pattern.compile(noteNaturalnessRegex);
            matcher = pattern.matcher(pitchName);
            while (matcher.find()) {
                String naturalnessString = pitchName.substring(matcher.start(), matcher.end());
                if (naturalnessString.equals("#")) {
                    midiNote += 1.0f;
                    continue;
                }
                midiNote -= 1.0f;
            }
            Minim.debug("midiNote based on naturalness = " + midiNote);
            pattern = Pattern.compile(noteNameRegex);
            matcher = pattern.matcher(pitchName);
            if (matcher.find()) {
                String noteNameString = pitchName.substring(matcher.start(), matcher.end());
                float noteOffset = noteNameOffsets.get(noteNameString).intValue();
                midiNote += noteOffset;
            }
            Minim.debug("midiNote based on noteName = " + midiNote);
            return new Frequency(Frequency.ofMidiNote(midiNote).asHz());
        }
        Minim.debug(pitchName + " DOES NOT MATCH.");
        return new Frequency(0.0f);
    }
}

