#version 150

#ifdef GL_ES
precision highp float;
#endif
//UNIVERSAL UNIFORMS
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D feedback;
uniform sampler2D render;


vec3 luminanceVector = vec3(0.2125, 0.7154 , 0.0721);
#define pi 3.14159264359
float cir(vec2 uv,vec2 p, float s,float d);
vec4 manodraw(vec2 uv,vec2 p);
float def(vec2 uv,vec2 p1,vec2 p2,float f);

float mapr(float _value,float _low2,float _high2) {
	float val = _low2 + (_high2 - _low2) * (_value - 0.) / (1.0 - 0.);
    //float val = 0.1;
	return val;
}




mat2 scale(vec2 _scale){
    return mat2(_scale.x,0.0,
                0.0,_scale.y);
}
mat2 rotate2d(float _angle){
    return mat2(cos(_angle),-sin(_angle),
                sin(_angle),cos(_angle));
}

vec3 lm(vec3 col, vec3 mx, vec3 dec){
	if(col.r > mx.r){
		col.r -=dec.r;
	}
	
	if(col.g > mx.g){
		col.g -=dec.g;
	}
	if(col.b > mx.b){
		col.b -=dec.b;
	}
	
	return col;
}

mat2 scale(vec2 _scale);
mat2 rotate2d(float _angle);
float atan2(float x,float y);
float random (in vec2 _st);
float cir(vec2 uv,vec2 p, float s, float d);
float noise (in vec2 st,float fase);
vec3 mod289(vec3 x) { return x - floor(x * (1.0 / 289.0)) * 289.0; }
vec2 mod289(vec2 x) { return x - floor(x * (1.0 / 289.0)) * 289.0; }
vec3 permute(vec3 x) { return mod289(((x*34.0)+1.0)*x); }
float snoise(vec2 v);
vec3 rgb2hsb( in vec3 c );
vec3 hsb2rgb( in vec3 c );
float poly(vec2 uv,vec2 p, float s, float d,int N,float a);
vec2 lerp(vec2 p1,vec2 p2,float f);

out vec4 fragColor;
#define PI 3.14159265359
#define TWO_PI 6.28318530718

vec2 lerp(vec2 p1,vec2 p2,float f){
	vec2 e = p1 * f + p2 *(1.-f);
	return e;
}
float def(vec2 uv,vec2 p1,vec2 p2,float f){
	
	float e=0.;
	
	float cant = 5;
	for (int i=1; i<cant; i++){
		vec2 mid = lerp(p1,p2,i/cant) -fract(uv);
		float r = length(mid);
		float a = atan(mid.x,mid.y);
		e+=sin(r*pi*20+time+f+sin(r*pi*2.+mid.x*pi*2.*sin(uv.y*pi*2.)+time*2.));
		
	}
	
	
	return abs(e*0.2);
}

vec4 manodraw(vec2 uv,vec2 p){
	
	//ESTE PARA TIRARLE 
	vec2 p2 = p - uv;
	float r = length(p2);
	float a = atan(p2.x,p2.y);
	
	float size = 0.7;
	float em = sin(r*pi*100.+sin(a*5.+time+sin(r*40.+time*2.)*5.)*2.+time*5.);
	float r2 = cir(uv,p,0.0,0.15*size+em*0.05*size)*1.5;
	float g2 = cir(uv,p,0.0,0.1*size+em*0.005*size);
	float b2 = cir(uv,p,0.0,0.1*size+sin(em*50.*size)*0.01)*5.;
	
	return vec4(r2,g2,b2,1.0)*0.5;
}

float cir(vec2 uv,vec2 p,float s, float d){
	
	vec2 p2 = p - uv;
	float a = atan(p2.x,p2.y);
	float r = length(p2);
	
	float e = 1.-smoothstep(s,s+d,r);
	return e;
}

float poly(vec2 uv,vec2 p, float s, float dif,int N,float a){
    
    // Remap the space to -1. to 1.
    
    vec2 st = p - uv ;
    
    
    // Angle and radius from the current pixel
    float a2 = atan(st.x,st.y)+a;
    float r = TWO_PI/float(N);
    
    float d = cos(floor(.5+a2/r)*r-a2)*length(st);
    float e = 1.0 - smoothstep(s,dif,d);
      
    return e;
}


float atan2(float x,float y){
    if(x>0){
        return atan(y/x);
    } else if (x< 0 && y >= 0){
        return atan(y/x)+PI;
    } else if (x < 0 && y < 0){
        return atan(y/x)-PI;
    }else if(x == 0 && y > 0){
        return PI/2;
    } else if(x == 0 && y<0){
        return -PI/2;
    }else{
        return 0;
    }
}

float random2 (in vec2 _st,float _time) {
    return fract(sin(dot(floor(_st.xy),
                         vec2(12.9898,78.233)))*
        43000.3+_time);
}
float random2 (in vec2 _st) {
    return fract(sin(dot(floor(_st.xy),
                         vec2(12.9898,78.233)))*
        43000.3);
}

float random (in vec2 _st) {
    return fract(sin(dot(_st.xy,
                         vec2(12.9898,78.233)))*
        43758.56222123);
}

float sin2(float f){
    return sin(f)*0.5+0.5;
}

float cos2(float f){
    return cos(f)*0.5+0.5;
}



float rad(vec2 uv){
    return length(vec2(0.5)-uv);
    
    

}

float ang(vec2 uv){
    return atan((vec2(0.5)-uv).x,(vec2(0.5)-uv).y);
}

float rad(vec2 uv,vec2 p){
    vec2 p2 = p -uv;
    float r = length(p2);
    return r;
}

float ang(vec2 uv,vec2 p){
    vec2 p2 = p -uv;
    float a = atan(p2.x,p2.y);
    return a;
}
float noise (in vec2 st,float fase) {
    vec2 i = floor(st);
    vec2 f = fract(st);
    
    float fase2 = fase;
    // Four corners in 2D of a tile
    float a = sin(random(i)*fase2);
    float b =  sin(random(i + vec2(1.0, 0.0))*fase2);
    float c =  sin(random(i + vec2(0.0, 1.0))*fase2);
    float d =  sin(random(i + vec2(1.0, 1.0))*fase2);

    // Smooth Interpolation

    // Cubic Hermine Curve.  Same as SmoothStep()
    vec2 u = f*f*(3.0-2.0*f);
    // u = smoothstep(0.,1.,f);

    // Mix 4 coorners percentages
    return mix(a, b, u.x) +
            (c - a)* u.y * (1.0 - u.x) +
            (d - b) * u.x * u.y;
}

float noise (in vec2 _st) {
    vec2 i = floor(_st);
    vec2 f = fract(_st);

    // Four corners in 2D of a tile
    float a = random(i);
    float b = random(i + vec2(1.0, 0.0));
    float c = random(i + vec2(0.0, 1.0));
    float d = random(i + vec2(1.0, 1.0));

    vec2 u = f * f * (3.0 - 2.0 * f);

    return mix(a, b, u.x) +
            (c - a)* u.y * (1.0 - u.x) +
            (d - b) * u.x * u.y;
}
float snoise(vec2 v) {

    // Precompute values for skewed triangular grid
    const vec4 C = vec4(0.211324865405187,
                        // (3.0-sqrt(3.0))/6.0
                        0.366025403784439,
                        // 0.5*(sqrt(3.0)-1.0)
                        -0.577350269189626,
                        // -1.0 + 2.0 * C.x
                        0.024390243902439);
                        // 1.0 / 41.0

    // First corner (x0)
    vec2 i  = floor(v + dot(v, C.yy));
    vec2 x0 = v - i + dot(i, C.xx);

    // Other two corners (x1, x2)
    vec2 i1 = vec2(0.0);
    i1 = (x0.x > x0.y)? vec2(1.0, 0.0):vec2(0.0, 1.0);
    vec2 x1 = x0.xy + C.xx - i1;
    vec2 x2 = x0.xy + C.zz;

    // Do some permutations to avoid
    // truncation effects in permutation
    i = mod289(i);
    vec3 p = permute(
            permute( i.y + vec3(0.0, i1.y, 1.0))
                + i.x + vec3(0.0, i1.x, 1.0 ));

    vec3 m = max(0.5 - vec3(
                        dot(x0,x0),
                        dot(x1,x1),
                        dot(x2,x2)
                        ), 0.0);

    m = m*m ;
    m = m*m ;

    // Gradients:
    //  41 pts uniformly over a line, mapped onto a diamond
    //  The ring size 17*17 = 289 is close to a multiple
    //      of 41 (41*7 = 287)

    vec3 x = 2.0 * fract(p * C.www) - 1.0;
    vec3 h = abs(x) - 0.5;
    vec3 ox = floor(x + 0.5);
    vec3 a0 = x - ox;

    // Normalise gradients implicitly by scaling m
    // Approximation of: m *= inversesqrt(a0*a0 + h*h);
    m *= 1.79284291400159 - 0.85373472095314 * (a0*a0+h*h);

    // Compute final noise value at P
    vec3 g = vec3(1);
    g.x  = a0.x  * x0.x  + h.x  * x0.y;
    g.yz = a0.yz * vec2(x1.x,x2.x) + h.yz * vec2(x1.y,x2.y) ;
    return 20.0 * dot(m, g);
}

vec3 rgb2hsb( in vec3 c ){
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz),
                 vec4(c.gb, K.xy),
                 step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r),
                 vec4(c.r, p.yzx),
                 step(p.x, c.r));
    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)),
                d / (q.x + e),
                q.x);
}

//  Function from Iñigo Quiles
//  https://www.shadertoy.com/view/MsS3Wc
vec3 hsb2rgb( in vec3 c ){
    vec3 rgb = clamp(abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),
                             6.0)-3.0)-1.0,
                     0.0,
                     1.0 );
    rgb = rgb*rgb*(3.0-2.0*rgb);
    return c.z * mix(vec3(1.0), rgb, c.y);
}


float heart(vec2 st, vec2 translate, float radius, float smoothRange)
{
    vec2 uv = st - translate;
    
    // Two partially overlapping circles for the +ve y quadrants
    float top = step(0.0, uv.y) * (smoothstep(radius + 0.025, radius + 0.025 - smoothRange, length(abs(uv) - vec2(radius - 0.025,0.0))));
        
    // Two symmetric sin curves for the -ve y quadrants
    uv.x = abs(uv.x);
    
    float bottom = step(-PI, uv.y * PI) * step(0.0, -uv.y) * 
        smoothstep(0.0, smoothRange, (radius * sin(uv.y * PI + PI / 2.0) - uv.x + 1.0 * radius));
    
    // Put them all together
    return top + bottom;
}
float heart2(in vec2 pt, in float radius) {
    float x = pt.x / radius * 0.75;
    float y = pt.y / radius;
    float r = pow(x, 2.0) + pow(y+0.5 - sqrt(abs(x)), 2.0);
    return smoothstep(r-0.4, r+0.4, 2.0);
}

float ridge(float h, float offset) {
    h = abs(h);     // create creases
    h = offset - h; // invert so creases are at top
    h = h * h;      // sharpen creases
    return h;
}



float ridgedMF(vec2 p) {
    float lacunarity = 2.0;
    float gain = 0.5;
    float offset = 0.9;

    float sum = 0.0;
    float freq = 1.0, amp = 0.5;
    float prev = 1.0;
    for(int i=0; i < 10; i++) {
        float n = ridge(snoise(p*freq), offset);
        //float n = ridge(snoise(p),offset);
		sum += n*amp;
        sum += n*amp*prev;  // scale by previous octave
        prev = n;
        freq *= lacunarity;
        amp *= gain;
    }
    return sum;
}


float rxr(vec2 uv){
    float e = 0;
    e = ridgedMF(vec2(ridgedMF(vec2(uv.x,uv.y))));    
    return e;
}

/*float mapr(float _value,float _low2,float _high2) {
	float val = _low2 + (_high2 - _low2) * (_value - 0.) / (1.0 - 0.);
    //float val = 0.1;
	return val;
}*/

void main(void)
{   
    vec2 uv = gl_FragCoord.xy/resolution.xy;
	
	vec3 dib = vec3(0.0);
	
	vec2 uv2 = uv;
	
	//uv2 = fract(uv2*2.0);
	uv2 -=vec2(0.5);
	uv2 = scale(vec2(0.99))*uv2;
	uv2 +=vec2(0.5);
	
	vec4 ren = texture2D(render,uv);
	vec4 prev = texture2D(feedback,uv2);
	//vec4 ren2 = texture2D(render,uv2);
	
	float lm = 0.8;
	dib =ren.rgb +prev.rgb*0.9;
	
	if(dib.r > lm || dib.g > lm || dib.b > lm){
		dib = ren.rgb;
	}else{
		dib = prev.rgb*1.0;
	}
	//dib = prev.rgb;
	vec3 fin = dib;
	gl_FragColor = vec4(fin,1.0);
}
