/*
 * This is a stripped down starter code for the
 * Assembly Summer 2019 Demo Coding Workshop
 * The original invitation code is very educational:
 * https://github.com/mrautio/graffathon19-demo-one-scene 
 */

// We suggest you use these libraries (and no others):
// Moonlander is a library for integrating Processing with GNU Rocket, https://github.com/anttihirvonen/moonlander
// GNURocket is a tool for synchronizing music and visuals in demoscene productions: https://github.com/rocket/rocket
import moonlander.library.*;
// Audio library for playing sound, http://code.compartmental.net/minim/
import ddf.minim.*;

// Some demo global variables 

// the time in seconds (will be taken from Moonlander / GNURocket every frame)
float now = 0.0;

// These control how big the opened window is.
// But you don't need not change these to develop in a smaller window!
// In fact, DON'T CHANGE THESE. They are optimal for Assembly 2019 Compo.
// ref. https://www.assembly.org/summer19/demoscene/rules
float CANVAS_WIDTH = 1920;
float CANVAS_HEIGHT = 1080;

Moonlander moonlander;
PImage img;
PFont font;
PFont font2;

/*
 * Initialize the window
 */
void settings() {
  boolean fullscreen = true;
  
  if (fullscreen) {
    //Set the window fullscreen in desktop's native resolution
    fullScreen(P3D);
  } else {
    //open in a smaller window
    //Put some 16:9 aspect ratio resolution
    //like 800x450... do not edit CANVAS_WIDTH or CANVAS_HEIGHT
    size((int)800,(int)450, P3D);
  }
}

/*
 * Set up, and load all assets in the demo.
 * Make sure you include everything in the "data/" directory 
 * with your entry, and that the license of each asset allows
 * you to use it in this compo!
 */
void setup() {
  img = loadImage("space.png");
  
  font = createFont("SFButtacupLetteringShaded.ttf", 36);
  font2 = createFont("SFButtacupLettering.ttf", 36);

  // hide mouse cursor; you want to do this.
  noCursor();

  // Init & start moonlander
  int bpm = 124; // Tune's beats per minute. Set this according to your song.
  int rowsPerBeat = 4; // How many rows one beat consists of in the sync editor (GNURocket or so)
  moonlander = Moonlander.initWithSoundtrack(this, "Cephalopod.mp3", bpm, rowsPerBeat);
  moonlander.start();
  
  // Assembly has 60Hz maximum projector framerate, ref. https://www.assembly.org/summer19/demoscene/rules
  int fps = 60;
  frameRate(fps);  
}

void drawImg() {
  float back = (float)moonlander.getValue("img:back"); 
  
  pushMatrix();
  translate(0, 0, back);
 imageMode(CENTER);
  image(img, 0, 0, CANVAS_WIDTH+600, CANVAS_HEIGHT+600);
  popMatrix();
}

void drawThings() {
  pushMatrix();
  
  float x1 = (float)moonlander.getValue("line:x1");
  float y1 = (float)moonlander.getValue("line:y1");
  float x2 = (float)moonlander.getValue("line:x2");
  float y2 = (float)moonlander.getValue("line:y2");
  float show = (float)moonlander.getValue("line:draw");
  float lr = (float)moonlander.getValue("line:red");
  float lb = (float)moonlander.getValue("line:blue");
 
 strokeWeight(1.5);
 
 if(show > 0){
    for(int i=0; i < 15; i++){
      stroke(lr, 255, lb, show);
      line(960, -540, (0+50*i)+x1, 540+y1);
    }
    
    
    for(int i=0; i < 15; i++){
      stroke(lb, 255, lr, show);
      line(-960, 540, (0-50*i)+x2, -540+y2);
    }
 }   
  popMatrix();
}

/*
 * The rotating spheres
 */
void drawMyStuff() {
  
  float s = (float)moonlander.getValue("sphere:size");
  float n = (float)moonlander.getValue("sphere:number");
  float r = (float)moonlander.getValue("sphere:red");
  float g = (float)moonlander.getValue("sphere:green");
  float b = (float)moonlander.getValue("sphere:blue"); 
  
  for(int i=0; i < 30; i++){
    pushMatrix();
   rotateZ(now);
    translate(0, 5, 150);
    if(i%2 == 0){
      stroke(r, g, b, 10-(s/10));
      strokeWeight(i*5);
    }else {
      stroke(255, 255, 255, 100-(s/10));
      strokeWeight(1);
    }
    noFill();
     circle(0, -150, (i*20)*(s/100));
    popMatrix();
  }
  
}


void drawMoreLines() {
  
  float d1 = 1.3*(float)moonlander.getValue("wave:d1");
  float d2 = (float)moonlander.getValue("wave:d2");
  float lines = (float)moonlander.getValue("wave:lines");
  
  if(d1 != 0 && d2 != 0){   
    noFill();
    
    for(int i=0 ; i < lines ; i++){
      pushMatrix();
      stroke(255-(i*10), 255-(i*50), 255-(i*30), lines*30);
      strokeWeight(i*1.5);
      bezier(-960, -400+(i*60), d1, d1, d2, d2, 960, -200+(i*30));
      popMatrix();
     }    
  }
}

void drawString(){
  float a = (float)moonlander.getValue("text: alpha");
  float a2 = (float)moonlander.getValue("text: alpha2");
  
  float s = (float)moonlander.getValue("text: size");
  float s2 = (float)moonlander.getValue("text: size2");
  
  pushMatrix();
  String string = "By GroovyOtter";
  fill(255, 255, 255, a2);
  textFont(font);
  textSize(s);
  text(string, -300, -100, 800, 400);
  popMatrix();
  
  pushMatrix();
  String string2 = "Music \"Cephalopod\" Kevin MacLeod (incompetech.com) Licensed under Creative Commons: By Attribution 4.0 License http://creativecommons.org/licenses/by/4.0/";
  fill(255, 255, 255, a);
  textFont(font2);
  textSize(s2);
  text(string2, -400, -100, 1000, 800);
  popMatrix();
}

/* 
 * This function is called every time a screen is drawn, ideally that would be 60 times per second
 */
void draw() {
  // update Rocket sync data  
  moonlander.update();

  now = (float)moonlander.getCurrentTime();
  float end = 34.7; //end production after 60 secs which is the maximum time allowed by the One Scene Compo
  if (now > end) {
    exit();
  }
  
  // Set the background color
  background((int)(moonlander.getValue("bg:r") * 255),
             (int)(moonlander.getValue("bg:g") * 255),
             (int)(moonlander.getValue("bg:b") * 255),
             (int)(moonlander.getValue("bg:a") * 255));
  
  /*
   * Center coordinates to screen and make the window and canvas resolution independent
   * This is because actual window in full screen on a 4K monitor has more pixels than FullHD resolution
   * so scaling is needed to ensure that all objects (3D and 2D) are in correct places regardless of the desktop resolution
   */
  translate(width/2, height/2, 0);
  scale(width/CANVAS_WIDTH,height/CANVAS_HEIGHT,width/CANVAS_WIDTH);

  // Enable lights and depth testing to ensure that 3D meshes are drawn in correct order
  lights();
  hint(ENABLE_DEPTH_TEST);

drawImg();

  drawThings();
  drawMoreLines();
  if(now > 28){
    drawString();
  }
  
  drawMyStuff();
}
