
import moonlander.library.*;
import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;

Minim minim;
AudioPlayer song;

AudioMetaData meta;
Moonlander moonlander;
float ssize = height*2;
color bgc;
FFT fft;

void setup(){
 frameRate(60);
noCursor();
 
fullScreen();

moonlander = new Moonlander(this, new TimeController(4));
moonlander.start("localhost", 1338, "data/syncdata.rocket");
 
 minim = new Minim(this);
 song = minim.loadFile("hypnosis.mp3", 512);
 song.play();
 meta = song.getMetaData();
 fft = new FFT(song.bufferSize(), song.sampleRate());
  
colorMode(HSB, 100, 100, 100);
bgc = color(0,0,0);
background(bgc);
}
 
void draw(){ 
translate(width/2, height/2);

moonlander.update();
float t = (float)moonlander.getValue("time");
float y6 = 1;
float x6 = 1; 
float hue1 = 15;

   float highest =1;
   for(int i = 50; i < 100; i++){
    if(highest<song.left.get(i)*50) {
      highest=song.left.get(i)*50;
    }
  }
  
float muutt = 4/10;
rotate (t/300);
int i = 1;
float numberx =350;
 
pushMatrix();
strokeWeight(1);  
for (i=1;i<numberx;i++){

x6 = cos(i*muutt + t/90) * (t/350);
y6 = sin(i*muutt + t/90) * (sin(i/2)) ;
  stroke(0,0,0); 
 
for(int j=0;j<6;j++){
   point (x6*(-ssize) -ssize + highest, y6*ssize + highest); 
    rotate(PI/3); 
 } 
 }
 
for (i=1;i<numberx;i++){
x6 = cos(i*muutt + t/90) * (t/350);
y6 = sin(i*muutt + t/90) * (sin(i/2)) ;
 hue1 = 11 +(t/120);
if(i<(numberx/3)){
   hue1 += 17;
}

for(int v=0;v<6;v++){ 
  stroke(hue1+(v*4),80,100); 
  point (x6*(-ssize) -ssize  , y6*ssize );  
  rotate(PI/3);
}
 
}
popMatrix();

 if (keyPressed) { 
     if (key == 27) { 
       exit(); 
     }
}
}  
