//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID8be964c6_63ab_4fce_9fb9_4b22359815c0
{
    public class Class_crossprocessingBetter : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            ShowClamped = 2,
            ColorRamp = 3
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var ShowClamped = inputs[(int)InputId.ShowClamped].Eval(context).Value;
            var ColorRamp = inputs[(int)InputId.ColorRamp].Eval(context).Image; // Needs to be checked for null!
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));


                if(Image != null) {

                    //>>> _setup
                    using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                    using (var ColorRampView = new ShaderResourceView(context.D3DDevice, ColorRamp))
                    {
                        _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                        _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                        _effect.GetVariableByName("ShowClamped").AsScalar().Set(ShowClamped);
                        _effect.GetVariableByName("ColorRamp").AsShaderResource().SetResource(ColorRampView);
                    //<<< _setup
                    
                    _effect.GetVariableByName("UpdateCount").AsScalar().Set(_updateCount++);
    
                    Render(context);
                    }
                    //>>> _cleanup
                    }
                //<<< _cleanup
            });
        }
        
        int _updateCount;

    }
}

