//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDf78aeed9_6573_416d_8029_ebe9d0fe7e49
{
    public class Class_Waveform : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            UpperLimit = 2,
            SampleCount = 3,
            Original = 4,
            RGB = 5,
            GrayScale = 6,
            Lines = 7,
            GuideAt = 8
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var UpperLimit = inputs[(int)InputId.UpperLimit].Eval(context).Value;
            var SampleCount = inputs[(int)InputId.SampleCount].Eval(context).Value;
            var Original = inputs[(int)InputId.Original].Eval(context).Value;
            var RGB = inputs[(int)InputId.RGB].Eval(context).Value;
            var GrayScale = inputs[(int)InputId.GrayScale].Eval(context).Value;
            var Lines = inputs[(int)InputId.Lines].Eval(context).Value;
            var GuideAt = inputs[(int)InputId.GuideAt].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("UpperLimit").AsScalar().Set(UpperLimit);
                    _effect.GetVariableByName("SampleCount").AsScalar().Set(SampleCount);
                    _effect.GetVariableByName("Original").AsScalar().Set(Original);
                    _effect.GetVariableByName("RGB").AsScalar().Set(RGB);
                    _effect.GetVariableByName("GrayScale").AsScalar().Set(GrayScale);
                    _effect.GetVariableByName("Lines").AsScalar().Set(Lines);
                    _effect.GetVariableByName("GuideAt").AsScalar().Set(GuideAt);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

