using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID6c4f1407_27bf_47cd_a833_c962c48293b8
{
    public class Class_Shear : OperatorPart.Function
    {
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            var SceneInput = inputs[0]; 
            var ShearX = (float) inputs[1].Eval(context).Value;
            var ShearY = (float) inputs[2].Eval(context).Value;
            var ShearZ = (float) inputs[3].Eval(context).Value;

            Matrix m = Matrix.Identity;
            
            m.M12=(float)(ShearX); 
            m.M13=(float)(ShearY); 
            m.M14=(float)(ShearZ); 

            var prevTransform = context.ObjectTWorld;
            context.ObjectTWorld = m * prevTransform;
            var result = SceneInput.Eval(context);
            context.ObjectTWorld = prevTransform;

            return context;

        }
    }
}
