using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using SharpDX;
using SharpDX.Direct3D11;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.ID67bdc453_a227_45c3_afd0_f7d3f80107d0
{
    public class Class_NormalShader : FXSourceCodeFunction, IFXSceneSourceCode, IMaterial
    {

        class Renderer : BaseRenderer
        {
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            ColorR = 2
        }
        //<<< _inputids
        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            //<<< _params
        
            if (_firstEval) {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            
            var prevEffect = context.Effect;
            var prevRenderer = context.Renderer;
            context.Effect = _effect;
            context.Renderer = _renderer;

            var prevMaterial = (IMaterial) context.Objects[OperatorPartContext.MATERIAL_ID];
            context.Objects[OperatorPartContext.MATERIAL_ID] = this;
           
           
           _effect.GetVariableByName("Color").AsVector().Set(new Vector4(1, 1, 1,1)); 
           
            Scene.Eval(context);
            context.Objects[OperatorPartContext.MATERIAL_ID] = prevMaterial;
            context.Effect = prevEffect;
            context.Renderer = prevRenderer;

            return context;
        }

        private Renderer _renderer = new Renderer();

        public Color4 Ambient { get; private set; }
        public Color4 Diffuse { get; private set; }
        public Color4 Specular { get; private set; }
        public Color4 Emission { get; private set; }
        public float Shininess { get; private set; }
    }
}


