var email = {"v":"jumalauta@jumalauta.org", "size":128};

var Menu = function() {
    email.v = "";
    this.input = new Input();

    this.mute = {"v":Settings.audio.mute};
    this.fullscreen = {"v":Settings.window.fullscreen};
    this.displayModeSelect = void null;

    this.consent = {"v":false};

    this.displayModes = getDisplayModes();

    this.displayModeList = "";
    for (var i in this.displayModes) {
        var dm = this.displayModes[i];
        this.displayModeList += dm.width + "x" + dm.height + "\0";

        if (dm.width == Settings.demo.graphics.canvasWidth && dm.height == Settings.demo.graphics.canvasHeight) {
            this.displayModeSelect = {"v": i};
        }
    }

    if (this.displayModeSelect === void null) {
        this.displayModeSelect = {"v": 0};
    }

    this.displayModeList += "\0";

}
Menu.prototype.setQuit = function(quit) {
    menuSetQuit(quit);
}
Menu.prototype.getWidth = function() {
    return menuGetWidth();
}
Menu.prototype.getHeight = function() {
    return menuGetHeight();
}
Menu.prototype.render = function() {
    ImGui.SetNextWindowPos({"x":0, "y":0}, ImGui.SetCond.Always);
    ImGui.SetNextWindowSize({"x":this.getWidth(), "y":this.getHeight()}, ImGui.SetCond.Always);

    ImGui.PushStyleVar(ImGui.StyleVar.WindowRounding, 0);
    ImGui.Begin("", {"v":true},
      ImGui.WindowFlags.NoSavedSettings
      | ImGui.WindowFlags.NoTitleBar
      | ImGui.WindowFlags.NoResize
      | ImGui.WindowFlags.NoMove
      | ImGui.WindowFlags.NoCollapse);
    var flags = ImGui.WindowFlags.NoResize;

    ImGui.SetWindowFontScale(3.0);

    ImGui.Combo("", this.displayModeSelect, this.displayModeList);

    ImGui.Checkbox("fullscreen", this.fullscreen);
    ImGui.SameLine();
    ImGui.Checkbox("mute", this.mute);

    ImGui.Checkbox("Jumalauta Opt-in", this.consent);
    ImGui.InputText("Email address", email);
    //ImGui.SameLine();

    if ((ImGui.Button("Start") || ImGui.IsKeyPressed(ImGui.GetKeyIndex(ImGui.Key.Enter), true)) && this.consent.v && email.v !== void null && email.v.length > 5) {
        var displayMode = this.displayModes[this.displayModeSelect.v];

        Settings.audio.mute = this.mute.v;
        Settings.window.fullscreen = this.fullscreen.v;

        // Send Settings modified in JS to backend
        settingsLoadSettingsFromString(JSON.stringify(Settings, null, 2));
        settingsDemoLoadDemoSettingsFromString(JSON.stringify(Settings.demo, null, 2));

        settingsWindowSetWindowDimensions(displayMode.width, displayMode.height);

        this.setQuit(false); // i.e. let's continue and show the demo
        this.input.setUserExit(true);
    }
    ImGui.SameLine();
    if (ImGui.Button("Exit")) {
        this.input.setUserExit(true);
    }

    ImGui.End();
    ImGui.PopStyleVar();

    ImGui.Render();
}
