/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;

public class Noise
extends UGen {
    public UGen.UGenInput amplitude;
    public UGen.UGenInput offset;
    private Tint tint;
    private float lastOutput;
    private float brownCutoffFreq = 100.0f;
    private float brownAlpha;
    private float brownAmpCorr = 6.2f;
    private int maxKey;
    private int key;
    private int range;
    private float[] whiteValues;
    private float maxSumEver;

    public Noise() {
        this(1.0f, 0.0f, Tint.WHITE);
    }

    public Noise(float amplitude) {
        this(amplitude, 0.0f, Tint.WHITE);
    }

    public Noise(Tint noiseType) {
        this(1.0f, 0.0f, noiseType);
    }

    public Noise(float amplitude, Tint noiseType) {
        this(amplitude, 0.0f, noiseType);
    }

    public Noise(float amplitude, float offset, Tint noiseType) {
        this.amplitude = this.addControl(amplitude);
        this.offset = this.addControl(offset);
        this.lastOutput = 0.0f;
        this.tint = noiseType;
        if (this.tint == Tint.PINK) {
            this.initPink();
        }
    }

    public void setTint(Tint noiseType) {
        if (this.tint != noiseType) {
            if (noiseType == Tint.PINK) {
                this.initPink();
            }
            this.tint = noiseType;
        }
    }

    public final Tint getTint() {
        return this.tint;
    }

    @Override
    protected void sampleRateChanged() {
        float dt = 1.0f / this.sampleRate();
        float RC = 1.0f / ((float)Math.PI * 2 * this.brownCutoffFreq);
        this.brownAlpha = dt / (RC + dt);
    }

    @Override
    protected void uGenerate(float[] channels) {
        float n;
        float outAmp = this.amplitude.getLastValue();
        switch (this.tint) {
            case BROWN: 
            case RED: {
                n = outAmp * (2.0f * (float)Math.random() - 1.0f);
                this.lastOutput = n = this.brownAlpha * n + (1.0f - this.brownAlpha) * this.lastOutput;
                n *= this.brownAmpCorr;
                break;
            }
            case PINK: {
                n = outAmp * this.pink();
                break;
            }
            default: {
                n = outAmp * (2.0f * (float)Math.random() - 1.0f);
            }
        }
        n += this.offset.getLastValue();
        for (int i = 0; i < channels.length; ++i) {
            channels[i] = n;
        }
    }

    private void initPink() {
        this.maxKey = 31;
        this.range = 128;
        this.maxSumEver = 90.0f;
        this.key = 0;
        this.whiteValues = new float[6];
        for (int i = 0; i < 6; ++i) {
            this.whiteValues[i] = (float)Math.random() * 9.223372E18f % (float)(this.range / 6);
        }
    }

    private float pink() {
        int last_key = this.key++;
        if (this.key > this.maxKey) {
            this.key = 0;
        }
        int diff = last_key ^ this.key;
        float sum = 0.0f;
        for (int i = 0; i < 6; ++i) {
            if ((diff & 1 << i) != 0) {
                this.whiteValues[i] = (float)Math.random() * 9.223372E18f % (float)(this.range / 6);
            }
            sum += this.whiteValues[i];
        }
        if (sum > this.maxSumEver) {
            this.maxSumEver = sum;
        }
        sum = 2.0f * (sum / this.maxSumEver) - 1.0f;
        return sum;
    }

    public static enum Tint {
        WHITE,
        PINK,
        RED,
        BROWN;

    }
}

