/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.Minim;
import ddf.minim.UGen;

public class BitCrush
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput bitRes = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput bitRate;
    float[] sampledFrame;
    int sampleCounter;

    public BitCrush() {
        this(1.0f, 44100.0f);
    }

    public BitCrush(float localBitRes, float localBitRate) {
        this.bitRes.setLastValue(localBitRes);
        this.bitRate = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.bitRate.setLastValue(localBitRate);
        this.sampledFrame = new float[this.channelCount()];
    }

    @Override
    protected void channelCountChanged() {
        this.sampledFrame = new float[this.channelCount()];
        this.sampleCounter = 0;
    }

    public void setBitRes(float localBitRes) {
        this.bitRes.setLastValue(localBitRes);
    }

    @Override
    protected void uGenerate(float[] out) {
        if (this.sampleCounter <= 0) {
            if (this.audio.getLastValues().length != this.channelCount()) {
                Minim.error("BitCrush audio has " + this.audio.getLastValues().length + " channels and sampledFrame has " + this.channelCount());
            }
            System.arraycopy(this.audio.getLastValues(), 0, this.sampledFrame, 0, this.channelCount());
            this.sampleCounter = (int)(this.sampleRate() / Math.max(this.bitRate.getLastValue(), 1.0f));
        }
        int res = 1 << (int)this.bitRes.getLastValue();
        for (int i = 0; i < out.length; ++i) {
            int samp = (int)((float)res * this.sampledFrame[i]);
            out[i] = (float)samp / (float)res;
        }
        --this.sampleCounter;
    }
}

