/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.values.LabelReferenceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;
import java.util.Map;

public class NameSpaceValue
extends LabelReferenceValue {
    private String id;
    private Scope scope;
    private boolean alsoLabel = false;

    public NameSpaceValue(String string, boolean bl) {
        this.id = string;
        this.alsoLabel = bl;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Value deReference() {
        return this;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isAlsoLabel() {
        return this.alsoLabel;
    }

    @Override
    public Object getRepresentation(int n) {
        if (this.alsoLabel) {
            return super.getRepresentation(n);
        }
        return null;
    }

    @Override
    public FunctionTable getFunctions() {
        if (this.alsoLabel) {
            return super.getFunctions();
        }
        return NameSpaceValue.getStandardFunctions();
    }

    @Override
    public boolean isInvalid() {
        if (this.alsoLabel) {
            return super.isInvalid();
        }
        return false;
    }

    @Override
    public boolean hasInvalidContent() {
        if (this.alsoLabel) {
            return super.hasInvalidContent();
        }
        return false;
    }

    @Override
    public String getType() {
        return this.isInvalid() ? "Invalid Namespace" : "Namespace";
    }

    @Override
    protected Value localGetVariable(String string, DebugInfo debugInfo) {
        boolean bl;
        Map map = this.scope.getSymbols().getLocalDefinedEntities();
        SymbolScopeValue symbolScopeValue = (SymbolScopeValue)map.get(string);
        boolean bl2 = bl = symbolScopeValue instanceof LabelReferenceValue || symbolScopeValue instanceof NameSpaceValue;
        if (bl) {
            return symbolScopeValue;
        }
        if (this.alsoLabel) {
            return super.localGetVariable(string, debugInfo);
        }
        return null;
    }

    @Override
    public void setValue(Value value, EvaluationState evaluationState, DebugInfo debugInfo) {
        throw new AsmError("Can't assign a new value to a label/namespace", debugInfo);
    }
}

