/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SESymbolDeclaration;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.ConstantReferenceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;

public class ConstDeclaration
extends ExprNode {
    private String name;
    private ExprNode expr;

    public ConstDeclaration(String string, ExprNode exprNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
        this.expr = exprNode;
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope().getSymbols();
        SymbolScopeValue symbolScopeValue = (SymbolScopeValue)symbolScope.getLocalDefinedEntities().get(this.name);
        if (symbolScopeValue != null) {
            throw new AsmError("The symbol '" + this.name + "' is already defined", this.debug);
        }
        Value value = this.expr.evaluate(evaluationState).deReference();
        if (value.isInvalidOrInvalidContent()) {
            evaluationState.setInvalidSideEffectsDuringFunctionEvaluation();
        }
        ConstantReferenceValue constantReferenceValue = new ConstantReferenceValue(value);
        symbolScope.put(this.name, constantReferenceValue);
        if (!evaluationState.getFunctionsMode()) {
            SESymbolDeclaration sESymbolDeclaration = new SESymbolDeclaration(this.name, constantReferenceValue, value);
            evaluationState.addSideEffect(sESymbolDeclaration);
        }
        return constantReferenceValue;
    }

    public String toString() {
        return "ConstDeclaration";
    }

    @Override
    public ExprTreeBuilder toNodeTreeString(ExprTreeBuilder exprTreeBuilder) {
        exprTreeBuilder.addNode("ConstDec", this.name, this.expr);
        return exprTreeBuilder;
    }
}

