if (typeof Keyboard === 'undefined') {
	const Keyboard = (function() {
		var keydown = [],
			keyup = [],
			onkeydown = function(code, fun) {
				keydown[code] = fun;
			},
			onkeyup = function(code, fun) {
				keyup[code] = fun;
			},
			isTyping = function() {
				var focus = document.activeElement;
				if (focus !== 'undefined') {
					if (focus.getAttribute('contenteditable') == 'true' ||
						focus.tagName == 'INPUT' ||
						focus.tagName == 'TEXTAREA')
					{
						return true;
					}
					
				}
				return false;
			};
		window.addListener('onkeydown', function(e) {
			var code = (e.keyCode ? e.keyCode : e.which);
			if (!isTyping() && typeof keydown[code] !== 'undefined' && typeof keydown[code] === 'function') {
				keydown[code](e);
			}
		}, false);
		window.addListener('onkeyup', function(e) {
			var code = (e.keyCode ? e.keyCode : e.which);
			if (!isTyping() && typeof keyup[code] !== 'undefined' && typeof keyup[code] === 'function') {
				keyup[code](e);
			}	
		}, false);
		return {
			onkeydown: onkeydown,
			onkeyup: onkeyup,
		};
	})();
}