if (typeof isTouch === 'undefined') {
    var isTouch = "ontouchstart" in document.documentElement;    
}
if (typeof Object.size === 'undefined') {
    Object.prototype.size = function() {
        var size = 0, key;
        for (key in this) {
            if (this.hasOwnProperty(key)) size++;
        }
        return size;
    };
}
if (typeof Element.addListener === 'undefined') {
    Element.prototype.addListener = function(index, fun, override) {
        var oldFun = this[index];
        override = typeof override === 'boolean' ? override : false;
        this.addEventListener(index, fun, override);
        if (this[index] == oldFun) {
            this[index] = function() {
                if (typeof oldFun === 'function') {
                    oldFun.apply(this, arguments);
                }
                fun.apply(this, arguments);
            };
        }
    }
}
if (typeof Window.addListener === 'undefined') {
    Window.prototype.addListener = Element.prototype.addListener;
}
if (typeof Element.getPosX === 'undefined') {
    Element.prototype.getPosX = function() {
        var x = 0,
            obj = this;
        do {
            x += obj.offsetLeft;
        } while(obj = obj.offsetParent);
        return x;
    }
}
if (typeof Element.getPosY === 'undefined') {
    Element.prototype.getPosY = function() {
        var y = 0,
            obj = this;
        do {
            y += obj.offsetTop;
        } while(obj = obj.offsetParent);
        return y;
    }
}
if (typeof Element.addClassName === 'undefined') {
    Element.prototype.addClassName = function() {
        for (var i = 0; i < arguments.length; i++) {
            if (this.className.length === 0) {
                this.className = arguments[i];
            } else if (this.className.search(arguments[i]) === -1) {
                this.className += ' ' + arguments[i];
            }
        }
    }
}
if (typeof Element.removeClassName === 'undefined') {
    Element.prototype.removeClassName = function() {
        for (var i = 0; i < arguments.length; i++) {
            this.className = this.className.replace(' ' + arguments[i], '');
            this.className = this.className.replace(arguments[i], '');
        }
    }
}
if (typeof GET === 'undefined') {
    const GET = (function() {
        var get = {}
        location.search.substr(1).split("&").forEach(function(item) {
            var data = item.split('=');
            if (data.length == 2) {
                get[data[0]] = data[1];
            }
        })
        return get;
    }());
}
(function() {
    window.addListener('load', 
        function(e) {
            var body = document.body,
                btns = document.getElementsByClassName('btn'),
                analogSticks = document.getElementsByClassName('stick'),
                i,
                indicators = document.getElementsByClassName('indicator'),
                log = document.getElementsByClassName("log")[0],
                logScanFun = '',
                preventDefault = function(e) { e.preventDefault(); },
                resize = function(indicator) {
                    var parent = indicator.parentNode,
                        fun = function() {
                        var size = Math.min(parent.offsetWidth, parent.offsetHeight);
                        indicator.style.width = (0.3 * size) + 'px';
                        indicator.style.height = (0.3 * size) + 'px';
                    }
                    parent.addListener('resize', fun, false);
                    window.addListener('resize', fun, false);
                    fun();
                },
                logClick = function() {
                    if (log.getAttribute('contenteditable') === 'true') {
                        setTimeout(function() {
                            var sel, range;
                            if (window.getSelection && document.createRange) {
                                range = document.createRange();
                                range.selectNodeContents(log);
                                sel = window.getSelection();
                                sel.removeAllRanges();
                                sel.addRange(range);
                            } else if (document.body.createTextRange) {
                                range = document.body.createTextRange();
                                range.moveToElementText(log);
                                range.select();
                            }
                            log.scrollIntoView(true);
                        }, 1);
                        return true;
                    }
                    return false;
                };
            body.addEventListener('touchstart', preventDefault, false);
            body.addEventListener('touchmove',  preventDefault, false);
            body.addEventListener('touchend',   preventDefault, false);
            window.addEventListener('resize', function() {
                body.scrollIntoView(true);
            }, false);
            window.addEventListener('rotate', function() {
                body.scrollIntoView(true);
            }, false);
            for (i = 0; i < btns.length; i++) {
                if (typeof btns[i] !== 'undefined') {
                    Btn(btns[i]);
                }
            }
            for (i = 0; i < analogSticks.length; i++) {
                if (typeof analogSticks[i] !== 'undefined') {
                    AnalogStick(analogSticks[i]);
                }
            }
            for (i = 0; i < indicators.length; i++) {
                if (typeof indicators[i] !== 'undefined') {
                    resize(indicators[i]);
                }
            };
            log.addListener('ontouchstart', function() { log.focus(); return logClick(); }, false);
            log.addListener('onfocus', logClick, false);
            log.onkeydown = function(e) {
                if (log.getAttribute('contenteditable') == 'true' && log == document.activeElement) {
                    var code = (e.keyCode ? e.keyCode : e.which);
                    if (code == 13) {
                        log.blur();
                        if (typeof logScanFun === 'function') {
                            logScanFun(log.innerHTML);
                            log.setAttribute('contenteditable', 'false');
                        }
                    } else if (code == 27) {
                        if ( document.selection ) {
                            document.selection.empty();
                        } else if ( window.getSelection ) {
                            window.getSelection().removeAllRanges();
                        }
                        log.blur();
                    } else {
                        log.scrollIntoView(true);
                    }
                    return true;
                }
                return false;
            };
            body.log = function(message, type, duration) {
                var messages = ['', '', ''],
                    i;
                if (log.getAttribute('contenteditable') !== 'true') {
                    type = typeof type === 'string' ? type : '';
                    if (type == 'error') {
                        log.addClassName('error');
                        log.innerHTML = message;
                        return;
                    } else {
                        log.removeClassName('error');
                    }
                    log.setAttribute("active", "true");
                    if (type == 'loading') {
                        if (message.charAt(message.length -1) == '.') {
                            message = message.substr(0, message.length - 1);
                        }
                        messages[0] = message + "&nbsp;&nbsp;&nbsp;";
                        messages[1] = message + ".&nbsp;&nbsp;";
                        messages[2] = message + "..&nbsp;";
                        messages[3] = message + "...";
                        i = 0;
                        log.innerHTML = messages[0];
                        var fun = function() {
                            if (log.getAttribute('contenteditable') !== 'true' && 
                                log.innerHTML == messages[i])
                            {
                                i = (i + 1) % messages.length;
                                log.innerHTML = messages[i];
                                setTimeout(fun, 500);
                            }
                        }
                        setTimeout(fun, 500);
                    } else {
                        log.innerHTML = message;
                    }
                    if (typeof duration !== 'undefined' && duration > 0) {
                        setTimeout(function() {
                            if (log.innerHTML == message) {
                                log.setAttribute("active", "false");
                            }
                        }, duration);
                    }
                }
            };
            body.scan = function(message, fun) {
                if (typeof message === 'string') {
                    log.innerHTML = message;
                    logScanFun = fun;
                }
                log.setAttribute('contenteditable', 'true');
            };
        }, false);
})();
