/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import ddf.minim.analysis.FFT;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PShape;
import processing.opengl.PShader;

public class CevianRaspberry
extends PApplet {
    final boolean FULLSCREEN = false;
    final boolean SHOW_EQ = false;
    final boolean SHOW_PALETTE = false;
    final String SONGNAME = "MineX - Raspberry (Short Edit).mp3";
    final int WINDOWED_SIZE_X = 1280;
    final int WINDOWED_SIZE_Y = 720;
    final int FPS = 35;
    final float LIFETIME = 30.0f;
    final int LIFETIME_ALPHA_MUL = 5;
    final int MAXIMAL_ENABLED_ELEMENTS = 1100;
    final int MINIMAL_ENABLED_ELEMENTS = 550;
    final float COLOR_LOOP_MUL = 20.0f;
    final int COLOR_LOOP_MUL_MAX = 55;
    final int SIZE_SMALL = 40;
    final int RGB_SHIFT_BAND = 0;
    final int ANIMATION_CHANGE_BAND = 1;
    final int COLOR_CHANGE_BAND = 4;
    final int ANIMATION_BAND = 2;
    final int MAX_EFFECTIDX = 10;
    final int FRAME_DELAY_BETWEEN_ANIMATIONS = 8;
    final int FRAME_DELAY_BETWEEN_RGB_SHIFT = 105;
    final int NO_ANIMATION_ID = 99;
    final int STROKE_WEIGHT = 128;
    ColorSet[] allColorsets;
    int[] colorBuffer;
    int[][] selectedElement;
    int elementX;
    int elementY;
    ColorSet cs;
    int csIdx;
    int effectIdx = 99;
    float rgbShiftAmount = 0.0f;
    float rgbShiftAngle = 0.0f;
    int rgbShiftCounter = 0;
    float shakeAmount = 0.0f;
    int shakeCounter = 0;
    SoundAnalyzer sa;
    PShader shader;
    PGraphics canvas;
    float ff = 0.0f;
    float glitchX = 0.0f;
    float glitchY = 0.0f;
    TextDisplay textDisplay;
    int lastAnimationChange = 0;
    int lastColorChange = 0;
    int lastRGBShift = 0;
    int textAlphaNr = 0;
    int activeElementCount = 999;
    boolean soundActive = false;
    private static int staticId = 0;
    int directionX = 0;
    int directionPosX = 0;
    int directionY = 0;
    int directionPosY = 0;
    int fillerCnt = this.elementX;
    int cnt = 0;
    final int LINE_WIDTH = 5;
    int aniX = 3;
    int aniY = 4;
    int aniCnt = 0;
    PShape[][] circles = new PShape[3][4];

    public void setup() {
        int n = 1280;
        int n2 = 720;
        this.size(n, n2, "processing.opengl.PGraphics3D");
        this.canvas = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.elementX = 4 * n / 2 / 40;
        this.elementY = n2 / 2 / 40;
        this.colorBuffer = new int[this.elementX * this.elementY];
        this.selectedElement = new int[6][this.elementX * this.elementY];
        this.shader = this.loadShader("colorShift.glsl");
        this.shader.set("glitchOfs", 0.0f, 0.0f);
        this.shader.set("distortion", 0.2f);
        this.shader.set("zoom", 0.86f);
        this.sa = new SoundAnalyzer(this, "MineX - Raspberry (Short Edit).mp3");
        this.ellipseMode(0);
        this.shapeMode(0);
        this.smooth();
        this.frameRate(35.0f);
        this.allColorsets = new ColorSet[5];
        this.allColorsets[0] = new ColorSet("1", new int[]{this.color(-16777216), this.color(-5592406), this.color(-5592406), this.color(-855310)});
        this.allColorsets[1] = new ColorSet("2", new int[]{this.color(-16777216), this.color(-3743632), this.color(-3743632), this.color(-855310)});
        this.allColorsets[2] = new ColorSet("3", new int[]{this.color(-16777216), this.color(-7224212), this.color(-7224212), this.color(-855310)});
        this.allColorsets[3] = new ColorSet("4", new int[]{this.color(-16777216), this.color(-14123651), this.color(-14123651), this.color(-855310)});
        this.allColorsets[4] = new ColorSet("5", new int[]{this.color(-16777216), this.color(-14928819), this.color(-14928819), this.color(-855310)});
        this.csIdx = 3;
        this.cs = this.allColorsets[this.csIdx];
        this.canvas.stroke(this.cs.getSmoothColor(0), 128.0f);
        this.canvas.strokeCap(1);
        this.canvas.strokeWeight(1.0f);
        this.canvas.smooth();
        this.initCircle();
        this.textDisplay = new TextDisplay();
    }

    public void draw() {
        if (!this.soundActive) {
            this.soundActive = true;
            this.sa.play();
            return;
        }
        this.canvas.beginDraw();
        this.canvas.background(this.cs.getSmoothColor(0));
        this.canvas.stroke(this.cs.getSmoothColor(0), 170.0f);
        this.filler(this.effectIdx);
        this.sa.soundProcess();
        boolean bl = this.sa.getBandData((int)0).boom;
        boolean bl2 = this.sa.getBandData((int)1).boom;
        boolean bl3 = this.sa.getBandData((int)4).boom;
        if (bl2) {
            if (this.textDisplay.isUpdateAnimation() && this.lastAnimationChange > 8 && PApplet.parseInt((float)this.random(2.0f)) == 1) {
                this.effectIdx = PApplet.parseInt((float)this.random(10.0f));
                this.lastAnimationChange = 0;
            } else if (!this.textDisplay.isUpdateAnimation()) {
                this.effectIdx = 99;
            }
            this.selectRandomElements(this.sa.getBandData((int)1).loops, 0);
        }
        ++this.lastAnimationChange;
        if (bl3) {
            if (this.textDisplay.isUpdateColors() && this.lastColorChange > 8 && PApplet.parseInt((float)this.random(2.0f)) == 1) {
                this.cs = this.allColorsets[PApplet.parseInt((float)this.random(this.allColorsets.length - 1))];
                this.lastColorChange = 0;
            }
            this.selectRandomElements(this.sa.getBandData((int)4).loops, 3);
        }
        ++this.lastColorChange;
        if (this.rgbShiftCounter == 0 && bl && this.lastRGBShift > 105) {
            this.lastRGBShift = 0;
            this.rgbShiftCounter = 1 * this.sa.getBandData((int)0).loops;
            this.rgbShiftAmount = (float)this.sa.getBandData((int)0).loops / 2000.0f;
            this.rgbShiftAngle = this.sa.getBandData((int)0).currentBandEnergy * 720.0f % 360.0f;
        }
        ++this.lastRGBShift;
        if (this.shakeCounter < 15 && bl2) {
            this.shakeCounter = this.sa.getBandData((int)1).loops;
            this.shakeAmount = (float)(2 * this.sa.getBandData((int)1).loops) / 1400.0f;
        }
        this.drawTriangles();
        this.drawCircles();
        this.canvas.endDraw();
        this.activeElementCount = 0;
        int n = 0;
        while (n < 6) {
            int n2 = 0;
            while (n2 < this.colorBuffer.length) {
                if (this.selectedElement[n][n2] > 0) {
                    int[] nArray = this.selectedElement[n];
                    int n3 = n2;
                    nArray[n3] = nArray[n3] - 1;
                    ++this.activeElementCount;
                }
                ++n2;
            }
            ++n;
        }
        if (this.rgbShiftCounter > 0) {
            --this.rgbShiftCounter;
            this.shader.set("ammount", this.rgbShiftAmount);
            this.shader.set("angle", this.rgbShiftAngle);
        } else {
            this.shader.set("ammount", 0.0f);
        }
        if (this.shakeCounter > 0) {
            --this.shakeCounter;
            this.glitchX = CevianRaspberry.sin((float)this.shakeCounter) * this.shakeAmount;
            this.glitchY = CevianRaspberry.cos((float)this.shakeCounter) * this.shakeAmount;
            this.shader.set("glitchOfs", this.glitchX, this.glitchY);
            this.shader.set("zoom", 0.86f - this.glitchX / 2.0f);
            this.shakeAmount *= 0.6f;
        } else {
            this.shader.set("glitchOfs", 0.0f, 0.0f);
            this.shader.set("zoom", 0.86f);
        }
        this.shader(this.shader);
        this.image((PImage)this.canvas, 0.0f, 0.0f, this.width, this.height);
        this.resetShader();
        if (this.frameCount > 35) {
            this.textDisplay.showText(this.textAlphaNr);
            this.sa.drawValues(this.textAlphaNr);
            if (this.textDisplay.isOsdFadeOut()) {
                if (this.textAlphaNr > 0) {
                    --this.textAlphaNr;
                }
            } else if (this.textAlphaNr < 50) {
                ++this.textAlphaNr;
            }
        }
    }

    public void stop() {
        this.sa.closeMinim();
    }

    public void selectRandomElements(int n, int n2) {
        if (this.activeElementCount > 1100) {
            return;
        }
        if (this.activeElementCount < 550) {
            n += 27;
        }
        int n3 = this.colorBuffer.length;
        int n4 = 0;
        while (n4 < n) {
            this.selectedElement[0 + n2][PApplet.parseInt((float)this.random((float)((float)n3)))] = PApplet.parseInt((float)(90.0f + this.random(4.0f)));
            if (n4 % 2 == 1) {
                this.selectedElement[1 + n2][PApplet.parseInt((float)this.random((float)((float)n3)))] = PApplet.parseInt((float)(60.0f + this.random(4.0f)));
            }
            if (n4 % 4 == 1) {
                this.selectedElement[2 + n2][PApplet.parseInt((float)this.random((float)((float)n3)))] = PApplet.parseInt((float)(30.0f + this.random(4.0f)));
            }
            ++n4;
        }
    }

    public boolean sketchFullScreen() {
        return false;
    }

    public void filler(int n) {
        switch (n) {
            case 0: {
                this.fillerCircle();
                break;
            }
            case 1: {
                this.fillerInsideOut();
                break;
            }
            case 2: {
                this.filler6();
                break;
            }
            case 3: {
                this.filler7();
                break;
            }
            case 4: {
                this.fillerSolid();
                break;
            }
            case 5: {
                this.fillerHoVeLines();
                break;
            }
            case 6: {
                this.fillerVerticalMove();
                break;
            }
            case 7: {
                this.fillerHorizontalMove();
                break;
            }
            case 8: {
                this.fillerSnake();
                break;
            }
            case 9: {
                this.fillerRect();
                break;
            }
            case 99: {
                this.fillerNone();
            }
        }
    }

    public void fillerNone() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elementY * this.elementX) {
            this.colorBuffer[n++] = 0;
            ++n2;
        }
    }

    public void fillerSolid() {
        int n = 0;
        ++this.fillerCnt;
        if (this.fillerCnt > this.elementX * this.elementY) {
            this.fillerCnt = this.elementX;
        }
        int n2 = 0;
        while (n2 < this.elementY) {
            int n3 = 0;
            while (n3 < this.elementX) {
                this.colorBuffer[n++] = n < this.fillerCnt ? this.cnt : 0;
                ++n3;
            }
            ++n2;
        }
        this.cnt += 3;
    }

    public void fillerSnake() {
        int n = 0;
        this.directionPosX += PApplet.parseInt((float)this.random(3.0f)) - 1;
        this.directionPosY += PApplet.parseInt((float)this.random(3.0f)) - 1;
        ++this.cnt;
        this.updateYPos();
        this.updateXPos();
        int n2 = 0;
        while (n2 < this.elementY) {
            int n3 = 0;
            while (n3 < this.elementX) {
                int n4 = CevianRaspberry.abs((int)(this.directionPosY - n3));
                int n5 = CevianRaspberry.abs((int)(this.directionPosX - n2));
                this.colorBuffer[n++] = n5 < 3 && n4 < 9 ? (this.cnt + (n5 + n4)) * 4 : (this.cnt + (n5 + n4)) * 4 + 128;
                ++n3;
            }
            ++n2;
        }
    }

    public void fillerHorizontalMove() {
        int n = 0;
        if (this.cnt % 2 == 0) {
            this.updateYPos();
        }
        int n2 = 0;
        while (n2 < this.elementY) {
            int n3 = 0;
            while (n3 < this.elementX) {
                this.colorBuffer[n++] = 4 * (n3 - this.directionPosY) + (this.cnt >> 1);
                ++n3;
            }
            ++n2;
        }
        ++this.cnt;
    }

    public void fillerVerticalMove() {
        int n = 0;
        this.updateXPos();
        int n2 = 0;
        while (n2 < this.elementY) {
            int n3 = 0;
            while (n3 < this.elementX) {
                this.colorBuffer[n++] = 4 * (n2 - this.directionPosX) + (this.cnt >> 2);
                ++n3;
            }
            ++n2;
        }
        ++this.cnt;
    }

    public void fillerCircle() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elementY) {
            int n3 = 0;
            while (n3 < this.elementX) {
                this.colorBuffer[n++] = n3 * n2 + this.cnt;
                ++n3;
            }
            ++n2;
        }
        ++this.cnt;
    }

    public void fillerInsideOut() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elementY) {
            int n3 = 0;
            while (n3 < this.elementX) {
                this.colorBuffer[n++] = n3 + n2 + this.cnt;
                ++n3;
            }
            ++n2;
        }
        ++this.cnt;
    }

    public void filler6() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elementY) {
            int n3 = 0;
            while (n3 < this.elementX) {
                this.colorBuffer[n++] = n3 % (n2 + 1) + this.cnt;
                ++n3;
            }
            ++n2;
        }
        ++this.cnt;
    }

    public void filler7() {
        int n = 0;
        ++this.cnt;
        int n2 = 0;
        while (n2 < this.elementY) {
            int n3 = 0;
            while (n3 < this.elementX) {
                this.colorBuffer[n++] = (n3 + this.cnt) % (n2 + this.cnt);
                ++n3;
            }
            ++n2;
        }
    }

    public void drawRect(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        while (n6 < n4) {
            int n7 = n * 4 + this.elementX * n6;
            int n8 = 0;
            while (n8 < n3 * 4) {
                this.colorBuffer[n7++] = n5;
                ++n8;
            }
            ++n6;
        }
    }

    public void fillerRect() {
        if (this.cnt % 4 == 0) {
            int n = PApplet.parseInt((float)this.random(this.elementY));
            int n2 = PApplet.parseInt((float)this.random(this.elementY - n));
            int n3 = PApplet.parseInt((float)this.random(this.elementX / 4));
            int n4 = PApplet.parseInt((float)this.random(this.elementX / 4 - n3));
            this.drawRect(n3, n, n4, n2, PApplet.parseInt((float)this.random(255.0f)));
        }
        ++this.cnt;
    }

    public void fillerEqualizer() {
        this.drawRect(0, 0, this.elementX / 4, this.elementY, 0);
        int n = CevianRaspberry.min((int)this.sa.getFft().avgSize(), (int)(this.elementX / 8));
        CevianRaspberry.println((String)("bands: " + n));
        int n2 = 0;
        while (n2 < n) {
            float f = PApplet.parseInt((float)this.sa.getBandData((int)n2).currentBandEnergy);
            if (f > 255.0f) {
                f = 255.0f;
            }
            int n3 = PApplet.parseInt((float)(f / 255.0f * (float)this.elementY));
            this.drawRect(this.elementX / 4 - n2 * 2, 0, 2, n3, PApplet.parseInt((float)(f / 2.0f)));
            ++n2;
        }
    }

    public void fillerHoVeLines() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elementY) {
            int n3 = 0;
            while (n3 < this.elementX) {
                this.colorBuffer[n++] = n3 > this.aniX * 4 && n3 < (this.aniX + 5) * 4 || n2 > this.aniY && n2 < this.aniY + 5 ? n2 + n3 + this.cnt * 2 : 0;
                ++n3;
            }
            ++n2;
        }
        ++this.cnt;
        this.aniCnt += 4;
        if (this.aniCnt > 35) {
            this.aniCnt = 0;
            ++this.aniX;
            ++this.aniY;
            if (this.aniX >= this.elementX / 4) {
                this.aniX = -5;
            }
            if (this.aniY >= this.elementY) {
                this.aniY = -5;
            }
        }
    }

    public void updateYPos() {
        this.directionPosY = this.directionY == 0 ? ++this.directionPosY : --this.directionPosY;
        if (this.directionPosY > this.elementY - 1) {
            this.directionPosY = this.elementY - 1;
            this.directionY = 1;
        } else if (this.directionPosY < 0) {
            this.directionPosY = 0;
            this.directionY = 0;
        }
    }

    public void updateXPos() {
        this.directionPosX = this.directionX == 0 ? ++this.directionPosX : --this.directionPosX;
        if (this.directionPosX > this.elementX - 1) {
            this.directionPosX = this.elementX - 1;
            this.directionX = 1;
        } else if (this.directionPosX < 0) {
            this.directionPosX = 0;
            this.directionX = 0;
        }
    }

    public void drawCircles() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elementY) {
            int n3 = n2 * this.elementX;
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.elementX) {
                if (n3 % 4 == 0) {
                    ++n4;
                }
                if (this.selectedElement[3][n3] > 0) {
                    this.drawCircle(n4, n, 40, n3, this.selectedElement[3][n3] * 5, 0);
                }
                if (this.selectedElement[4][n3] > 0) {
                    this.drawCircle(n4 / 2, n / 2, 80, n3, this.selectedElement[4][n3] * 5, 1);
                }
                if (this.selectedElement[5][n3] > 0) {
                    this.drawCircle(n4 / 4, n / 4, 160, n3, this.selectedElement[5][n3] * 5 + 2, 2);
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
    }

    public void initCircle() {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            switch (n2) {
                case 0: {
                    n = 40;
                    break;
                }
                case 1: {
                    n = 80;
                    break;
                }
                case 2: {
                    n = 160;
                }
            }
            this.circles[n2][0] = this.createShape(32, new float[]{0.0f, 0.0f, n, n, 0.0f, 1.5707964f});
            this.circles[n2][1] = this.createShape(32, new float[]{0.0f, 0.0f, n, n, 1.5707964f, (float)Math.PI});
            this.circles[n2][2] = this.createShape(32, new float[]{0.0f, 0.0f, n, n, (float)Math.PI, 4.712389f});
            this.circles[n2][3] = this.createShape(32, new float[]{0.0f, 0.0f, n, n, 4.712389f, (float)Math.PI * 2});
            this.circles[n2][0].setStrokeWeight(1.0f);
            this.circles[n2][1].setStrokeWeight(1.0f);
            this.circles[n2][2].setStrokeWeight(1.0f);
            this.circles[n2][3].setStrokeWeight(1.0f);
            ++n2;
        }
    }

    public void drawCircle(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n * n3 + n3 / 2;
        int n8 = n2 * n3 + n3 / 2;
        int n9 = n4 % 4;
        this.circles[n6][n9].setFill(this.cs.getSmoothColor(this.colorBuffer[n4], n5));
        this.circles[n6][n9].setStroke(this.cs.getSmoothColor(this.colorBuffer[n4] + 128, 128));
        this.canvas.shape(this.circles[n6][n9], (float)n7, (float)n8);
    }

    public void drawTriangles() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elementY) {
            int n3 = n2 * this.elementX;
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.elementX) {
                if (n3 % 4 == 0) {
                    ++n4;
                }
                if (this.selectedElement[0][n3] > 0) {
                    this.drawQuader(n4, n, 40, n3, this.selectedElement[0][n3] * 5);
                }
                if (this.selectedElement[1][n3] > 0) {
                    this.drawQuader(n4 / 2, n / 2, 80, n3, this.selectedElement[1][n3] * 5);
                }
                if (this.selectedElement[2][n3] > 0) {
                    this.drawQuader(n4 / 4, n / 4, 160, n3, this.selectedElement[2][n3] * 5 + 2);
                }
                ++n3;
                ++n5;
            }
            ++n;
            ++n2;
        }
    }

    public void setDrawOptions(int n, int n2) {
        if (n2 > 255) {
            n2 = 255;
        }
        this.canvas.fill(this.cs.getSmoothColor(this.colorBuffer[n]), (float)n2);
        this.canvas.stroke(this.cs.getSmoothColor(this.colorBuffer[n] + 128), 128.0f);
    }

    public void drawQuader(int n, int n2, int n3, int n4, int n5) {
        int n6 = n * n3;
        int n7 = n2 * n3;
        int n8 = n3 / 2;
        int n9 = n4 % 4;
        this.setDrawOptions(n4, n5);
        if (n9 == 0) {
            this.canvas.triangle((float)n6, (float)n7, (float)n6, (float)(n7 + n3), (float)(n6 + n8), (float)(n7 + n8));
            return;
        }
        if (n9 == 1) {
            this.canvas.triangle((float)n6, (float)n7, (float)(n6 + n3), (float)n7, (float)(n6 + n8), (float)(n7 + n8));
            return;
        }
        if (n9 == 2) {
            this.canvas.triangle((float)(n6 + n3), (float)n7, (float)(n6 + n3), (float)(n7 + n3), (float)(n6 + n8), (float)(n7 + n8));
            return;
        }
        this.canvas.triangle((float)n6, (float)(n7 + n3), (float)(n6 + n3), (float)(n7 + n3), (float)(n6 + n8), (float)(n7 + n8));
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "CevianRaspberry"};
        if (stringArray != null) {
            PApplet.main((String[])CevianRaspberry.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class BandData {
        float currentBandEnergy;
        float maxBandEnergy;
        boolean boom;
        int boomBounceProtect;
        int loops;

        BandData() {
        }
    }

    public class ColorSet {
        private String name;
        private int id;
        private int[] colors;
        private int boarderCount;

        public ColorSet(String string, int[] nArray) {
            this.name = string;
            int n = staticId;
            staticId = n + 1;
            this.id = n;
            this.colors = (int[])nArray.clone();
            this.boarderCount = PApplet.parseInt((float)(255.0f / (float)nArray.length + 0.5f));
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public int getRandomColor() {
            int n = PApplet.parseInt((float)CevianRaspberry.this.random(this.colors.length));
            return this.colors[n];
        }

        public int getSmoothColor(int n) {
            int n2 = (n & 0xFF) % 255;
            int n3 = 0;
            while (n2 > this.boarderCount) {
                n2 -= this.boarderCount;
                ++n3;
            }
            int n4 = (n3 + 1) % this.colors.length;
            return this.calcSmoothColor(this.colors[n4], this.colors[n3], n2);
        }

        public int getSmoothColor(int n, int n2) {
            if (n2 > 255) {
                n2 = 255;
            }
            int n3 = (n & 0xFF) % 255;
            int n4 = 0;
            while (n3 > this.boarderCount) {
                n3 -= this.boarderCount;
                ++n4;
            }
            int n5 = (n4 + 1) % this.colors.length;
            return this.calcSmoothColor(this.colors[n5], this.colors[n4], n3, n2);
        }

        private int calcSmoothColor(int n, int n2, int n3) {
            int n4 = n & 0xFF;
            int n5 = n >> 8 & 0xFF;
            int n6 = n >> 16 & 0xFF;
            int n7 = n2 & 0xFF;
            int n8 = n2 >> 8 & 0xFF;
            int n9 = n2 >> 16 & 0xFF;
            int n10 = n3 * this.colors.length;
            int n11 = 255 - n10;
            n6 = n6 * n10 / 255;
            n5 = n5 * n10 / 255;
            n4 = n4 * n10 / 255;
            return CevianRaspberry.this.color(n6 += n9 * n11 / 255, n5 += n8 * n11 / 255, n4 += n7 * n11 / 255);
        }

        private int calcSmoothColor(int n, int n2, int n3, int n4) {
            int n5 = n & 0xFF;
            int n6 = n >> 8 & 0xFF;
            int n7 = n >> 16 & 0xFF;
            int n8 = n2 & 0xFF;
            int n9 = n2 >> 8 & 0xFF;
            int n10 = n2 >> 16 & 0xFF;
            int n11 = n3 * this.colors.length;
            int n12 = 255 - n11;
            n7 = n7 * n11 / 255;
            n6 = n6 * n11 / 255;
            n5 = n5 * n11 / 255;
            return CevianRaspberry.this.color(n7 += n10 * n12 / 255, n6 += n9 * n12 / 255, n5 += n8 * n12 / 255, n4);
        }
    }

    class SoundAnalyzer {
        private int BANDS = 6;
        private float AVG_TRIGGER_MINIMUM = 5.5f;
        private float MINIMUM_ENERGY = 10.0f;
        private int BOUNCE_PROTECT = 2;
        private BandData[] band;
        private Minim minim;
        private AudioPlayer player;
        private FFT fft;
        private int numZones = 0;
        private int FFT_BASE_FREQ = 21;
        private int FFT_BAND_PER_OCT = 1;
        private final int SAMPLE_RATE = 44100;
        private final int BUFFER_SIZE = 2048;

        public SoundAnalyzer(PApplet pApplet, String string) {
            this.minim = new Minim((Object)pApplet);
            this.player = this.minim.loadFile(string, 2048);
            this.fft = new FFT(2048, 44100.0f);
            this.fft.logAverages(this.FFT_BASE_FREQ, this.FFT_BAND_PER_OCT);
            this.fft.window(FFT.HAMMING);
            this.numZones = this.fft.avgSize();
            this.band = new BandData[this.fft.avgSize()];
            int n = 0;
            while (n < this.fft.avgSize()) {
                this.band[n] = new BandData();
                ++n;
            }
        }

        public void play() {
            this.player.play();
        }

        public void closeMinim() {
            this.player.pause();
            this.player.close();
            this.minim.stop();
        }

        public void soundProcess() {
            this.fft.forward(this.player.mix);
            int n = 0;
            while (n < this.BANDS) {
                this.band[n].currentBandEnergy = this.getBandEnergy(n);
                if (this.band[n].boomBounceProtect == 0) {
                    this.band[n].boom = false;
                }
                if (this.band[n].currentBandEnergy < this.MINIMUM_ENERGY || this.band[n].boomBounceProtect > 0) {
                    if (this.band[n].boomBounceProtect > 0) {
                        --this.band[n].boomBounceProtect;
                    }
                    this.band[n].maxBandEnergy -= 2.9f;
                    if (this.band[n].maxBandEnergy < 0.1f) {
                        this.band[n].maxBandEnergy = 0.1f;
                    }
                } else {
                    if (this.band[n].boomBounceProtect > 0) {
                        --this.band[n].boomBounceProtect;
                    }
                    if (this.band[n].currentBandEnergy > this.band[n].maxBandEnergy) {
                        float f = CevianRaspberry.this.random(5.0f) + 20.0f;
                        this.band[n].loops = PApplet.parseInt((float)(f * this.band[n].currentBandEnergy / this.band[n].maxBandEnergy));
                        if (this.band[n].loops > 55) {
                            this.band[n].loops = 55;
                        }
                        this.band[n].boom = true;
                        this.band[n].boomBounceProtect = this.BOUNCE_PROTECT;
                        this.band[n].maxBandEnergy = this.band[n].currentBandEnergy;
                    } else {
                        this.band[n].maxBandEnergy -= 2.9f;
                        if (this.band[n].maxBandEnergy < 0.1f) {
                            this.band[n].maxBandEnergy = 0.1f;
                        }
                    }
                }
                ++n;
            }
        }

        public void drawValues(int n) {
            int n2 = CevianRaspberry.this.textDisplay.getGx();
            int n3 = 210 + CevianRaspberry.this.textDisplay.getGy();
            CevianRaspberry.this.fill(255, n);
            int n4 = 0;
            while (n4 < this.BANDS) {
                CevianRaspberry.this.text(String.valueOf(this.band[n4].currentBandEnergy), n2, n3 + n4 * 50);
                ++n4;
            }
        }

        public void drawEq() {
            int n = 0;
            while (n < this.BANDS) {
                CevianRaspberry.this.fill(110 + n * 10, 255.0f);
                CevianRaspberry.this.rect(n * 50, CevianRaspberry.this.height, 50.0f, -this.band[n].currentBandEnergy);
                if (this.band[n].boom) {
                    CevianRaspberry.this.fill(255.0f, 0.0f, 0.0f, 255.0f);
                    CevianRaspberry.this.rect(n * 50 + 25, CevianRaspberry.this.height, 25.0f, -20.0f);
                }
                CevianRaspberry.this.fill(0.0f, 255.0f, 0.0f, 128.0f);
                CevianRaspberry.this.rect(n * 50, CevianRaspberry.this.height, 10.0f, -this.band[n].maxBandEnergy);
                CevianRaspberry.this.text(String.valueOf(this.band[n].currentBandEnergy), 100.0f, n * 50);
                ++n;
            }
        }

        private float getBandEnergy(int n) {
            int n2 = this.numZones - 1;
            this.fft.getAvg(n);
            float f = 0.0f;
            int n3 = n == 0 ? 0 : (int)(22050.0f / (float)Math.pow(2.0, this.numZones - n));
            int n4 = (int)(22050.0f / (float)Math.pow(2.0, n2 - n));
            int n5 = this.fft.freqToIndex((float)n3);
            int n6 = this.fft.freqToIndex((float)n4);
            int n7 = n5;
            while (n7 <= n6) {
                float f2 = this.fft.getBand(n7);
                f += f2;
                ++n7;
            }
            return f /= (float)(n6 - n5 + 1);
        }

        public BandData getBandData(int n) {
            return this.band[n];
        }

        public FFT getFft() {
            return this.fft;
        }
    }

    class TextDisplay {
        private final long DISPLAY_TIME_IN_MS = 3000L;
        private final long WAIT_TIME_IN_MS = 1000L;
        private final long FADE_TIME_IN_MS = 500L;
        private final boolean LOOP = false;
        private float displayOfsX = 0.0f;
        private int displayOfsY = 0;
        private int txtAlpha = 0;
        private int ofs = 0;
        private String[] content = new String[54];
        private String[] geoTerms;
        private PFont font;
        private int enableColor = 999;
        private int enableAnimation = 999;
        private int disableColor = 999;
        private int disableAnimation = 999;
        private int fadeOutOsd = 999;
        private int exitSketch = -1;
        private boolean updateColors = false;
        private boolean updateAnimation = false;
        private boolean osdFadeOut = false;
        private int gx;
        private int gy;
        private boolean timeInitialized = false;
        int state = 0;
        long startTime;
        long initialTime;
        int geoTermIdx = 0;

        public TextDisplay() {
            int n = 0;
            this.content[n++] = "";
            this.content[n++] = "VANTAGE (WD) AND PIXELINVADERS";
            this.content[n++] = "PRESENT";
            this.content[n++] = "A DEMO FOR";
            this.enableColor(n);
            this.content[n++] = "DEMODAYS 2013";
            this.content[n++] = "called \"Cevian Raspberry\"";
            this.enableAnimation(n);
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.disableAnimation(n);
            this.content[n++] = "credits";
            this.content[n++] = "code/design: michu/pxv/vtg";
            this.content[n++] = "pixelinvaders.ch";
            this.content[n++] = "music: minex";
            this.content[n++] = "soundcloud.com/minex";
            this.fadeOutOsd(n);
            this.content[n++] = "";
            this.content[n++] = "";
            this.content[n++] = "";
            this.exitSketch(n);
            this.content[n++] = "";
            n = 0;
            this.geoTerms = new String[24];
            this.geoTerms[n++] = "Annulus";
            this.geoTerms[n++] = "Apothem";
            this.geoTerms[n++] = "Adjacent";
            this.geoTerms[n++] = "Abscissa";
            this.geoTerms[n++] = "Cevian";
            this.geoTerms[n++] = "Concentric";
            this.geoTerms[n++] = "Heptagon";
            this.geoTerms[n++] = "icosahedron";
            this.geoTerms[n++] = "Radicand";
            this.geoTerms[n++] = "Oblique";
            this.geoTerms[n++] = "Semicircle";
            this.geoTerms[n++] = "Tessellate";
            this.geoTerms[n++] = "Contraction";
            this.geoTerms[n++] = "Equidistant";
            this.geoTerms[n++] = "Glide";
            this.geoTerms[n++] = "Dodecagon";
            this.geoTerms[n++] = "Invariant";
            this.geoTerms[n++] = "Mean";
            this.geoTerms[n++] = "Vertex";
            this.geoTerms[n++] = "Segment";
            this.geoTerms[n++] = "sin";
            this.geoTerms[n++] = "cos";
            this.geoTerms[n++] = "arc";
            this.geoTerms[n++] = "tan";
            this.font = CevianRaspberry.this.loadFont("OstrichSansRounded-Medium-72.vlw");
            CevianRaspberry.this.textFont(this.font, 72.0f);
            CevianRaspberry.this.textSize(72.0f);
            CevianRaspberry.this.textAlign(37, 101);
        }

        public void showText(int n) {
            if (!this.timeInitialized) {
                this.initFsm();
                this.timeInitialized = true;
                this.initialTime = this.startTime;
                return;
            }
            this.gx = PApplet.parseInt((float)(500.0f * CevianRaspberry.this.glitchX));
            this.gy = PApplet.parseInt((float)(500.0f * CevianRaspberry.this.glitchY));
            CevianRaspberry.this.fill(255, n);
            CevianRaspberry.this.text(CevianRaspberry.this.activeElementCount, this.gx, this.gy + 50);
            if (CevianRaspberry.this.frameCount % 5 == 2) {
                this.geoTermIdx = PApplet.parseInt((float)CevianRaspberry.this.random(this.geoTerms.length));
            }
            CevianRaspberry.this.text(this.geoTerms[this.geoTermIdx], this.gx, this.gy);
            if (this.state == 99) {
                return;
            }
            CevianRaspberry.this.fill(255, this.txtAlpha);
            if (!this.content[this.ofs].isEmpty()) {
                CevianRaspberry.this.text(this.content[this.ofs], this.displayOfsX - (float)this.gx, this.displayOfsY - this.gy);
            }
            switch (this.state) {
                case 0: {
                    if (this.txtAlpha < 128) {
                        this.txtAlpha = this.increaseAlpha();
                        break;
                    }
                    this.updateState(1);
                    break;
                }
                case 1: {
                    this.displayOfsX -= 0.5f;
                    if (this.waitIsOver(3000L)) {
                        this.updateState(2);
                    }
                    if (this.ofs == this.enableColor) {
                        this.updateColors = true;
                    }
                    if (this.ofs == this.enableAnimation) {
                        this.updateAnimation = true;
                    }
                    if (this.ofs == this.disableColor) {
                        this.updateColors = false;
                    }
                    if (this.ofs == this.disableAnimation) {
                        this.updateAnimation = false;
                    }
                    if (this.ofs == this.exitSketch) {
                        CevianRaspberry.this.exit();
                    }
                    if (this.ofs != this.fadeOutOsd) break;
                    this.osdFadeOut = true;
                    break;
                }
                case 2: {
                    this.displayOfsX -= 0.5f;
                    if (this.txtAlpha > 1) {
                        this.txtAlpha = this.decreaseAlpha();
                        break;
                    }
                    this.updateState(3);
                    break;
                }
                case 3: {
                    if (!this.waitIsOver(1000L)) break;
                    this.initFsm();
                    if (this.ofs++ < this.content.length - 1) break;
                    this.state = 99;
                }
            }
        }

        private void updateState(int n) {
            this.state = n;
            this.startTime = System.currentTimeMillis();
            if (n == 1 && this.ofs > 0) {
                long l = this.startTime - this.initialTime - (long)this.ofs * 5000L;
                this.startTime -= l;
            }
        }

        private int increaseAlpha() {
            long l = System.currentTimeMillis() - this.startTime;
            float f = 128.0f * ((float)l / 500.0f);
            if (f > 128.0f) {
                f = 128.0f;
            }
            return PApplet.parseInt((float)f);
        }

        private int decreaseAlpha() {
            return 128 - this.increaseAlpha();
        }

        private boolean waitIsOver(long l) {
            long l2 = System.currentTimeMillis() - this.startTime;
            return l2 > l;
        }

        public boolean isUpdateColors() {
            return this.updateColors;
        }

        public boolean isUpdateAnimation() {
            return this.updateAnimation;
        }

        public boolean isOsdFadeOut() {
            return this.osdFadeOut;
        }

        private void enableColor(int n) {
            this.enableColor = n;
        }

        private void fadeOutOsd(int n) {
            this.fadeOutOsd = n;
        }

        private void enableAnimation(int n) {
            this.enableAnimation = n;
        }

        private void disableColor(int n) {
            this.disableColor = n;
        }

        private void disableAnimation(int n) {
            this.disableAnimation = n;
        }

        private void exitSketch(int n) {
            this.exitSketch = n;
        }

        private void initFsm() {
            this.state = 0;
            this.txtAlpha = 0;
            this.startTime = System.currentTimeMillis();
            this.displayOfsX = CevianRaspberry.this.width - 800 + PApplet.parseInt((float)CevianRaspberry.this.random(100.0f));
            this.displayOfsY = CevianRaspberry.this.height - 200 + PApplet.parseInt((float)CevianRaspberry.this.random(100.0f));
        }

        public int getGx() {
            return this.gx;
        }

        public int getGy() {
            return this.gy;
        }
    }
}

