/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.newt.Display;
import java.util.Comparator;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.SurfaceSize;

public class MonitorMode
implements Comparable<MonitorMode> {
    public static final Comparator<MonitorMode> monitorModeComparator = new Comparator<MonitorMode>(){

        @Override
        public int compare(MonitorMode monitorMode, MonitorMode monitorMode2) {
            return monitorMode.compareTo(monitorMode2);
        }
    };
    public static final Comparator<MonitorMode> monitorModeComparatorInv = new Comparator<MonitorMode>(){

        @Override
        public int compare(MonitorMode monitorMode, MonitorMode monitorMode2) {
            return monitorMode2.compareTo(monitorMode);
        }
    };
    public static final int ROTATE_0 = 0;
    public static final int ROTATE_90 = 90;
    public static final int ROTATE_180 = 180;
    public static final int ROTATE_270 = 270;
    public static final int FLAG_INTERLACE = 1;
    public static final int FLAG_DOUBLESCAN = 2;
    private final int nativeId;
    private final SizeAndRRate sizeAndRRate;
    private final int rotation;
    private final int hashCode;

    public static boolean isRotationValid(int n) {
        return n == 0 || n == 90 || n == 180 || n == 270;
    }

    public MonitorMode(int n, SizeAndRRate sizeAndRRate, int n2) {
        if (!MonitorMode.isRotationValid(n2)) {
            throw new RuntimeException("invalid rotation: " + n2);
        }
        this.nativeId = n;
        this.sizeAndRRate = sizeAndRRate;
        this.rotation = n2;
        this.hashCode = this.getHashCode();
    }

    public MonitorMode(SurfaceSize surfaceSize, float f, int n, int n2) {
        this(0, new SizeAndRRate(surfaceSize, f, n), n2);
    }

    public final int getId() {
        return this.nativeId;
    }

    public final SizeAndRRate getSizeAndRRate() {
        return this.sizeAndRRate;
    }

    public final SurfaceSize getSurfaceSize() {
        return this.sizeAndRRate.surfaceSize;
    }

    public final float getRefreshRate() {
        return this.sizeAndRRate.refreshRate;
    }

    public final int getFlags() {
        return this.sizeAndRRate.flags;
    }

    public final int getRotation() {
        return this.rotation;
    }

    public final int getRotatedWidth() {
        return this.getRotatedWH(true);
    }

    public final int getRotatedHeight() {
        return this.getRotatedWH(false);
    }

    public final String toString() {
        return "[Id " + Display.toHexString(this.nativeId) + ", " + this.sizeAndRRate + ", " + this.rotation + " degr]";
    }

    @Override
    public int compareTo(MonitorMode monitorMode) {
        int n = this.sizeAndRRate.compareTo(monitorMode.sizeAndRRate);
        if (0 != n) {
            return n;
        }
        int n2 = 360 - this.rotation;
        int n3 = 360 - monitorMode.rotation;
        if (n2 > n3) {
            return 1;
        }
        if (n2 < n3) {
            return -1;
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MonitorMode) {
            MonitorMode monitorMode = (MonitorMode)object;
            return monitorMode.nativeId == this.nativeId && monitorMode.sizeAndRRate.equals(this.sizeAndRRate) && monitorMode.rotation == this.rotation;
        }
        return false;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    private final int getHashCode() {
        int n = 31 + this.getId();
        n = (n << 5) - n + this.sizeAndRRate.hashCode();
        n = (n << 5) - n + this.getRotation();
        return n;
    }

    private final int getRotatedWH(boolean bl) {
        boolean bl2;
        DimensionImmutable dimensionImmutable = this.sizeAndRRate.surfaceSize.getResolution();
        boolean bl3 = bl2 = 90 == this.rotation || 270 == this.rotation;
        if (bl && bl2 || !bl && !bl2) {
            return dimensionImmutable.getHeight();
        }
        return dimensionImmutable.getWidth();
    }

    public static class SizeAndRRate
    implements Comparable<SizeAndRRate> {
        public final SurfaceSize surfaceSize;
        public final int flags;
        public final float refreshRate;
        public final int hashCode;
        private static final String STR_INTERLACE = "Interlace";
        private static final String STR_DOUBLESCAN = "DoubleScan";
        private static final String STR_SEP = ", ";

        public SizeAndRRate(SurfaceSize surfaceSize, float f, int n) {
            if (null == surfaceSize) {
                throw new IllegalArgumentException("surfaceSize must be set (" + surfaceSize + ")");
            }
            this.surfaceSize = surfaceSize;
            this.flags = n;
            this.refreshRate = f;
            this.hashCode = this.getHashCode();
        }

        public static final StringBuilder flags2String(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (0 != (n & 1)) {
                stringBuilder.append(STR_INTERLACE);
                bl = true;
            }
            if (0 != (n & 2)) {
                if (bl) {
                    stringBuilder.append(STR_SEP);
                }
                stringBuilder.append(STR_DOUBLESCAN);
                bl = true;
            }
            return stringBuilder;
        }

        public final String toString() {
            return new String(this.surfaceSize + " @ " + this.refreshRate + " Hz, flags [" + SizeAndRRate.flags2String(this.flags).toString() + "]");
        }

        @Override
        public int compareTo(SizeAndRRate sizeAndRRate) {
            int n;
            int n2 = this.surfaceSize.compareTo(sizeAndRRate.surfaceSize);
            if (0 != n2) {
                return n2;
            }
            int n3 = 0 == this.flags ? Integer.MAX_VALUE : this.flags;
            int n4 = n = 0 == sizeAndRRate.flags ? Integer.MAX_VALUE : sizeAndRRate.flags;
            if (n3 == n) {
                float f = this.refreshRate - sizeAndRRate.refreshRate;
                if (Math.abs(f) < 0.01f) {
                    return 0;
                }
                if (f > 0.01f) {
                    return 1;
                }
                return -1;
            }
            if (n3 > n) {
                return 1;
            }
            if (n3 < n) {
                return -1;
            }
            return 0;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof SizeAndRRate) {
                SizeAndRRate sizeAndRRate = (SizeAndRRate)object;
                return this.surfaceSize.equals(sizeAndRRate.surfaceSize) && this.flags == sizeAndRRate.flags && this.refreshRate == sizeAndRRate.refreshRate;
            }
            return false;
        }

        public final int hashCode() {
            return this.hashCode;
        }

        private final int getHashCode() {
            int n = 31 + this.surfaceSize.hashCode();
            n = (n << 5) - n + this.flags;
            n = (n << 5) - n + (int)(this.refreshRate * 100.0f);
            return n;
        }
    }
}

